/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityweb.service.balance.impl;

import com.ohaotian.abilitycommon.config.nodedata.NodeInfoConfig;
import com.ohaotian.abilitycommon.enums.LoadBalanceEnum;
import com.ohaotian.abilitycommon.exception.AbilityException;
import com.ohaotian.abilitycommon.model.bo.CodeMsg;
import com.ohaotian.abilitycommon.model.bo.RegionAddrBO;
import com.ohaotian.abilitycommon.model.bo.RegionBO;
import com.ohaotian.abilitycommon.model.bo.system.MsgContext;
import com.ohaotian.abilitycommon.model.bo.system.SelfDefHeader;
import com.ohaotian.abilityweb.mapper.RegionAddrMapper;
import com.ohaotian.abilityweb.model.po.RegionAddrPO;
import com.ohaotian.abilityweb.service.balance.LoadBalance;
import com.ohaotian.abilityweb.service.balance.LoadBalanceService;
import com.ohaotian.abilityweb.service.balance.factory.LoadBalanceFactory;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class LoadBalanceServiceImpl
implements LoadBalanceService {
    @Resource
    RegionAddrMapper regionAddrMapper;
    @Resource
    NodeInfoConfig nodeInfoConfig;

    @Override
    public void getRegionAddr(MsgContext msgContext) throws AbilityException {
        List<RegionAddrBO> regionAddrPOList = this.queryRegionAddrList(msgContext);
        this.setRegionAddr(0, regionAddrPOList, msgContext);
    }

    private void setRegionAddr(int addrType, List<RegionAddrBO> regionAddrPOList, MsgContext msgContext) throws AbilityException {
        if (CollectionUtils.isEmpty(regionAddrPOList)) {
            throw new AbilityException(CodeMsg.E_HREGION_ADDR_NO_USED);
        }
        SelfDefHeader selfDefHeader = msgContext.getSelfDefHeader();
        RegionBO regionBO = selfDefHeader.getRegionBO();
        LoadBalance loadBalance = LoadBalanceFactory.of(LoadBalanceEnum.getLoadBalanceByCode((int)regionBO.getHaddrPolicy()));
        RegionAddrBO regionAddrBO = loadBalance.select(regionAddrPOList);
        if (addrType == 0) {
            selfDefHeader.setRegionAddrBO(regionAddrBO);
        } else if (addrType == 1) {
            selfDefHeader.setAgentRegionAddrBO(regionAddrBO);
        }
        msgContext.setSelfDefHeader(selfDefHeader);
    }

    @Override
    public List<RegionAddrBO> queryRegionAddrList(MsgContext msgContext) throws AbilityException {
        RegionBO regionBO = msgContext.getSelfDefHeader().getRegionBO();
        long regionId = regionBO.getRegionId();
        RegionAddrPO regionAddrPO = new RegionAddrPO();
        regionAddrPO.setRegionId(regionId);
        regionAddrPO.setAttendStatus(1);
        return this.regionAddrMapper.queryByCond(regionAddrPO);
    }
}

