/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityweb.service.check.message;

import com.ohaotian.abilitycommon.exception.AbilityException;
import com.ohaotian.abilitycommon.model.bo.CodeMsg;
import com.ohaotian.abilityweb.service.check.message.MessgeService;
import com.ohaotian.abilityweb.service.check.message.impl.FormDataMessageService;
import com.ohaotian.abilityweb.service.check.message.impl.JsonMessgeService;
import com.ohaotian.abilityweb.service.check.message.impl.WsMessgeService;
import com.ohaotian.abilityweb.service.check.message.impl.XmlMessgeService;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public class MessageProtocolFactory {
    static final Map<String, Supplier<MessgeService>> map = new HashMap<String, Supplier<MessgeService>>();

    public static MessgeService getInstance(String type) {
        Supplier<MessgeService> validMessgeServiceSupplier = map.get(type);
        if (validMessgeServiceSupplier != null) {
            return validMessgeServiceSupplier.get();
        }
        throw new AbilityException(CodeMsg.E_CONTENT_TYPE_NOT_FOUND.fillArgs(new Object[]{"type:" + type}));
    }

    static {
        map.put("json", JsonMessgeService::new);
        map.put("ws", WsMessgeService::new);
        map.put("xml", XmlMessgeService::new);
        map.put("hsf", JsonMessgeService::new);
        map.put("dubbo", JsonMessgeService::new);
        map.put("formData", FormDataMessageService::new);
    }
}

