/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityweb.service.check.message.impl;

import com.ohaotian.abilitycommon.constant.Constants;
import com.ohaotian.abilitycommon.exception.AbilityException;
import com.ohaotian.abilitycommon.model.bo.CodeMsg;
import com.ohaotian.abilitycommon.model.bo.system.MsgContext;
import com.ohaotian.abilitycommon.model.bo.system.TlogRspHeader;
import com.ohaotian.abilityweb.model.po.AbilityParamPO;
import com.ohaotian.abilityweb.service.check.message.MessgeService;
import java.io.ByteArrayInputStream;
import java.util.HashMap;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Validator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.StringUtils;
import org.xml.sax.SAXParseException;

public class XmlMessgeService
implements MessgeService {
    private static Logger logger = LogManager.getLogger(XmlMessgeService.class);

    @Override
    public void validReqMessage(MsgContext msgContext) throws AbilityException {
        try {
            Validator validator = msgContext.getEsbAbility().getXsdInputSchema().newValidator();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(msgContext.getTlogReqHeader().getReqData());
            validator.validate(new StreamSource(inputStream));
        }
        catch (SAXParseException e) {
            logger.error("\u54cd\u5e94\u62a5\u6587\u683c\u5f0f\u9519\u8bef", (Throwable)e);
            throw new AbilityException(CodeMsg.E_REQ_VALID_REQ_ERROR.fillArgs(new Object[]{":\u62a5\u6587\u4e2d\u7b2c" + e.getLineNumber() + "\u884c,\u7b2c" + e.getColumnNumber() + "\u4f4d,\u9519\u8bef\u4fe1\u606f:" + e.toString()}));
        }
        catch (Exception e) {
            logger.error("\u54cd\u5e94\u62a5\u6587\u683c\u5f0f\u9519\u8bef", (Throwable)e);
            throw new AbilityException(CodeMsg.E_REQ_VALID_REQ_ERROR.fillArgs(new Object[]{":" + e.getMessage()}));
        }
    }

    @Override
    public void validRspMessage(MsgContext msgContext) throws AbilityException {
        try {
            Validator validator = msgContext.getEsbAbility().getXsdOutputSchema().newValidator();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(msgContext.getTlogRspHeader().getRspData());
            validator.validate(new StreamSource(inputStream));
        }
        catch (SAXParseException e) {
            throw new AbilityException(CodeMsg.E_REQ_VALID_RSP_ERROR.fillArgs(new Object[]{":\u62a5\u6587\u4e2d\u7b2c" + e.getLineNumber() + "\u884c,\u7b2c" + e.getColumnNumber() + "\u4f4d,\u9519\u8bef\u4fe1\u606f:" + e.getMessage()}));
        }
        catch (Exception e) {
            logger.error("\u54cd\u5e94\u62a5\u6587\u683c\u5f0f\u9519\u8bef", (Throwable)e);
            throw new AbilityException(CodeMsg.E_REQ_VALID_RSP_ERROR.fillArgs(new Object[]{":" + e.getMessage()}));
        }
    }

    @Override
    public void checkDataEqualsOut(MsgContext msgContext) {
        if (Constants.OutTypeList.xmlList.contains(msgContext.getEsbAbility().getOutputProtocal())) {
            msgContext.setUniformityFlag(Boolean.valueOf(true));
        }
    }

    @Override
    public String getMockMsg(MsgContext msgContext, AbilityParamPO abilityParamPO) {
        TlogRspHeader tlogRspHeader = new TlogRspHeader();
        HashMap<String, String> map = new HashMap<String, String>(8);
        map.put("Content-Type", "text/xml");
        tlogRspHeader.setHeaders(map);
        msgContext.setTlogRspHeader(tlogRspHeader);
        if (StringUtils.isEmpty((Object)abilityParamPO.getRspWsTemplate())) {
            throw new AbilityException(CodeMsg.E_REQ_VALID_RSP_ERROR.fillArgs(new Object[]{":webservice\u8fd4\u56demock\u6570\u636e\u529f\u80fd\u8bf7\u81ea\u884c\u4fdd\u5b58\u6570\u636e"}));
        }
        return abilityParamPO.getRspWsTemplate();
    }

    @Override
    public String getcontentType() {
        return "application/xml";
    }
}

