/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityweb.service.check.subscribe;

import com.ohaotian.abilitycommon.model.bo.AbilityPluginBO;
import com.ohaotian.abilitycommon.model.bo.system.MsgContext;
import com.ohaotian.abilityweb.service.check.subscribe.SubscribeCheckService;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class FactoryForSubscribeCheck {
    public static final String OAUTH2_CHECK = "oauth2Check";
    public static final String TOKEN_CHECK = "tokenCheck";
    @Autowired
    Map<String, SubscribeCheckService> strategys = new ConcurrentHashMap<String, SubscribeCheckService>(3);
    @Resource(name="tokenCheck")
    private SubscribeCheckService subscribeCheckService;

    public SubscribeCheckService getStrategy(MsgContext msgContext) {
        List abilityPluginBOList = msgContext.getEsbAbility().getAbilityPluginBOList();
        for (AbilityPluginBO abilityPluginBO : abilityPluginBOList) {
            SubscribeCheckService strategy;
            if (!"oauth2".equalsIgnoreCase(abilityPluginBO.getPluginType()) || ObjectUtils.isEmpty((Object)(strategy = this.strategys.get(OAUTH2_CHECK)))) continue;
            return strategy;
        }
        return this.subscribeCheckService;
    }
}

