/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityweb.service.client.http;

import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;

public abstract class HttpClientStaticFactory {
    public static CloseableHttpClient getHttpClient() {
        return HttpClientBuilder.create().build();
    }

    public static CloseableHttpClient getHttpClientAndTrustAll() throws Exception {
        SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)new org.apache.http.conn.ssl.TrustStrategy(){

            public boolean isTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                return true;
            }
        }).build();
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, new String[]{"TLSv1"}, null, (hostname, session) -> true);
        Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)sslsf).build();
        return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
    }

    public static CloseableHttpClient getHttpClientWithCertificateBySecurity(InputStream keyStoreInputStream, String keyStorePass) throws Exception {
        KeyStore ks = KeyStore.getInstance("PKCS12");
        ks.load(keyStoreInputStream, keyStorePass.toCharArray());
        SSLContext sslContext = SSLContexts.custom().loadKeyMaterial(ks, keyStorePass.toCharArray()).build();
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext);
        Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)sslsf).build();
        keyStoreInputStream.close();
        return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
    }

    public static CloseableHttpClient getHttpClientWithCertificateAndTrustAll(InputStream keyStoreInputStream, String keyStorePass) throws Exception {
        KeyStore ks = KeyStore.getInstance("PKCS12");
        ks.load(keyStoreInputStream, keyStorePass.toCharArray());
        SSLContext sslContext = SSLContexts.custom().loadKeyMaterial(ks, keyStorePass.toCharArray()).loadTrustMaterial(null, (TrustStrategy)new org.apache.http.conn.ssl.TrustStrategy(){

            public boolean isTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                return true;
            }
        }).build();
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, new String[]{"TLSv1"}, null, (hostname, session) -> true);
        Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)sslsf).build();
        keyStoreInputStream.close();
        return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
    }

    public static CloseableHttpClient getHttpClientWithTrustStore(InputStream trustStoreInputStream, String trustStorePass) throws Exception {
        KeyStore tks = KeyStore.getInstance("JKS");
        tks.load(trustStoreInputStream, trustStorePass.toCharArray());
        SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(tks, (TrustStrategy)new TrustSelfSignedStrategy()).build();
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext);
        Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)sslsf).build();
        trustStoreInputStream.close();
        return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
    }

    public static CloseableHttpClient getHttpClient(InputStream keyStoreInputStream, String keyStorePass, InputStream trustStoreInputStream, String trustStorePass) throws Exception {
        KeyStore ks = KeyStore.getInstance("PKCS12");
        ks.load(keyStoreInputStream, keyStorePass.toCharArray());
        KeyStore tks = KeyStore.getInstance("JKS");
        tks.load(trustStoreInputStream, trustStorePass.toCharArray());
        SSLContext sslContext = SSLContexts.custom().loadKeyMaterial(ks, keyStorePass.toCharArray()).loadTrustMaterial(tks, (TrustStrategy)new TrustSelfSignedStrategy()).build();
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext);
        Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)sslsf).build();
        keyStoreInputStream.close();
        trustStoreInputStream.close();
        return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
    }
}

