/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityweb.service.client.http.impl;

import com.ohaotian.abilitycommon.exception.AbilityException;
import com.ohaotian.abilitycommon.model.bo.CodeMsg;
import com.ohaotian.abilitycommon.model.bo.system.MsgContext;
import com.ohaotian.abilityweb.mapper.AbilityParamMapper;
import com.ohaotian.abilityweb.model.po.AbilityParamPO;
import com.ohaotian.abilityweb.service.check.message.MessageProtocolFactory;
import com.ohaotian.abilityweb.service.client.http.HttpClientProtocolRouteService;
import javax.annotation.Resource;
import org.apache.http.Consts;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;

@Component(value="mockHttpClient")
public class HttpClientProtocolRouteMockServiceImpl
implements HttpClientProtocolRouteService {
    private static Logger logger = LogManager.getLogger(HttpClientProtocolRouteMockServiceImpl.class);
    @Resource
    private AbilityParamMapper abilityParamMapper;

    @Override
    public Mono<MsgContext> send(MsgContext msgContext) throws AbilityException {
        return Mono.just((Object)this.sendMsCxt(msgContext));
    }

    @Override
    public MsgContext sendMsCxt(MsgContext msgContext) throws AbilityException {
        AbilityParamPO abilityParamPO = this.abilityParamMapper.queryByAbilityId(msgContext.getEsbAbility().getAbilityId());
        if (abilityParamPO == null) {
            throw new AbilityException(CodeMsg.E_HP_SVC_ERR.fillArgs(new Object[]{":mock\u8c03\u7528\u5931\u8d25\uff0c\u672a\u67e5\u8be2\u5230\u8fd4\u56de\u6a21\u7248\u6570\u636e\uff01"}));
        }
        String result = MessageProtocolFactory.getInstance(msgContext.getEsbAbility().getOutputProtocal()).getMockMsg(msgContext, abilityParamPO);
        msgContext.getTlogRspHeader().setRspData(result.getBytes(Consts.UTF_8));
        return msgContext;
    }
}

