/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityweb.service.client.webclient;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.handler.timeout.WriteTimeoutHandler;
import java.io.InputStream;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.netty.http.client.HttpClient;
import reactor.netty.resources.ConnectionProvider;

public abstract class WebClientStaticFactory {
    public static WebClient getWebClient() {
        return WebClient.builder().clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(WebClientStaticFactory.getTcpClient(5))).build();
    }

    public static WebClient getWebClient(Integer overtime) {
        return WebClient.builder().clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(WebClientStaticFactory.getTcpClient(overtime))).exchangeStrategies(ExchangeStrategies.builder().codecs(configurer -> configurer.defaultCodecs().maxInMemorySize(0x6400000)).build()).build();
    }

    public static WebClient getWebClientAndTrustAll(Integer overtime) throws Exception {
        SslContext sslContext = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
        return WebClient.builder().clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(WebClientStaticFactory.getTcpClient(overtime).secure(t -> t.sslContext(sslContext)))).codecs(configurer -> configurer.defaultCodecs().maxInMemorySize(0x6400000)).build();
    }

    public static WebClient getWebClientWithCertificateBySecurity(InputStream keyStoreInputStream, String keyStorePass, Integer overtime) throws Exception {
        KeyStore ks = KeyStore.getInstance("PKCS12");
        ks.load(keyStoreInputStream, keyStorePass.toCharArray());
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        kmf.init(ks, keyStorePass.toCharArray());
        SslContext sslContext = SslContextBuilder.forClient().keyManager(kmf).build();
        keyStoreInputStream.close();
        return WebClient.builder().clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(WebClientStaticFactory.getTcpClient(overtime).secure(t -> t.sslContext(sslContext)))).codecs(configurer -> configurer.defaultCodecs().maxInMemorySize(0x6400000)).build();
    }

    public static WebClient getWebClientWithCertificateAndTrustAll(InputStream keyStoreInputStream, String keyStorePass, Integer overtime) throws Exception {
        KeyStore ks = KeyStore.getInstance("PKCS12");
        ks.load(keyStoreInputStream, keyStorePass.toCharArray());
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        kmf.init(ks, keyStorePass.toCharArray());
        SslContext sslContext = SslContextBuilder.forClient().keyManager(kmf).trustManager(InsecureTrustManagerFactory.INSTANCE).build();
        keyStoreInputStream.close();
        return WebClient.builder().clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(WebClientStaticFactory.getTcpClient(overtime).secure(t -> t.sslContext(sslContext)))).codecs(configurer -> configurer.defaultCodecs().maxInMemorySize(0x6400000)).build();
    }

    public static WebClient getWebClientWithTrustStore(InputStream trustStoreInputStream, String trustStorePass, Integer overtime) throws Exception {
        KeyStore tks = KeyStore.getInstance("JKS");
        tks.load(trustStoreInputStream, trustStorePass.toCharArray());
        TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
        tmf.init(tks);
        SslContext sslContext = SslContextBuilder.forClient().trustManager(tmf).build();
        trustStoreInputStream.close();
        return WebClient.builder().clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(WebClientStaticFactory.getTcpClient(overtime).secure(t -> t.sslContext(sslContext)))).codecs(configurer -> configurer.defaultCodecs().maxInMemorySize(0x6400000)).build();
    }

    public static WebClient getWebClient(InputStream keyStoreInputStream, String keyStorePass, InputStream trustStoreInputStream, String trustStorePass, Integer overtime) throws Exception {
        KeyStore ks = KeyStore.getInstance("PKCS12");
        ks.load(keyStoreInputStream, keyStorePass.toCharArray());
        KeyStore tks = KeyStore.getInstance("JKS");
        tks.load(trustStoreInputStream, trustStorePass.toCharArray());
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
        kmf.init(ks, keyStorePass.toCharArray());
        tmf.init(tks);
        SslContext sslContext = SslContextBuilder.forClient().keyManager(kmf).trustManager(tmf).build();
        keyStoreInputStream.close();
        trustStoreInputStream.close();
        return WebClient.builder().clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(WebClientStaticFactory.getTcpClient(overtime).secure(t -> t.sslContext(sslContext)))).codecs(configurer -> configurer.defaultCodecs().maxInMemorySize(0x6400000)).build();
    }

    private static HttpClient getTcpClient(Integer overtime) {
        return HttpClient.create((ConnectionProvider)ConnectionProvider.create((String)"ability-web")).tcpConfiguration(client -> client.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)Math.max(overtime * 1000, 60000))).tcpConfiguration(client -> client.doOnConnected(conn -> conn.addHandlerLast((ChannelHandler)new ReadTimeoutHandler(overtime.intValue())).addHandlerLast((ChannelHandler)new WriteTimeoutHandler(overtime.intValue()))));
    }
}

