/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityweb.service.limit.global;

import com.ohaotian.abilitycommon.config.nodedata.NodeInfoConfig;
import com.ohaotian.abilitycommon.model.bo.AppBO;
import com.ohaotian.abilitycommon.model.bo.system.EsbAbility;
import com.ohaotian.abilityweb.service.limit.global.RedisRateLimiterKey;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;

@Component
public class RedisRateLimiter {
    private static final Logger log = LogManager.getLogger(RedisRateLimiter.class);
    @Resource
    private ReactiveRedisTemplate<String, String> reactiveRedisTemplate;
    @Resource
    @Qualifier(value="redisRateScript")
    private RedisScript<Long> redisRateDelScript;

    public Mono<Integer> isAllowed(NodeInfoConfig nodeInfoConfig, EsbAbility esbAbility, AppBO appBO, double abilityCapacity, double abilityDailyCapacity, double abilityRate, double subscribeCapacity, double subscribeDailyCapacity, double subscribeRate) {
        Long appId = -1L;
        if (appBO != null) {
            appId = appBO.getAppId();
        }
        List<String> keys = RedisRateLimiterKey.getKeys(nodeInfoConfig, esbAbility.getAbilityId(), appId);
        List<String> scriptArgs = Arrays.asList(abilityCapacity + "", abilityDailyCapacity + "", abilityRate + "", subscribeCapacity + "", subscribeDailyCapacity + "", subscribeRate + "", String.valueOf(RedisRateLimiter.getExpireTime()));
        Mono result = this.reactiveRedisTemplate.execute(this.redisRateDelScript, keys, scriptArgs).single().flatMap(aa -> Mono.just((Object)aa.intValue())).onErrorResume(t -> {
            log.error("\u7cfb\u7edf\u5f02\u5e38", t);
            return Mono.just((Object)-1);
        });
        return result;
    }

    private static Long getExpireTime() {
        Calendar todayEnd = Calendar.getInstance();
        todayEnd.set(11, 23);
        todayEnd.set(12, 59);
        todayEnd.set(13, 59);
        todayEnd.set(14, 999);
        return (todayEnd.getTimeInMillis() - System.currentTimeMillis()) / 1000L;
    }
}

