/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityweb.service.limit.global;

import com.ohaotian.abilitycommon.config.nodedata.NodeInfoConfig;
import java.util.Arrays;
import java.util.List;

public abstract class RedisRateLimiterKey {
    private static final String ABILITY_LIMIT_CURRENT_CAPACITY = "ability_limit_current_capacity_";
    private static final String ABILITY_LIMIT_CURRENT_DAILY_CAPACITY = "ability_limit_current_daily_capacity_";
    private static final String ABILITY_LIMIT_RATE = "ability_limit_rate_";
    private static final String SUBSCRIBE_LIMIT_CURRENT_CAPACITY = "subscribe_limit_current_capacity_";
    private static final String SUBSCRIBE_LIMIT_CURRENT_DAILY_CAPACITY = "subscribe_limit_current_daily_capacity_";
    private static final String SUBSCRIBE_LIMIT_RATE = "subscribe_limit_rate_";

    public static List<String> getKeys(NodeInfoConfig nodeInfoConfig, Long abilityId, Long appId) {
        Long clusterId = nodeInfoConfig.getClusterId();
        String clusterEname = nodeInfoConfig.getClusterEname();
        StringBuilder sb = new StringBuilder("");
        sb.append(clusterId).append(clusterEname).append("_");
        String abilityCurrentCapacity = ABILITY_LIMIT_CURRENT_CAPACITY + sb.toString() + abilityId;
        String abilityCurrentDailyCapacity = ABILITY_LIMIT_CURRENT_DAILY_CAPACITY + sb.toString() + abilityId;
        String abilityRate = ABILITY_LIMIT_RATE + sb.toString() + abilityId;
        String subscribeCurrentCapacity = SUBSCRIBE_LIMIT_CURRENT_CAPACITY + sb.toString() + abilityId + "_" + appId;
        String subscribeCurrentDailyCapacity = SUBSCRIBE_LIMIT_CURRENT_DAILY_CAPACITY + sb.toString() + abilityId + "_" + appId;
        String subscribeRate = SUBSCRIBE_LIMIT_RATE + sb.toString() + abilityId + "_" + appId;
        return Arrays.asList(abilityCurrentCapacity, abilityCurrentDailyCapacity, abilityRate, subscribeCurrentCapacity, subscribeCurrentDailyCapacity, subscribeRate);
    }
}

