/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityweb.service.limit.global.impl;

import com.ohaotian.abilitycommon.config.nodedata.NodeInfoConfig;
import com.ohaotian.abilitycommon.constant.LimitConstant;
import com.ohaotian.abilitycommon.exception.AbilityException;
import com.ohaotian.abilitycommon.model.bo.AppBO;
import com.ohaotian.abilitycommon.model.bo.CodeMsg;
import com.ohaotian.abilitycommon.model.bo.system.EsbAbility;
import com.ohaotian.abilitycommon.model.bo.system.MsgContext;
import com.ohaotian.abilityweb.mapper.RateLimiterAbilityMapper;
import com.ohaotian.abilityweb.mapper.RateLimiterSubscribeMapper;
import com.ohaotian.abilityweb.model.po.RateLimiterAbilityPO;
import com.ohaotian.abilityweb.model.po.RateLimiterSubscribePO;
import com.ohaotian.abilityweb.service.limit.global.JudgeRateLimiterService;
import com.ohaotian.abilityweb.service.limit.global.RedisRateLimiter;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class JudgeRateLimiterServiceImpl
implements JudgeRateLimiterService {
    @Resource
    private RedisRateLimiter redisRateLimiter;
    @Resource
    private NodeInfoConfig nodeInfoConfig;
    @Resource
    private RateLimiterSubscribeMapper rateLimiterSubscribeMapper;
    @Resource
    private RateLimiterAbilityMapper rateLimiterAbilityMapper;

    @Override
    public Mono<MsgContext> judgeRate(MsgContext msgContext) {
        EsbAbility esbAbility = msgContext.getEsbAbility();
        AppBO providerApp = esbAbility.getProviderApp();
        AppBO consumerApp = msgContext.getSelfDefHeader().getApp();
        if (consumerApp == null) {
            return Mono.just((Object)msgContext);
        }
        if (providerApp.getAppCode().equals(consumerApp.getAppCode())) {
            return Mono.just((Object)msgContext);
        }
        if (LimitConstant.GLOBAL_LIMIT_ON.equalsIgnoreCase(esbAbility.getGlobalLimit())) {
            RateLimiterSubscribePO rateLimiterSubscribePO1 = this.qryRateLimiterSubscribe(esbAbility.getAbilityId(), consumerApp);
            RateLimiterAbilityPO rateLimiterAbilityPO1 = this.qryRateLimiterAbility(esbAbility.getAbilityId());
            Integer subscribeRate = -1;
            Integer subscribeDailyCapacity = -1;
            Integer subscribeCapacity = -1;
            if (!Objects.isNull(rateLimiterSubscribePO1)) {
                subscribeRate = rateLimiterSubscribePO1.getRate();
                if (subscribeRate == null) {
                    subscribeRate = -1;
                }
                if ((subscribeCapacity = rateLimiterSubscribePO1.getCapacity()) == null) {
                    subscribeCapacity = -1;
                }
                if ((subscribeDailyCapacity = rateLimiterSubscribePO1.getDailyCapacity()) == null) {
                    subscribeDailyCapacity = -1;
                }
            }
            Integer abilityRate = -1;
            Integer abilityDailyCapacity = -1;
            Integer abilityCapacity = -1;
            if (!Objects.isNull(rateLimiterAbilityPO1)) {
                abilityRate = rateLimiterAbilityPO1.getRate();
                if (abilityRate == null) {
                    abilityRate = -1;
                }
                if ((abilityCapacity = rateLimiterAbilityPO1.getCapacity()) == null) {
                    abilityCapacity = -1;
                }
                if ((abilityDailyCapacity = rateLimiterAbilityPO1.getDailyCapacity()) == null) {
                    abilityDailyCapacity = -1;
                }
            }
            if (subscribeRate <= 0 && subscribeCapacity <= 0 && subscribeDailyCapacity <= 0 && abilityRate <= 0 && abilityCapacity <= 0 && abilityDailyCapacity <= 0) {
                return Mono.just((Object)msgContext);
            }
            Mono<Integer> limiterCode = this.redisRateLimiter.isAllowed(this.nodeInfoConfig, esbAbility, consumerApp, abilityCapacity.intValue(), abilityDailyCapacity.intValue(), abilityRate.intValue(), subscribeCapacity.intValue(), subscribeDailyCapacity.intValue(), subscribeRate.intValue());
            return limiterCode.flatMap(code -> {
                switch (code) {
                    case -1: {
                        throw new AbilityException(CodeMsg.E_ESB_SAF_ERROR_DETERMINING);
                    }
                    case 10001: {
                        throw new AbilityException(CodeMsg.E_ESB_SAF_OVERFLOW_ABILITY_SEND_COUNT);
                    }
                    case 10002: {
                        throw new AbilityException(CodeMsg.E_ESB_SAF_OVERFLOW_ABILITY_DAILY_SEND_COUNT);
                    }
                    case 10003: {
                        throw new AbilityException(CodeMsg.E_ESB_SAF_OVERFLOW_ABILITY_SEND_RATE);
                    }
                    case 10004: {
                        throw new AbilityException(CodeMsg.E_ESB_SAF_OVERFLOW_SEND_COUNT);
                    }
                    case 10005: {
                        throw new AbilityException(CodeMsg.E_ESB_SAF_OVERFLOW_DAILY_SEND_COUNT);
                    }
                    case 10006: {
                        throw new AbilityException(CodeMsg.E_ESB_SAF_OVERFLOW_SEND_RATE);
                    }
                }
                return Mono.just((Object)msgContext);
            });
        }
        return Mono.just((Object)msgContext);
    }

    private RateLimiterAbilityPO qryRateLimiterAbility(long abilityId) {
        RateLimiterAbilityPO rateLimiterAbilityPO = new RateLimiterAbilityPO();
        rateLimiterAbilityPO.setAbilityId(abilityId);
        RateLimiterAbilityPO rateLimiterAbilityPO1 = this.rateLimiterAbilityMapper.queryLimitOne(rateLimiterAbilityPO);
        if (Objects.isNull(rateLimiterAbilityPO1)) {
            throw new AbilityException(CodeMsg.E_ABILITY_RATE_LIMITER_NOT_EXIST);
        }
        return rateLimiterAbilityPO1;
    }

    private RateLimiterSubscribePO qryRateLimiterSubscribe(long abilityId, AppBO appBO) {
        if (appBO == null) {
            return null;
        }
        RateLimiterSubscribePO rateLimiterSubscribePO = new RateLimiterSubscribePO();
        rateLimiterSubscribePO.setAbilityId(abilityId);
        rateLimiterSubscribePO.setAppId(appBO.getAppId());
        RateLimiterSubscribePO rateLimiterSubscribePO1 = this.rateLimiterSubscribeMapper.queryLimitOne(rateLimiterSubscribePO);
        if (Objects.isNull(rateLimiterSubscribePO1)) {
            throw new AbilityException(CodeMsg.E_SUBSCRIBE_RATE_LIMITER_NOT_EXIST);
        }
        return rateLimiterSubscribePO1;
    }
}

