/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityweb.service.plugin.impl;

import com.ohaotian.abilitycommon.exception.AbilityException;
import com.ohaotian.abilitycommon.model.bo.CodeMsg;
import com.ohaotian.abilitycommon.model.bo.system.MsgContext;
import com.ohaotian.abilitycommon.plugin.PluginB;
import com.ohaotian.abilitycommon.util.SpiLoadFactory;
import com.ohaotian.abilityweb.service.plugin.BusinessService;
import java.util.List;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class BusinessServiceImpl
implements BusinessService {
    private static final Logger logger = LogManager.getLogger(BusinessServiceImpl.class);
    @Resource
    ApplicationContext applicationContext;

    @Override
    public void doService(MsgContext msgContext) throws AbilityException {
        try {
            List loaders = SpiLoadFactory.loadFactories(PluginB.class);
            for (PluginB pluginB : loaders) {
                PluginB pluginBImpl = (PluginB)this.applicationContext.getBean(pluginB.getClass());
                pluginBImpl.doService(msgContext);
            }
        }
        catch (AbilityException e) {
            logger.warn(e.codeMsg.getRspDesc());
            throw new AbilityException(e.codeMsg, (Throwable)e);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new AbilityException(CodeMsg.E_PLUGIN_NOT_IMPORT.fillArgs(new Object[]{":" + e.getMessage()}), (Throwable)e);
        }
    }
}

