/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityweb.service.proxy.impl;

import com.ohaotian.abilitycommon.exception.AbilityException;
import com.ohaotian.abilitycommon.model.bo.CodeMsg;
import com.ohaotian.abilitycommon.model.bo.system.EsbAbility;
import com.ohaotian.abilitycommon.model.bo.system.MsgContext;
import com.ohaotian.abilitycommon.model.bo.system.SelfDefHeader;
import com.ohaotian.abilitycommon.util.JacksonUtil;
import com.ohaotian.abilitycommon.util.ReflectBeanValueUtil;
import com.ohaotian.abilityweb.mapper.AbilityProvideDubboCustomInputMapper;
import com.ohaotian.abilityweb.mapper.AbilityProvideDubboCustomMapper;
import com.ohaotian.abilityweb.mapper.AbilityProvideHsfCustomInputMapper;
import com.ohaotian.abilityweb.mapper.AbilityProvideHsfCustomMapper;
import com.ohaotian.abilityweb.mapper.AbilityWsExtMapper;
import com.ohaotian.abilityweb.model.po.AbilityProvideDubboCustomInputPO;
import com.ohaotian.abilityweb.model.po.AbilityProvideDubboCustomPO;
import com.ohaotian.abilityweb.model.po.AbilityProvideHsfCustomInputPO;
import com.ohaotian.abilityweb.model.po.AbilityProvideHsfCustomPO;
import com.ohaotian.abilityweb.model.po.AbilityWsExtPO;
import com.ohaotian.abilityweb.service.proxy.BuildProxyMsgService;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.springframework.stereotype.Service;

@Service
public class BuildProxyMsgServiceImpl
implements BuildProxyMsgService {
    private static Logger logger = LogManager.getLogger(BuildProxyMsgServiceImpl.class);
    @Resource
    private AbilityProvideDubboCustomMapper abilityDubboExtMapper;
    @Resource
    private AbilityProvideDubboCustomInputMapper abilityDubboExtInputMapper;
    @Resource
    private AbilityProvideHsfCustomMapper abilityHsfExtMapper;
    @Resource
    private AbilityProvideHsfCustomInputMapper abilityHsfExtInputMapper;
    @Resource
    private AbilityWsExtMapper abilityWsExtMapper;

    @Override
    public void buildProxyReqHead(MsgContext msgContext) throws AbilityException {
        String outputProtocal;
        switch (outputProtocal = msgContext.getEsbAbility().getOutputProtocal()) {
            case "dubbo": {
                this.buildDubboProxyReqHead(msgContext);
                break;
            }
            case "hsf": {
                this.buildHsfProxyReqHead(msgContext);
                break;
            }
        }
    }

    private void buildHsfProxyReqHead(MsgContext msgContext) {
        try {
            SelfDefHeader selfDefHeader = msgContext.getSelfDefHeader();
            HashMap<String, String> selfDefMap = selfDefHeader.getSelfDefMap();
            if (Objects.isNull(selfDefHeader) || selfDefMap == null || selfDefMap.isEmpty()) {
                selfDefMap = new HashMap<String, String>(16);
            }
            Long abilityId = msgContext.getEsbAbility().getAbilityId();
            AbilityProvideHsfCustomPO abilityProvideHsfCustomPO = new AbilityProvideHsfCustomPO();
            abilityProvideHsfCustomPO.setAbilityId(abilityId);
            AbilityProvideHsfCustomPO abilityProvideHsfCustom = this.abilityHsfExtMapper.queryLimitOne(abilityProvideHsfCustomPO);
            if (selfDefMap.containsKey("groupName")) {
                abilityProvideHsfCustom.setGroupName((String)selfDefMap.get("groupName"));
            }
            if (selfDefMap.containsKey("version")) {
                abilityProvideHsfCustom.setVersion((String)selfDefMap.get("version"));
            }
            AbilityProvideHsfCustomInputPO abilityProvideHsfCustomInputPO = new AbilityProvideHsfCustomInputPO();
            abilityProvideHsfCustomInputPO.setAbilityId(abilityId);
            List<AbilityProvideHsfCustomInputPO> abilityProvideHsfCustomInputPOS = this.abilityHsfExtInputMapper.queryByCond(abilityProvideHsfCustomInputPO);
            selfDefMap.put("ext", JacksonUtil.toJson((Object)abilityProvideHsfCustom));
            selfDefMap.put("extInput", JacksonUtil.toJson(abilityProvideHsfCustomInputPOS));
            selfDefMap.put("eprPath", "/hsf/xx");
            selfDefHeader.setSelfDefMap(selfDefMap);
            msgContext.setSelfDefHeader(selfDefHeader);
            EsbAbility ability = msgContext.getEsbAbility();
            msgContext.setEsbAbility(ability);
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u4ee3\u7406\u8282\u70b9\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            throw new AbilityException(CodeMsg.E_BUILD_PROXY_PARAM_ERROR.fillArgs(new Object[]{":" + e.getMessage()}));
        }
    }

    public void buildDubboProxyReqHead(MsgContext msgContext) throws AbilityException {
        try {
            SelfDefHeader selfDefHeader = msgContext.getSelfDefHeader();
            HashMap<String, String> selfDefMap = selfDefHeader.getSelfDefMap();
            if (Objects.isNull(selfDefHeader) || selfDefMap == null || selfDefMap.isEmpty()) {
                selfDefMap = new HashMap<String, String>(16);
            }
            Long abilityId = msgContext.getEsbAbility().getAbilityId();
            AbilityProvideDubboCustomPO abilityProvideDubboCustomPO = new AbilityProvideDubboCustomPO();
            abilityProvideDubboCustomPO.setAbilityId(abilityId);
            AbilityProvideDubboCustomPO abilityProvideDubboCustom = this.abilityDubboExtMapper.queryLimitOne(abilityProvideDubboCustomPO);
            if (selfDefMap.containsKey("groupName")) {
                abilityProvideDubboCustom.setGroupName((String)selfDefMap.get("groupName"));
            }
            if (selfDefMap.containsKey("version")) {
                abilityProvideDubboCustom.setVersion((String)selfDefMap.get("version"));
            }
            AbilityProvideDubboCustomInputPO abilityProvideDubboCustomInputPO = new AbilityProvideDubboCustomInputPO();
            abilityProvideDubboCustomInputPO.setAbilityId(abilityId);
            List<AbilityProvideDubboCustomInputPO> abilityProvideDubboCustomInputPOS = this.abilityDubboExtInputMapper.queryByCond(abilityProvideDubboCustomInputPO);
            selfDefMap.put("ext", JacksonUtil.toJson((Object)abilityProvideDubboCustom));
            selfDefMap.put("extInput", JacksonUtil.toJson(abilityProvideDubboCustomInputPOS));
            selfDefMap.put("eprPath", "/dubbo/xx");
            selfDefHeader.setSelfDefMap(selfDefMap);
            msgContext.setSelfDefHeader(selfDefHeader);
            EsbAbility ability = msgContext.getEsbAbility();
            msgContext.setEsbAbility(ability);
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u4ee3\u7406\u8282\u70b9\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            throw new AbilityException(CodeMsg.E_BUILD_PROXY_PARAM_ERROR.fillArgs(new Object[]{":" + e.getMessage()}));
        }
    }

    public void buildWsProxyReqHead(MsgContext msgContext) throws AbilityException {
        try {
            SelfDefHeader selfDefHeader = msgContext.getSelfDefHeader();
            HashMap<String, String> selfDefMap = selfDefHeader.getSelfDefMap();
            if (Objects.isNull(selfDefHeader) || selfDefMap == null || selfDefMap.isEmpty()) {
                selfDefMap = new HashMap<String, String>(16);
            }
            Long abilityId = msgContext.getEsbAbility().getAbilityId();
            AbilityWsExtPO abilityWsExtPO = new AbilityWsExtPO();
            abilityWsExtPO.setAbilityId(abilityId);
            abilityWsExtPO = this.abilityWsExtMapper.queryLimitOne(abilityWsExtPO);
            Document targetDocument = DocumentHelper.parseText((String)abilityWsExtPO.getTargetSoap());
            Element targetBody = targetDocument.getRootElement().element("Body");
            Element targetMethod = (Element)targetBody.elements().get(0);
            this.getTargetSoap(msgContext.getTlogReqHeader().getReqObj(msgContext), targetMethod);
            selfDefMap.put("ext", targetDocument.asXML());
            selfDefMap.put("extTargetUrl", abilityWsExtPO.getTargetUrl());
            selfDefHeader.setSelfDefMap(selfDefMap);
            msgContext.setSelfDefHeader(selfDefHeader);
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u4ee3\u7406\u8282\u70b9\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            throw new AbilityException(CodeMsg.E_BUILD_PROXY_PARAM_ERROR.fillArgs(new Object[]{":" + e.getMessage()}));
        }
    }

    private void getTargetSoap(Object object, Element element) throws NoSuchFieldException, IllegalAccessException {
        List chileElementList = element.elements();
        if (chileElementList != null && chileElementList.size() > 0) {
            for (int i = 0; i < chileElementList.size(); ++i) {
                Element e = (Element)chileElementList.get(i);
                Object currentValue = ReflectBeanValueUtil.getValue((Object)object, (String)e.getName());
                if (currentValue.getClass().isArray()) {
                    this.getTargetSoap(((List)currentValue).get(i), e);
                    continue;
                }
                this.getTargetSoap(currentValue, e);
            }
        } else {
            element.setText(object.toString());
        }
    }
}

