/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityweb.service.safety.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.ohaotian.abilitycommon.exception.AbilityException;
import com.ohaotian.abilitycommon.model.bo.CodeMsg;
import com.ohaotian.abilitycommon.model.bo.system.MsgContext;
import com.ohaotian.abilitycommon.util.DateUtil;
import com.ohaotian.abilitycommon.util.GetRandomPwd;
import com.ohaotian.abilitycommon.util.Sha256SignUtils;
import com.ohaotian.abilityweb.component.js.JsHelper;
import com.ohaotian.abilityweb.mapper.AppMapper;
import com.ohaotian.abilityweb.mapper.AppSecretMapper;
import com.ohaotian.abilityweb.model.po.AppPO;
import com.ohaotian.abilityweb.model.po.AppSecretPO;
import com.ohaotian.abilityweb.service.safety.SecurityReinService;
import com.ohaotian.plugin.cache.CacheClient;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.Consts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class SecurityReinServiceImpl
implements SecurityReinService {
    private static final Logger log = LoggerFactory.getLogger(SecurityReinServiceImpl.class);
    @Resource
    private AppSecretMapper appSecretMapper;
    @Resource
    private AppMapper appMapper;
    @Autowired
    private CacheClient cacheClient;
    @Value(value="${ability.relaunch.attack.expire.time:10}")
    private Integer expireTime;

    @Override
    public void relaunchAttack(String body) {
        if (this.expireTime.equals(0)) {
            return;
        }
        body = body.replace(" ", "");
        body = body.replace("\r", "");
        body = body.replace("\n", "");
        String md5 = "zap-" + JsHelper.MD5(body);
        Object obj = this.cacheClient.get(md5);
        if (!ObjectUtils.isEmpty((Object)obj)) {
            Long expire = this.cacheClient.getExpireTimeByKey(md5);
            throw new AbilityException(CodeMsg.RELAUNCH_ATTACK.fillArgs(new Object[]{expire}));
        }
        this.cacheClient.set(md5, (Object)DateUtil.getCurrentDateSSSTime(), this.expireTime.intValue());
    }

    @Override
    public void reinforcement(MsgContext msgContext) {
        try {
            AppSecretPO appSecretPo = this.appSecretMapper.selectByAppIdandClusterId(msgContext.getEsbAbility().getProviderApp().getAppId(), msgContext.getSelfDefHeader().getClusterId());
            String reqData = new String(msgContext.getTlogReqHeader().getReqData());
            JSONObject jsonReqData = null;
            try {
                jsonReqData = JSON.parseObject((String)reqData, (Feature[])new Feature[]{Feature.OrderedField});
            }
            catch (Exception e) {
                log.warn("\u76ee\u524d\u4e0d\u652f\u6301\u4e3ajson\u5b89\u5168\u52a0\u5bc6!");
                return;
            }
            boolean flag = Boolean.FALSE;
            if (!ObjectUtils.isEmpty((Object)msgContext.getSecurityInfo().isPreventAgain()) && msgContext.getSecurityInfo().isPreventAgain() == Boolean.TRUE.booleanValue()) {
                jsonReqData.put("reTimeStamp", (Object)DateUtil.formatDateWithMS((Date)new Date()));
                jsonReqData.put("reStr", (Object)GetRandomPwd.makeRandomPwd((int)8));
                flag = Boolean.TRUE;
            }
            if (!"null".equals(msgContext.getSecurityInfo().getSign())) {
                if (!ObjectUtils.isEmpty((Object)appSecretPo.getPrivateKey())) {
                    String sign;
                    if (msgContext.getSecurityInfo().getSign().equals("header")) {
                        if (!ObjectUtils.isEmpty(msgContext.getSelfDefHeader().getSelfDefMap().get("sign"))) {
                            throw new AbilityException("header\u4e2d\u5df2\u5b58\u5728sign\u5b57\u6bb5\uff01");
                        }
                        sign = Sha256SignUtils.sign((byte[])jsonReqData.toString().getBytes(Consts.UTF_8), (String)appSecretPo.getPrivateKey());
                        msgContext.getSelfDefHeader().getSelfDefMap().put("sign", sign);
                        flag = Boolean.TRUE;
                    } else if (msgContext.getSecurityInfo().getSign().equals("body")) {
                        if (!ObjectUtils.isEmpty((Object)jsonReqData.get((Object)"sign"))) {
                            throw new AbilityException("body\u4e2d\u5df2\u5b58\u5728sign\u5b57\u6bb5\uff01");
                        }
                        sign = Sha256SignUtils.sign((byte[])jsonReqData.toString().getBytes(Consts.UTF_8), (String)appSecretPo.getPrivateKey());
                        jsonReqData.put("sign", (Object)sign);
                        flag = Boolean.TRUE;
                    }
                } else {
                    AppPO appPO = this.appMapper.queryByAppId(msgContext.getEsbAbility().getProviderApp().getAppId());
                    throw new AbilityException("\u5e94\u7528\uff1a" + appPO.getAppName() + "|" + appPO.getAppCode() + "\u4e0d\u652f\u6301\u6570\u5b57\u7b7e\u540d");
                }
            }
            msgContext.getTlogReqHeader().setReqData(jsonReqData.toString().getBytes(Consts.UTF_8));
            msgContext.getTlogReqHeader().setReqObj((Object)jsonReqData.toString());
            if (!ObjectUtils.isEmpty((Object)msgContext.getSecurityInfo().isEncryptBody()) && msgContext.getSecurityInfo().isEncryptBody() == Boolean.TRUE.booleanValue() && msgContext.getEsbAbility().getOutputTransProtocal().equals("POST")) {
                if (!ObjectUtils.isEmpty((Object)appSecretPo.getPrivateKey())) {
                    String body = msgContext.getTlogReqHeader().getReqObj().toString();
                    byte[] encrypt = Sha256SignUtils.encryptByPrivateKey((byte[])body.getBytes(StandardCharsets.UTF_8), (String)appSecretPo.getPrivateKey());
                    msgContext.getTlogReqHeader().setReqData(encrypt);
                    msgContext.getTlogReqHeader().setReqObj((Object)new String(Base64.encodeBase64((byte[])encrypt)));
                    flag = Boolean.TRUE;
                } else {
                    AppPO appPO = this.appMapper.queryByAppId(msgContext.getEsbAbility().getProviderApp().getAppId());
                    throw new AbilityException(appPO.getAppName() + "|" + appPO.getAppCode() + " \u4e0d\u652f\u6301\u62a5\u6587\u52a0\u5bc6\u7b7e\u540d,\u8bf7\u914d\u7f6e\u5bc6\u94a5");
                }
            }
            if (flag) {
                log.info("\u5b89\u5168\u52a0\u56fa\u540e\u7684\u8bf7\u6c42\u62a5\u6587\uff1a" + msgContext.getTlogReqHeader().getReqObj().toString());
                if (!ObjectUtils.isEmpty((Object)appSecretPo.getPublicKey())) {
                    log.info("\u5b89\u5168\u52a0\u56fa\u540e\u7684\u8bf7\u6c42\u89e3\u5bc6\u62a5\u6587\uff1a" + new String(Sha256SignUtils.decryptByPublicKey((byte[])msgContext.getTlogReqHeader().getReqData(), (String)appSecretPo.getPublicKey())));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u5b89\u5168\u52a0\u5bc6\u5931\u8d25\uff01");
        }
    }
}

