/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityweb.service.sync.impl;

import com.google.common.collect.Lists;
import com.ohaotian.abilitycommon.config.nodedata.NodeInfoConfig;
import com.ohaotian.abilitycommon.config.system.SystemParam;
import com.ohaotian.abilitycommon.enums.FisrtLevelEnum;
import com.ohaotian.abilitycommon.enums.SecondLevelEnum;
import com.ohaotian.abilitycommon.model.bo.RedisSyncDataBo;
import com.ohaotian.abilitycommon.model.bo.SyncDataBO;
import com.ohaotian.abilitycommon.util.GsonUtil;
import com.ohaotian.abilityweb.config.cluster.WebClusterConfig;
import com.ohaotian.abilityweb.config.pubsub.PubSubMsgHandler;
import com.ohaotian.abilityweb.config.pubsub.loader.PubSubRes;
import com.ohaotian.abilityweb.service.sync.InitDataService;
import com.ohaotian.abilityweb.service.sync.PluginSyncDataService;
import com.ohaotian.abilityweb.service.sync.SyncDataService;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class InitDataServiceImpl
implements InitDataService {
    private static final Logger log = LoggerFactory.getLogger(InitDataServiceImpl.class);
    @Resource
    private NodeInfoConfig nodeInfoConfig;
    @Resource
    private SyncDataService syncDataService;
    @Resource
    private PluginSyncDataService pluginSyncDataService;
    @Resource
    private PubSubRes pubSubRes;
    @Resource
    NodeInfoConfig nodeInfo;
    @Resource
    WebClusterConfig webClusterConfig;
    @Resource
    SystemParam systemParam;
    @Value(value="${ability.pub.rounds:10}")
    private Integer rounds;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean initData() throws Exception {
        if (ObjectUtils.isEmpty((Object)this.systemParam.getSyncWay())) {
            return this.initDataApi();
        }
        if (this.systemParam.getSyncWay().equals("redis")) {
            return this.initDataPubSub();
        }
        if (this.systemParam.getSyncWay().equals("mq")) {
            return this.initDataPubSub();
        }
        return this.initDataApi();
    }

    @Transactional(rollbackFor={Exception.class})
    public Boolean initDataApi() throws Exception {
        Boolean status = Boolean.FALSE;
        try {
            Long clusterId = this.nodeInfoConfig.getClusterId();
            Long hireId = this.nodeInfoConfig.getHireId();
            ArrayList list = Lists.newArrayList();
            for (int i = 0; i < FisrtLevelEnum.values().length; ++i) {
                List secondLevelEnumList = SecondLevelEnum.getSecondLevelByParentCode((int)FisrtLevelEnum.values()[i].getCode());
                for (int j = 0; j < secondLevelEnumList.size(); ++j) {
                    SyncDataBO syncDataBO = new SyncDataBO();
                    syncDataBO.setClusterId(clusterId);
                    syncDataBO.setHirerId(hireId);
                    syncDataBO.setFirstLevel(FisrtLevelEnum.values()[i].getName());
                    syncDataBO.setSecondLevel(((SecondLevelEnum)secondLevelEnumList.get(j)).getName());
                    list.add(syncDataBO);
                }
            }
            this.syncDataService.syncAll(list);
            List secondLevelEnumList = SecondLevelEnum.getSecondLevelByParentCode((int)FisrtLevelEnum.PLUGIN.getCode());
            List<SyncDataBO> pluginList = secondLevelEnumList.stream().map(e -> {
                SyncDataBO syncDataBO = new SyncDataBO();
                syncDataBO.setClusterId(clusterId);
                syncDataBO.setHirerId(hireId);
                syncDataBO.setFirstLevel(FisrtLevelEnum.PLUGIN.getName());
                syncDataBO.setSecondLevel(e.getName());
                return syncDataBO;
            }).collect(Collectors.toList());
            this.pluginSyncDataService.syncAll(pluginList);
            status = Boolean.TRUE;
        }
        catch (Exception e2) {
            log.error("API\u6a21\u5f0f\u540c\u6b65\u6570\u636e\u5f02\u5e38\uff01" + e2.getMessage());
        }
        return status;
    }

    @Transactional(rollbackFor={Exception.class})
    public Boolean initDataPubSub() throws Exception {
        RedisSyncDataBo redisSyncDataBo = new RedisSyncDataBo();
        redisSyncDataBo.setCode("PUBSUB");
        redisSyncDataBo.setName(this.webClusterConfig.getName());
        redisSyncDataBo.setClusterId(this.nodeInfo.getClusterId());
        PubSubMsgHandler.setFirstFinished(Boolean.FALSE);
        boolean status = Boolean.FALSE;
        for (int rds = 1; rds <= this.rounds; ++rds) {
            try {
                log.info("\u7b2c" + rds + "\u6b21\u5411\u7ba1\u7406\u4e3b\u8282\u70b9\u8bf7\u6c42\u6570\u636e\u63a8\u9001\uff01");
                this.pubSubRes.getClient().publish("", GsonUtil.toJson((Object)redisSyncDataBo));
                for (int i = 0; i < 10; ++i) {
                    TimeUnit.SECONDS.sleep(2L);
                    if (!Boolean.TRUE.equals(PubSubMsgHandler.getFirstFinished())) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                if (rds != this.rounds) {
                    log.warn("\u4e3b\u8282\u70b9\u542f\u52a8\u5f02\u5e38\uff0120\u79d2\u540e\u91cd\u8bd5\uff01e:{}", (Object)e.getMessage());
                    e.printStackTrace();
                    TimeUnit.SECONDS.sleep(20L);
                }
                log.warn("\u4e3b\u8282\u70b9\u542f\u52a8\u5f02\u5e38\uff01\u7ed3\u675f\u91cd\u8bd5\uff01");
            }
            if (!Boolean.TRUE.equals(PubSubMsgHandler.getFirstFinished())) continue;
            status = Boolean.TRUE;
            break;
        }
        return status;
    }
}

