/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityweb.service.sync.impl;

import com.google.common.collect.Lists;
import com.ohaotian.abilitycommon.config.system.SystemParam;
import com.ohaotian.abilitycommon.enums.FisrtLevelEnum;
import com.ohaotian.abilitycommon.enums.SecondLevelEnum;
import com.ohaotian.abilitycommon.exception.AbilityException;
import com.ohaotian.abilitycommon.mapper.TableMapper;
import com.ohaotian.abilitycommon.model.bo.CodeMsg;
import com.ohaotian.abilitycommon.model.bo.SyncDataBO;
import com.ohaotian.abilitycommon.model.bo.system.EsbAbility;
import com.ohaotian.abilitycommon.util.GsonUtil;
import com.ohaotian.abilitycommon.util.JacksonUtil;
import com.ohaotian.abilitycommon.util.ValidBatchUtils;
import com.ohaotian.abilityweb.config.esbability.EsbAbilityMap;
import com.ohaotian.abilityweb.mapper.AbilityExtColumnMapper;
import com.ohaotian.abilityweb.mapper.AbilityExtCustomMapper;
import com.ohaotian.abilityweb.mapper.AbilityExtMapper;
import com.ohaotian.abilityweb.mapper.AbilityLogicMapper;
import com.ohaotian.abilityweb.mapper.AbilityMapper;
import com.ohaotian.abilityweb.mapper.AbilityParamMapper;
import com.ohaotian.abilityweb.mapper.AbilityPluginMapper;
import com.ohaotian.abilityweb.mapper.AbilityProvideDeployMapper;
import com.ohaotian.abilityweb.mapper.AbilityProvideDubboCustomInputMapper;
import com.ohaotian.abilityweb.mapper.AbilityProvideDubboCustomMapper;
import com.ohaotian.abilityweb.mapper.AbilityProvideHsfCustomInputMapper;
import com.ohaotian.abilityweb.mapper.AbilityProvideHsfCustomMapper;
import com.ohaotian.abilityweb.mapper.AbilityProvideHttpCustomMapper;
import com.ohaotian.abilityweb.mapper.AbilityToVegaMapper;
import com.ohaotian.abilityweb.mapper.AbilityTransMapper;
import com.ohaotian.abilityweb.mapper.AbilityWsExtMapper;
import com.ohaotian.abilityweb.mapper.AppExtColumnMapper;
import com.ohaotian.abilityweb.mapper.AppMapper;
import com.ohaotian.abilityweb.mapper.AppSecretMapper;
import com.ohaotian.abilityweb.mapper.AppSubscribeDeployMapper;
import com.ohaotian.abilityweb.mapper.DefinedExceptionMapper;
import com.ohaotian.abilityweb.mapper.PluginMapper;
import com.ohaotian.abilityweb.mapper.RateLimiterAbilityMapper;
import com.ohaotian.abilityweb.mapper.RateLimiterSubscribeMapper;
import com.ohaotian.abilityweb.mapper.RegionAddrMapper;
import com.ohaotian.abilityweb.mapper.RegionCertificateMapper;
import com.ohaotian.abilityweb.mapper.RegionMapper;
import com.ohaotian.abilityweb.mapper.RspCodeMapper;
import com.ohaotian.abilityweb.mapper.SubAbilityMapper;
import com.ohaotian.abilityweb.mapper.SystemCodeTypeMapper;
import com.ohaotian.abilityweb.mapper.SystemCodeValueMapper;
import com.ohaotian.abilityweb.mapper.SystemExtColumnMapper;
import com.ohaotian.abilityweb.model.po.AbilityExtColumnPO;
import com.ohaotian.abilityweb.model.po.AbilityExtCustomPO;
import com.ohaotian.abilityweb.model.po.AbilityExtPO;
import com.ohaotian.abilityweb.model.po.AbilityLogicPO;
import com.ohaotian.abilityweb.model.po.AbilityPO;
import com.ohaotian.abilityweb.model.po.AbilityParamPO;
import com.ohaotian.abilityweb.model.po.AbilityPluginPO;
import com.ohaotian.abilityweb.model.po.AbilityProvideDeployPO;
import com.ohaotian.abilityweb.model.po.AbilityProvideDubboCustomInputPO;
import com.ohaotian.abilityweb.model.po.AbilityProvideDubboCustomPO;
import com.ohaotian.abilityweb.model.po.AbilityProvideHsfCustomInputPO;
import com.ohaotian.abilityweb.model.po.AbilityProvideHsfCustomPO;
import com.ohaotian.abilityweb.model.po.AbilityProvideHttpCustomPO;
import com.ohaotian.abilityweb.model.po.AbilityToVegaPo;
import com.ohaotian.abilityweb.model.po.AbilityTransPO;
import com.ohaotian.abilityweb.model.po.AbilityWsExtPO;
import com.ohaotian.abilityweb.model.po.AppExtColumnPO;
import com.ohaotian.abilityweb.model.po.AppPO;
import com.ohaotian.abilityweb.model.po.AppSecretPO;
import com.ohaotian.abilityweb.model.po.AppSubscribeDeployPO;
import com.ohaotian.abilityweb.model.po.DefinedExceptionPO;
import com.ohaotian.abilityweb.model.po.PluginPO;
import com.ohaotian.abilityweb.model.po.RateLimiterAbilityPO;
import com.ohaotian.abilityweb.model.po.RateLimiterSubscribePO;
import com.ohaotian.abilityweb.model.po.RegionAddrPO;
import com.ohaotian.abilityweb.model.po.RegionCertificatePO;
import com.ohaotian.abilityweb.model.po.RegionPO;
import com.ohaotian.abilityweb.model.po.RspCodePO;
import com.ohaotian.abilityweb.model.po.SubAbilityPO;
import com.ohaotian.abilityweb.model.po.SystemCodeTypePO;
import com.ohaotian.abilityweb.model.po.SystemCodeValuePO;
import com.ohaotian.abilityweb.model.po.SystemExtColumnPO;
import com.ohaotian.abilityweb.service.sync.SyncDataService;
import com.ohaotian.plugin.mapper.AbilityPluginExtIpMapper;
import com.ohaotian.plugin.mapper.AbilityPluginJwtMapper;
import com.ohaotian.plugin.mapper.PluginPriorityMapper;
import com.ohaotian.plugin.mapper.PluginRouteColumnMapper;
import com.ohaotian.plugin.mapper.PluginRouteExtMapper;
import com.ohaotian.plugin.mapper.PluginRouteMapper;
import com.ohaotian.plugin.model.po.AbilityPluginExtIpPO;
import com.ohaotian.plugin.model.po.AbilityPluginJwtPO;
import com.ohaotian.plugin.model.po.PluginPriorityPO;
import com.ohaotian.plugin.model.po.PluginRouteColumnPO;
import com.ohaotian.plugin.model.po.PluginRouteExtPO;
import com.ohaotian.plugin.model.po.PluginRoutePO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class SyncDataServiceImpl
implements SyncDataService {
    private static Logger logger = LogManager.getLogger(SyncDataServiceImpl.class);
    @Resource
    private AbilityExtMapper abilityExtMapper;
    @Resource
    private AbilityWsExtMapper abilityWsExtMapper;
    @Resource
    private AbilityParamMapper abilityParamMapper;
    @Resource
    private AbilityLogicMapper abilityLogicMapper;
    @Resource
    private AbilityExtColumnMapper abilityExtColumnMapper;
    @Resource
    private AbilityMapper abilityMapper;
    @Autowired
    private AbilityToVegaMapper abilityToVegaMapper;
    @Resource
    private SubAbilityMapper subAbilityMapper;
    @Resource
    private AbilityProvideDubboCustomInputMapper abilityProvideDubboCustomInputMapper;
    @Resource
    private AbilityProvideDubboCustomMapper abilityProvideDubboCustomMapper;
    @Resource
    private AbilityExtCustomMapper abilityExtCustomMapper;
    @Resource
    private AbilityProvideHttpCustomMapper abilityProvideHttpCustomMapper;
    @Resource
    private AbilityProvideHsfCustomMapper abilityProvideHsfCustomMapper;
    @Resource
    private AbilityProvideHsfCustomInputMapper abilityProvideHsfCustomInputMapper;
    @Resource
    private RateLimiterAbilityMapper rateLimiterAbilityMapper;
    @Resource
    private RateLimiterSubscribeMapper rateLimiterSubscribeMapper;
    @Resource
    private AppSubscribeDeployMapper appSubscribeDeployMapper;
    @Resource
    private AbilityProvideDeployMapper abilityProvideDeployMapper;
    @Resource
    private AbilityPluginMapper abilityPluginMapper;
    @Resource
    AbilityPluginExtIpMapper abilityPluginExtIpMapper;
    @Resource
    PluginPriorityMapper pluginPriorityMapper;
    @Resource
    AbilityPluginJwtMapper abilityPluginJwtMapper;
    @Resource
    private AppMapper appMapper;
    @Resource
    private RegionMapper regionMapper;
    @Resource
    private RegionAddrMapper regionAddrMapper;
    @Resource
    private RegionCertificateMapper regionCertificateMapper;
    @Resource
    private PluginMapper pluginMapper;
    @Resource
    private PluginRouteMapper pluginRouteMapper;
    @Resource
    private PluginRouteColumnMapper pluginRouteColumnMapper;
    @Resource
    private PluginRouteExtMapper pluginRouteExtMapper;
    @Resource
    private RspCodeMapper rspCodeMapper;
    @Resource
    private SystemCodeTypeMapper systemCodeTypeMapper;
    @Resource
    private SystemCodeValueMapper systemCodeValueMapper;
    @Resource
    private DefinedExceptionMapper definedExceptionMapper;
    @Resource
    private TableMapper tableMapper;
    @Resource
    private SystemParam systemParam;
    @Resource
    private AppSecretMapper appSecretMapper;
    @Resource
    private SystemExtColumnMapper systemExtColumnMapper;
    @Resource
    private AppExtColumnMapper appExtColumnMapper;
    @Resource
    private AbilityTransMapper abilityTransMapper;
    @Autowired
    @Qualifier(value="restTemplate")
    private RestTemplate restTemplate;

    private String sentToAdmin(SyncDataBO syncDataBO, int type) throws Exception {
        String json = JacksonUtil.toJson((Object)syncDataBO);
        String adminPath = this.systemParam.getAdminPath();
        String context = this.systemParam.getContext();
        StringBuilder sb = new StringBuilder(adminPath);
        if (StringUtils.isNotEmpty((CharSequence)context)) {
            sb.append(context);
        }
        if (type == 0) {
            sb.append("/sync/syncAllData");
        } else {
            sb.append("/sync/syncIncrementData");
        }
        HttpHeaders headers = new HttpHeaders();
        MediaType mediaType = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
        headers.setContentType(mediaType);
        headers.add("Accept", MediaType.APPLICATION_JSON.toString());
        return (String)this.restTemplate.postForEntity(sb.toString(), (Object)new HttpEntity((Object)json, (MultiValueMap)headers), String.class, new Object[0]).getBody();
    }

    @Override
    public void syncAll(List<SyncDataBO> list) throws Exception {
        try {
            for (SyncDataBO syncDataBO : list) {
                String rspJson = this.sentToAdmin(syncDataBO, 0);
                if (!StringUtils.isNotBlank((CharSequence)rspJson)) continue;
                this.syncData2H2(rspJson, 0);
            }
        }
        catch (Exception e) {
            logger.error("\u5168\u91cf\u540c\u6b65\u5931\u8d25\uff1a", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void syncIncrement(List<SyncDataBO> list) throws Exception {
        try {
            this.deleteAttachTable(list.get(0));
            for (SyncDataBO syncDataBO : list) {
                String rspJson = this.sentToAdmin(syncDataBO, 1);
                if (!StringUtils.isNotBlank((CharSequence)rspJson)) continue;
                this.syncData2H2(rspJson, 1);
            }
        }
        catch (Exception e) {
            logger.error("\u589e\u91cf\u540c\u6b65\u5931\u8d25\uff1a", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void modifyStatus(List<SyncDataBO> list, int status) throws Exception {
        logger.debug("SyncDataServiceImpl.modifyStatus:{},{}", (Object)GsonUtil.toJson(list), (Object)status);
        list.forEach(bo -> ValidBatchUtils.isNotEmpty((Object)bo, (String[])new String[]{"hirerId", "firstLevel", "secondLevel", "primaryId"}));
        if (Objects.isNull(status)) {
            throw new AbilityException(CodeMsg.ARG_ERROR.getRspDesc());
        }
        try {
            list.forEach(syncDataBO -> {
                String firstLevel = syncDataBO.getFirstLevel();
                String secondLevel = syncDataBO.getSecondLevel();
                if (FisrtLevelEnum.ABILITY.getName().equals(firstLevel) && SecondLevelEnum.ABILITY_BASIC.getName().equals(secondLevel)) {
                    AbilityPO abilityPO = new AbilityPO();
                    abilityPO.setAbilityId(syncDataBO.getPrimaryId());
                    abilityPO.setAttendStatus(status);
                    this.abilityMapper.updateAbilityByAbilityId(abilityPO);
                    AbilityPO abilityPO1 = this.abilityMapper.queryByAbilityId(syncDataBO.getPrimaryId());
                    EsbAbility ability = EsbAbilityMap.getAbility(abilityPO1.getAbilityEname(), abilityPO1.getAbilityVersion());
                    if (!ObjectUtils.isEmpty((Object)ability)) {
                        ability.setAttendStatus(Integer.valueOf(status));
                        EsbAbilityMap.pushAbility(ability);
                    } else {
                        logger.info("\u80fd\u529b\uff1a{}\uff0c\u672a\u53d1\u5e03\uff01-->{}", (Object)abilityPO1.getAbilityName(), (Object)abilityPO1.getAbilityEname());
                    }
                } else if (FisrtLevelEnum.APP.getName().equals(firstLevel)) {
                    if (SecondLevelEnum.APP.getName().equals(secondLevel)) {
                        AppPO appPO = new AppPO();
                        appPO.setAppId(syncDataBO.getPrimaryId());
                        appPO.setAttendStatus(status);
                        this.appMapper.updateAppByAppId(appPO);
                    } else if (SecondLevelEnum.APP_REGION.getName().equals(secondLevel)) {
                        RegionPO regionPO = new RegionPO();
                        regionPO.setRegionId(syncDataBO.getPrimaryId());
                        regionPO.setAttendStatus(status);
                        this.regionMapper.updateRegionByRegionId(regionPO);
                    } else if (SecondLevelEnum.APP_REGION_ADDR.getName().equals(secondLevel)) {
                        RegionAddrPO regionAddrPO = new RegionAddrPO();
                        regionAddrPO.setRegionAddrId(syncDataBO.getPrimaryId());
                        regionAddrPO.setAttendStatus(status);
                        this.regionAddrMapper.updateRegionAddrByRegionAddrId(regionAddrPO);
                    }
                }
            });
        }
        catch (Exception e) {
            logger.error("\u72b6\u6001\u4fee\u6539\u5931\u8d25,{}", (Object)e.getMessage());
            throw e;
        }
    }

    private void deleteAttachTable(SyncDataBO syncDataBO) {
        Long primaryId = syncDataBO.getPrimaryId();
        ArrayList ids = Lists.newArrayList();
        ids.add(primaryId);
        String firstLevel = syncDataBO.getFirstLevel();
        if (FisrtLevelEnum.ABILITY.getName().equalsIgnoreCase(firstLevel)) {
            this.abilityMapper.deleteAbilityByIds(ids);
            this.abilityExtColumnMapper.deleteEntityByAbilityIds(ids);
            this.abilityExtMapper.deleteEntityByAbilityIds(ids);
            this.abilityWsExtMapper.deleteEntityByAbilityIds(ids);
            this.abilityParamMapper.deleteEntityByAbilityIds(ids);
            this.abilityLogicMapper.deleteEntityByAbilityIds(ids);
            this.subAbilityMapper.deleteEntityByParentAbilityIds(ids);
            this.abilityExtCustomMapper.deleteEntityByAbilityIds(ids);
            this.abilityProvideDubboCustomMapper.deleteEntityByAbilityIds(ids);
            this.abilityProvideDubboCustomInputMapper.deleteEntityByAbilityIds(ids);
            this.abilityProvideHttpCustomMapper.deleteEntityByAbilityIds(ids);
            this.abilityProvideHsfCustomMapper.deleteEntityByAbilityIds(ids);
            this.abilityProvideHsfCustomInputMapper.deleteEntityByAbilityIds(ids);
            this.appSubscribeDeployMapper.deleteEntityByAbilityIds(ids);
            this.abilityProvideDeployMapper.deleteEntityByAbilityIds(ids);
            this.abilityPluginMapper.deleteEntityByAbilityIds(ids);
            this.abilityTransMapper.deleteEntityByAbilityIds(ids);
            this.rateLimiterAbilityMapper.deleteEntityByAbilityIds(ids);
            this.rateLimiterSubscribeMapper.deleteEntityByAbilityIds(ids);
        } else if (FisrtLevelEnum.APP.getName().equalsIgnoreCase(firstLevel) || FisrtLevelEnum.PLUGIN.getName().equalsIgnoreCase(firstLevel)) {
            // empty if block
        }
    }

    @Override
    public void syncData2H2(String jsonStr, int type) throws IOException {
        Map jsonObject1 = JacksonUtil.toMap((String)jsonStr);
        String code = (String)jsonObject1.get("code");
        if (!"0".equals(code)) {
            logger.warn("\u5168\u91cf\u540c\u6b65\u95e8\u6237\u6570\u636e\u5931\u8d25");
            return;
        }
        Map jsonObject = (Map)jsonObject1.get("data");
        block80: for (Map.Entry entry : jsonObject.entrySet()) {
            String tableName = (String)entry.getKey();
            List tableValues1 = (List)entry.getValue();
            int size = tableValues1.size();
            String tableValues = JacksonUtil.toJson((Object)tableValues1);
            switch (tableName) {
                case "ability": {
                    if (type == 0) {
                        this.deleteH2ByTableName(tableName);
                    }
                    if (CollectionUtils.isEmpty((Collection)tableValues1) || size == 0) continue block80;
                    logger.info("\u540c\u6b65{}\u8868\u6210\u529f\uff0c\u5171\u540c\u6b65{}\u6761\u6570\u636e", (Object)tableName, (Object)size);
                    List abilityList = GsonUtil.fromList((String)tableValues, AbilityPO[].class);
                    this.abilityMapper.insertRecords(abilityList);
                    continue block80;
                }
                case "ability_to_vega": {
                    if (type == 0) {
                        this.deleteH2ByTableName(tableName);
                    }
                    if (CollectionUtils.isEmpty((Collection)tableValues1) || size == 0) continue block80;
                    logger.info("\u540c\u6b65{}\u8868\u6210\u529f\uff0c\u5171\u540c\u6b65{}\u6761\u6570\u636e", (Object)tableName, (Object)size);
                    List abilityToVegaPoList = GsonUtil.fromList((String)tableValues, AbilityToVegaPo[].class);
                    this.abilityToVegaMapper.batchInsert(abilityToVegaPoList);
                    continue block80;
                }
                case "ability_ext_column": {
                    if (type == 0) {
                        this.deleteH2ByTableName(tableName);
                    }
                    if (CollectionUtils.isEmpty((Collection)tableValues1) || size == 0) continue block80;
                    logger.info("\u540c\u6b65{}\u8868\u6210\u529f\uff0c\u5171\u540c\u6b65{}\u6761\u6570\u636e", (Object)tableName, (Object)size);
                    List abilityExtColumnPOList = GsonUtil.fromList((String)tableValues, AbilityExtColumnPO[].class);
                    this.abilityExtColumnMapper.insertRecords(abilityExtColumnPOList);
                    continue block80;
                }
                case "ability_ext": {
                    if (type == 0) {
                        this.deleteH2ByTableName(tableName);
                    }
                    if (CollectionUtils.isEmpty((Collection)tableValues1) || size == 0) continue block80;
                    logger.info("\u540c\u6b65{}\u8868\u6210\u529f\uff0c\u5171\u540c\u6b65{}\u6761\u6570\u636e", (Object)tableName, (Object)size);
                    List abilityExtPOList = GsonUtil.fromList((String)tableValues, AbilityExtPO[].class);
                    this.abilityExtMapper.insertRecords(abilityExtPOList);
                    continue block80;
                }
                case "ability_ws_ext": {
                    if (type == 0) {
                        this.deleteH2ByTableName(tableName);
                    }
                    if (CollectionUtils.isEmpty((Collection)tableValues1) || size == 0) continue block80;
                    logger.info("\u540c\u6b65{}\u8868\u6210\u529f\uff0c\u5171\u540c\u6b65{}\u6761\u6570\u636e", (Object)tableName, (Object)size);
                    List abilityWsExtPOList = GsonUtil.fromList((String)tableValues, AbilityWsExtPO[].class);
                    this.abilityWsExtMapper.insertRecords(abilityWsExtPOList);
                    continue block80;
                }
                case "ability_param": {
                    if (type == 0) {
                        this.deleteH2ByTableName(tableName);
                    }
                    if (CollectionUtils.isEmpty((Collection)tableValues1) || size == 0) continue block80;
                    logger.info("\u540c\u6b65{}\u8868\u6210\u529f\uff0c\u5171\u540c\u6b65{}\u6761\u6570\u636e", (Object)tableName, (Object)size);
                    List abilityParamPOList = GsonUtil.fromList((String)tableValues, AbilityParamPO[].class);
                    this.abilityParamMapper.insertRecords(abilityParamPOList);
                    continue block80;
                }
                case "ability_logic": {
                    if (type == 0) {
                        this.deleteH2ByTableName(tableName);
                    }
                    if (CollectionUtils.isEmpty((Collection)tableValues1) || size == 0) continue block80;
                    logger.info("\u540c\u6b65{}\u8868\u6210\u529f\uff0c\u5171\u540c\u6b65{}\u6761\u6570\u636e", (Object)tableName, (Object)size);
                    List abilityLogicPOList = GsonUtil.fromList((String)tableValues, AbilityLogicPO[].class);
                    this.abilityLogicMapper.insertRecords(abilityLogicPOList);
                    continue block80;
                }
                case "sub_ability": {
                    if (type == 0) {
                        this.deleteH2ByTableName(tableName);
                    }
                    if (CollectionUtils.isEmpty((Collection)tableValues1) || size == 0) continue block80;
                    logger.info("\u540c\u6b65{}\u8868\u6210\u529f\uff0c\u5171\u540c\u6b65{}\u6761\u6570\u636e", (Object)tableName, (Object)size);
                    List subAbilityPOList = GsonUtil.fromList((String)tableValues, SubAbilityPO[].class);
                    this.subAbilityMapper.insertRecords(subAbilityPOList);
                    continue block80;
                }
                case "ability_ext_custom": {
                    if (type == 0) {
                        this.deleteH2ByTableName(tableName);
                    }
                    if (CollectionUtils.isEmpty((Collection)tableValues1) || size == 0) continue block80;
                    logger.info("\u540c\u6b65{}\u8868\u6210\u529f\uff0c\u5171\u540c\u6b65{}\u6761\u6570\u636e", (Object)tableName, (Object)size);
                    List abilityExtCustomPOList = GsonUtil.fromList((String)tableValues, AbilityExtCustomPO[].class);
                    this.abilityExtCustomMapper.insertRecords(abilityExtCustomPOList);
                    continue block80;
                }
                case "ability_provide_dubbo_custom": {
                    if (type == 0) {
                        this.deleteH2ByTableName(tableName);
                    }
                    if (CollectionUtils.isEmpty((Collection)tableValues1) || size == 0) continue block80;
                    logger.info("\u540c\u6b65{}\u8868\u6210\u529f\uff0c\u5171\u540c\u6b65{}\u6761\u6570\u636e", (Object)tableName, (Object)size);
                    List abilityProvideDubboCustomPOList = GsonUtil.fromList((String)tableValues, AbilityProvideDubboCustomPO[].class);
                    this.abilityProvideDubboCustomMapper.insertRecords(abilityProvideDubboCustomPOList);
                    continue block80;
                }
                case "ability_provide_dubbo_custom_input": {
                    if (type == 0) {
                        this.deleteH2ByTableName(tableName);
                    }
                    if (CollectionUtils.isEmpty((Collection)tableValues1) || size == 0) continue block80;
                    logger.info("\u540c\u6b65{}\u8868\u6210\u529f\uff0c\u5171\u540c\u6b65{}\u6761\u6570\u636e", (Object)tableName, (Object)size);
                    List abilityProvideDubboCustomInputPOList = GsonUtil.fromList((String)tableValues, AbilityProvideDubboCustomInputPO[].class);
                    this.abilityProvideDubboCustomInputMapper.insertRecords(abilityProvideDubboCustomInputPOList);
                    continue block80;
                }
                case "ability_provide_http_custom": {
                    if (type == 0) {
                        this.deleteH2ByTableName(tableName);
                    }
                    if (CollectionUtils.isEmpty((Collection)tableValues1) || size == 0) continue block80;
                    logger.info("\u540c\u6b65{}\u8868\u6210\u529f\uff0c\u5171\u540c\u6b65{}\u6761\u6570\u636e", (Object)tableName, (Object)size);
                    List abilityProvideHttpCustomPOList = GsonUtil.fromList((String)tableValues, AbilityProvideHttpCustomPO[].class);
                    this.abilityProvideHttpCustomMapper.insertRecords(abilityProvideHttpCustomPOList);
                    continue block80;
                }
                case "ability_provide_hsf_custom": {
                    if (type == 0) {
                        this.deleteH2ByTableName(tableName);
                    }
                    if (CollectionUtils.isEmpty((Collection)tableValues1) || size == 0) continue block80;
                    logger.info("\u540c\u6b65{}\u8868\u6210\u529f\uff0c\u5171\u540c\u6b65{}\u6761\u6570\u636e", (Object)tableName, (Object)size);
                    List abilityProvideHsfCustomPOList = GsonUtil.fromList((String)tableValues, AbilityProvideHsfCustomPO[].class);
                    this.abilityProvideHsfCustomMapper.insertRecords(abilityProvideHsfCustomPOList);
                    continue block80;
                }
                case "ability_provide_hsf_custom_input": {
                    if (type == 0) {
                        this.deleteH2ByTableName(tableName);
                    }
                    if (CollectionUtils.isEmpty((Collection)tableValues1) || size == 0) continue block80;
                    logger.info("\u540c\u6b65{}\u8868\u6210\u529f\uff0c\u5171\u540c\u6b65{}\u6761\u6570\u636e", (Object)tableName, (Object)size);
                    List abilityProvideHsfCustomInputPOList = GsonUtil.fromList((String)tableValues, AbilityProvideHsfCustomInputPO[].class);
                    this.abilityProvideHsfCustomInputMapper.insertRecords(abilityProvideHsfCustomInputPOList);
                    continue block80;
                }
                case "rate_limiter_ability": {
                    if (type == 0) {
                        this.deleteH2ByTableName(tableName);
                    }
                    if (CollectionUtils.isEmpty((Collection)tableValues1) || size == 0) continue block80;
                    logger.info("\u540c\u6b65{}\u8868\u6210\u529f\uff0c\u5171\u540c\u6b65{}\u6761\u6570\u636e", (Object)tableName, (Object)size);
                    List rateLimiterAbilityPOList = GsonUtil.fromList((String)tableValues, RateLimiterAbilityPO[].class);
                    this.rateLimiterAbilityMapper.insertRecords(rateLimiterAbilityPOList);
                    continue block80;
                }
                case "app_subscribe_deploy": {
                    if (type == 0) {
                        this.deleteH2ByTableName(tableName);
                    }
                    if (CollectionUtils.isEmpty((Collection)tableValues1) || size == 0) continue block80;
                    logger.info("\u540c\u6b65{}\u8868\u6210\u529f\uff0c\u5171\u540c\u6b65{}\u6761\u6570\u636e", (Object)tableName, (Object)size);
                    List appSubscribeDeployPOList = GsonUtil.fromList((String)tableValues, AppSubscribeDeployPO[].class);
                    this.appSubscribeDeployMapper.insertRecords(appSubscribeDeployPOList);
                    continue block80;
                }
                case "ability_provide_deploy": {
                    if (type == 0) {
                        this.deleteH2ByTableName(tableName);
                    }
                    if (CollectionUtils.isEmpty((Collection)tableValues1) || size == 0) continue block80;
                    logger.info("\u540c\u6b65{}\u8868\u6210\u529f\uff0c\u5171\u540c\u6b65{}\u6761\u6570\u636e", (Object)tableName, (Object)size);
                    List<AbilityProvideDeployPO> abilityProvideDeployPOList = GsonUtil.fromList((String)tableValues, AbilityProvideDeployPO[].class);
                    abilityProvideDeployPOList = abilityProvideDeployPOList.stream().peek(po -> {
                        if (po.getDeployStatus() != null && po.getDeployStatus() == 3) {
                            po.setDeployStatus(1);
                        }
                    }).collect(Collectors.toList());
                    this.abilityProvideDeployMapper.insertRecords(abilityProvideDeployPOList);
                    continue block80;
                }
                case "ability_plugin": {
                    if (type == 0) {
                        this.deleteH2ByTableName(tableName);
                    }
                    if (CollectionUtils.isEmpty((Collection)tableValues1) || size == 0) continue block80;
                    logger.info("\u540c\u6b65{}\u8868\u6210\u529f\uff0c\u5171\u540c\u6b65{}\u6761\u6570\u636e", (Object)tableName, (Object)size);
                    List abilityPluginPOList = GsonUtil.fromList((String)tableValues, AbilityPluginPO[].class);
                    this.abilityPluginMapper.insertRecords(abilityPluginPOList);
                    continue block80;
                }
                case "rate_limiter_subscribe": {
                    if (type == 0) {
                        this.deleteH2ByTableName(tableName);
                    }
                    if (CollectionUtils.isEmpty((Collection)tableValues1) || size == 0) continue block80;
                    logger.info("\u540c\u6b65{}\u8868\u6210\u529f\uff0c\u5171\u540c\u6b65{}\u6761\u6570\u636e", (Object)tableName, (Object)size);
                    List rateLimiterSubscribePOList = GsonUtil.fromList((String)tableValues, RateLimiterSubscribePO[].class);
                    this.rateLimiterSubscribeMapper.insertRecords(rateLimiterSubscribePOList);
                    continue block80;
                }
                case "app": {
                    List<Long> ids;
                    if (type == 0) {
                        this.deleteH2ByTableName(tableName);
                    }
                    if (CollectionUtils.isEmpty((Collection)tableValues1) || size == 0) continue block80;
                    logger.info("\u540c\u6b65{}\u8868\u6210\u529f\uff0c\u5171\u540c\u6b65{}\u6761\u6570\u636e", (Object)tableName, (Object)size);
                    List appPOList = GsonUtil.fromList((String)tableValues, AppPO[].class);
                    if (type == 1) {
                        ids = appPOList.stream().map(p -> p.getAppId()).collect(Collectors.toList());
                        this.appMapper.deleteAppByIds(ids);
                    }
                    this.appMapper.insertRecords(appPOList);
                    continue block80;
                }
                case "app_ext_column": {
                    if (type == 0) {
                        this.deleteH2ByTableName(tableName);
                    }
                    if (CollectionUtils.isEmpty((Collection)tableValues1) || size == 0) continue block80;
                    logger.info("\u540c\u6b65{}\u8868\u6210\u529f\uff0c\u5171\u540c\u6b65{}\u6761\u6570\u636e", (Object)tableName, (Object)size);
                    List appExtColumnPOList = GsonUtil.fromList((String)tableValues, AppExtColumnPO[].class);
                    this.appExtColumnMapper.insertRecords(appExtColumnPOList);
                    continue block80;
                }
                case "app_secret": {
                    List<Long> ids;
                    if (type == 0) {
                        this.deleteH2ByTableName(tableName);
                    }
                    if (CollectionUtils.isEmpty((Collection)tableValues1) || size == 0) continue block80;
                    logger.info("\u540c\u6b65{}\u8868\u6210\u529f\uff0c\u5171\u540c\u6b65{}\u6761\u6570\u636e", (Object)tableName, (Object)size);
                    List appSecretPOList = GsonUtil.fromList((String)tableValues, AppSecretPO[].class);
                    if (type == 1) {
                        ids = appSecretPOList.stream().map(p -> p.getAppId()).collect(Collectors.toList());
                        this.appSecretMapper.deleteAppSecretByIds(ids);
                    }
                    this.appSecretMapper.insertRecords(appSecretPOList);
                    continue block80;
                }
                case "region": {
                    List<Long> ids;
                    if (type == 0) {
                        this.deleteH2ByTableName(tableName);
                    }
                    if (CollectionUtils.isEmpty((Collection)tableValues1) || size == 0) continue block80;
                    logger.info("\u540c\u6b65{}\u8868\u6210\u529f\uff0c\u5171\u540c\u6b65{}\u6761\u6570\u636e", (Object)tableName, (Object)size);
                    List regionPOList = GsonUtil.fromList((String)tableValues, RegionPO[].class);
                    if (type == 1) {
                        ids = regionPOList.stream().map(p -> p.getRegionId()).collect(Collectors.toList());
                        this.regionMapper.deleteRegionByIds(ids);
                    }
                    this.regionMapper.insertRecords(regionPOList);
                    continue block80;
                }
                case "region_addr": {
                    List<Long> ids;
                    if (type == 0) {
                        this.deleteH2ByTableName(tableName);
                    }
                    if (CollectionUtils.isEmpty((Collection)tableValues1) || size == 0) continue block80;
                    logger.info("\u540c\u6b65{}\u8868\u6210\u529f\uff0c\u5171\u540c\u6b65{}\u6761\u6570\u636e", (Object)tableName, (Object)size);
                    List regionAddrPOList = GsonUtil.fromList((String)tableValues, RegionAddrPO[].class);
                    if (type == 1) {
                        ids = regionAddrPOList.stream().map(p -> p.getRegionAddrId()).collect(Collectors.toList());
                        this.regionAddrMapper.deleteRegionAddrByIds(ids);
                    }
                    this.regionAddrMapper.insertRecords(regionAddrPOList);
                    continue block80;
                }
                case "region_certificate": {
                    List<Long> ids;
                    if (type == 0) {
                        this.deleteH2ByTableName(tableName);
                    }
                    if (CollectionUtils.isEmpty((Collection)tableValues1) || size == 0) continue block80;
                    logger.info("\u540c\u6b65{}\u8868\u6210\u529f\uff0c\u5171\u540c\u6b65{}\u6761\u6570\u636e", (Object)tableName, (Object)size);
                    List regionCertificatePOList = GsonUtil.fromList((String)tableValues, RegionCertificatePO[].class);
                    if (type == 1) {
                        ids = regionCertificatePOList.stream().map(p -> p.getRegionCertificateId()).collect(Collectors.toList());
                        this.regionCertificateMapper.deleteRegionCertificateByIds(ids);
                    }
                    this.regionCertificateMapper.insertRecords(regionCertificatePOList);
                    continue block80;
                }
                case "plugin": {
                    List<Long> ids;
                    if (type == 0) {
                        this.deleteH2ByTableName(tableName);
                    }
                    if (CollectionUtils.isEmpty((Collection)tableValues1) || size == 0) continue block80;
                    logger.info("\u540c\u6b65{}\u8868\u6210\u529f\uff0c\u5171\u540c\u6b65{}\u6761\u6570\u636e", (Object)tableName, (Object)size);
                    List pluginPOList = GsonUtil.fromList((String)tableValues, PluginPO[].class);
                    if (type == 1) {
                        ids = pluginPOList.stream().map(p -> p.getPluginId()).collect(Collectors.toList());
                        this.pluginMapper.deletePluginByIds(ids);
                    }
                    this.pluginMapper.insertRecords(pluginPOList);
                    continue block80;
                }
                case "rsp_code": {
                    if (type == 0) {
                        this.deleteH2ByTableName(tableName);
                    }
                    if (CollectionUtils.isEmpty((Collection)tableValues1) || size == 0) continue block80;
                    logger.info("\u540c\u6b65{}\u8868\u6210\u529f\uff0c\u5171\u540c\u6b65{}\u6761\u6570\u636e", (Object)tableName, (Object)size);
                    List rspCodeList = GsonUtil.fromList((String)tableValues, RspCodePO[].class);
                    this.rspCodeMapper.insertRecords(rspCodeList);
                    continue block80;
                }
                case "system_code_type": {
                    if (type == 0) {
                        this.deleteH2ByTableName(tableName);
                    }
                    if (CollectionUtils.isEmpty((Collection)tableValues1) || size == 0) continue block80;
                    logger.info("\u540c\u6b65{}\u8868\u6210\u529f\uff0c\u5171\u540c\u6b65{}\u6761\u6570\u636e", (Object)tableName, (Object)size);
                    List systemCodeValueList = GsonUtil.fromList((String)tableValues, SystemCodeTypePO[].class);
                    this.systemCodeTypeMapper.insertRecords(systemCodeValueList);
                    continue block80;
                }
                case "system_code_value": {
                    if (type == 0) {
                        this.deleteH2ByTableName(tableName);
                    }
                    if (CollectionUtils.isEmpty((Collection)tableValues1) || size == 0) continue block80;
                    logger.info("\u540c\u6b65{}\u8868\u6210\u529f\uff0c\u5171\u540c\u6b65{}\u6761\u6570\u636e", (Object)tableName, (Object)size);
                    List systemCodeValueList = GsonUtil.fromList((String)tableValues, SystemCodeValuePO[].class);
                    this.systemCodeValueMapper.insertRecords(systemCodeValueList);
                    continue block80;
                }
                case "defined_exception": {
                    if (type == 0) {
                        this.deleteH2ByTableName(tableName);
                    }
                    if (CollectionUtils.isEmpty((Collection)tableValues1) || size == 0) continue block80;
                    logger.info("\u540c\u6b65{}\u8868\u6210\u529f\uff0c\u5171\u540c\u6b65{}\u6761\u6570\u636e", (Object)tableName, (Object)size);
                    List definedExceptionPOList = GsonUtil.fromList((String)tableValues, DefinedExceptionPO[].class);
                    this.definedExceptionMapper.insertRecords(definedExceptionPOList);
                    continue block80;
                }
                case "system_ext_column": {
                    if (type == 0) {
                        this.deleteH2ByTableName(tableName);
                    }
                    if (CollectionUtils.isEmpty((Collection)tableValues1) || size == 0) continue block80;
                    logger.info("\u540c\u6b65{}\u8868\u6210\u529f\uff0c\u5171\u540c\u6b65{}\u6761\u6570\u636e", (Object)tableName, (Object)size);
                    List systemExtColumnPOList = GsonUtil.fromList((String)tableValues, SystemExtColumnPO[].class);
                    this.systemExtColumnMapper.insertRecords(systemExtColumnPOList);
                    continue block80;
                }
                case "ability_trans": {
                    if (type == 0) {
                        this.deleteH2ByTableName(tableName);
                    }
                    if (CollectionUtils.isEmpty((Collection)tableValues1) || size == 0) continue block80;
                    logger.info("\u540c\u6b65{}\u8868\u6210\u529f\uff0c\u5171\u540c\u6b65{}\u6761\u6570\u636e", (Object)tableName, (Object)size);
                    List abilityTransPOList = GsonUtil.fromList((String)tableValues, AbilityTransPO[].class);
                    this.abilityTransMapper.insertRecords(abilityTransPOList);
                    continue block80;
                }
                case "plugin_route": {
                    List<Long> ids;
                    if (type == 0) {
                        this.deleteH2ByTableName(tableName);
                    }
                    if (Objects.isNull(tableValues) || size == 0) continue block80;
                    logger.info("\u540c\u6b65{}\u8868\u6210\u529f\uff0c\u5171\u540c\u6b65{}\u6761\u6570\u636e", (Object)tableName, (Object)size);
                    List pluginPriorityPOList = GsonUtil.fromList((String)tableValues, PluginRoutePO[].class);
                    if (type == 1) {
                        ids = pluginPriorityPOList.stream().map(p -> p.getPluginId()).collect(Collectors.toList());
                        this.pluginRouteMapper.deleteEntityByPluginIds(ids);
                    }
                    this.pluginRouteMapper.insertRecords(pluginPriorityPOList);
                    continue block80;
                }
                case "plugin_route_column": {
                    List<Long> ids;
                    if (type == 0) {
                        this.deleteH2ByTableName(tableName);
                    }
                    if (Objects.isNull(tableValues) || size == 0) continue block80;
                    logger.info("\u540c\u6b65{}\u8868\u6210\u529f\uff0c\u5171\u540c\u6b65{}\u6761\u6570\u636e", (Object)tableName, (Object)size);
                    List pluginRouteColumnPOList = GsonUtil.fromList((String)tableValues, PluginRouteColumnPO[].class);
                    if (type == 1) {
                        ids = pluginRouteColumnPOList.stream().map(p -> p.getAbilityPluginId()).collect(Collectors.toList());
                        this.pluginRouteColumnMapper.deleteEntityByAbilityPluginIds(ids);
                    }
                    this.pluginRouteColumnMapper.insertRecords(pluginRouteColumnPOList);
                    continue block80;
                }
                case "plugin_route_ext": {
                    List<Long> ids;
                    if (type == 0) {
                        this.deleteH2ByTableName(tableName);
                    }
                    if (Objects.isNull(tableValues) || size == 0) continue block80;
                    logger.info("\u540c\u6b65{}\u8868\u6210\u529f\uff0c\u5171\u540c\u6b65{}\u6761\u6570\u636e", (Object)tableName, (Object)size);
                    List pluginRouteExtPOList = GsonUtil.fromList((String)tableValues, PluginRouteExtPO[].class);
                    if (type == 1) {
                        ids = pluginRouteExtPOList.stream().map(p -> p.getAbilityPluginId()).collect(Collectors.toList());
                        this.pluginRouteExtMapper.deleteEntityByAbilityPluginIds(ids);
                    }
                    this.pluginRouteExtMapper.insertRecords(pluginRouteExtPOList);
                    continue block80;
                }
                case "ability_plugin_ext_ip": {
                    List<Long> ids;
                    if (type == 0) {
                        this.deleteH2ByTableName(tableName);
                    }
                    if (Objects.isNull(tableValues) || size == 0) continue block80;
                    logger.info("\u540c\u6b65{}\u8868\u6210\u529f\uff0c\u5171\u540c\u6b65{}\u6761\u6570\u636e", (Object)tableName, (Object)size);
                    List abilityPluginExtIpPOList = GsonUtil.fromList((String)tableValues, AbilityPluginExtIpPO[].class);
                    if (type == 1) {
                        ids = abilityPluginExtIpPOList.stream().map(p -> p.getPluginId()).collect(Collectors.toList());
                        this.abilityPluginExtIpMapper.deleteEntityByPluginIds(ids);
                    }
                    this.abilityPluginExtIpMapper.insertRecords(abilityPluginExtIpPOList);
                    continue block80;
                }
                case "plugin_priority": {
                    List<Long> ids;
                    if (type == 0) {
                        this.deleteH2ByTableName(tableName);
                    }
                    if (Objects.isNull(tableValues) || size == 0) continue block80;
                    logger.info("\u540c\u6b65{}\u8868\u6210\u529f\uff0c\u5171\u540c\u6b65{}\u6761\u6570\u636e", (Object)tableName, (Object)size);
                    List pluginPriorityPOList = GsonUtil.fromList((String)tableValues, PluginPriorityPO[].class);
                    if (type == 1) {
                        ids = pluginPriorityPOList.stream().map(p -> p.getAbilityPluginId()).collect(Collectors.toList());
                        this.pluginPriorityMapper.deleteEntityByAbilityPluginIds(ids);
                    }
                    this.pluginPriorityMapper.insertRecords(pluginPriorityPOList);
                    continue block80;
                }
                case "ability_plugin_jwt": {
                    List<Long> ids;
                    if (type == 0) {
                        this.deleteH2ByTableName(tableName);
                    }
                    if (Objects.isNull(tableValues) || size == 0) continue block80;
                    logger.info("\u540c\u6b65{}\u8868\u6210\u529f\uff0c\u5171\u540c\u6b65{}\u6761\u6570\u636e", (Object)tableName, (Object)size);
                    List abilityPluginJwtPOList = GsonUtil.fromList((String)tableValues, AbilityPluginJwtPO[].class);
                    if (type == 1) {
                        ids = abilityPluginJwtPOList.stream().map(p -> p.getAbilityPluginId()).collect(Collectors.toList());
                        this.abilityPluginJwtMapper.deleteEntityByAbilityPluginIds(ids);
                    }
                    this.abilityPluginJwtMapper.insertRecords(abilityPluginJwtPOList);
                    continue block80;
                }
            }
            logger.info("\u5168\u91cf\u540c\u6b65\u6570\u636e\uff0c\u8868\u540d{}\u4e0d\u5b58\u5728", (Object)tableName);
        }
    }

    private void deleteH2ByTableName(String tableName) {
        int count = this.tableMapper.countTableByName(tableName);
        if (count > 0) {
            logger.info("\u6e05\u9664{}\u8868\u6210\u529f\uff0c\u5171\u5220\u9664{}\u6761\u6570\u636e", (Object)tableName, (Object)count);
        }
        this.tableMapper.trucateTableByName(tableName);
    }
}

