/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityweb.service.transform.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.abilitycommon.exception.AbilityException;
import com.ohaotian.abilitycommon.model.bo.CodeMsg;
import com.ohaotian.abilitycommon.model.bo.system.EsbAbility;
import com.ohaotian.abilitycommon.model.bo.system.MsgContext;
import com.ohaotian.abilityweb.model.po.AbilityTransPO;
import com.ohaotian.abilityweb.service.transform.TransFormService;
import com.ohaotian.abilityweb.service.transform.impl.TransFormLogicServiceImpl;
import com.ohaotian.plugin.api.DataProcessingService;
import com.ohaotian.plugin.api.InterfaceService;
import com.ohaotian.plugin.exception.InterfaceException;
import com.ohaotian.plugin.model.FaceMsgContext;
import org.apache.http.Consts;
import org.apache.logging.log4j.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="transFormXmlLogic")
public class TransFormXmlLogicServiceImpl
implements TransFormService {
    private static final Logger log = LoggerFactory.getLogger(TransFormXmlLogicServiceImpl.class);
    private static org.apache.logging.log4j.Logger logger = LogManager.getLogger(TransFormLogicServiceImpl.class);
    @Autowired
    private InterfaceService interfaceService;

    @Override
    public void invokeTransFront(MsgContext msgContext) {
        String xml = msgContext.getEsbAbility().getFrontXmlLogic();
        try {
            this.interfaceService.doService((Object)msgContext, xml);
        }
        catch (InterfaceException e) {
            throw new AbilityException(CodeMsg.E_INVOKE_COMLOGIC_ERROR.fillArgs(new Object[]{"\n\u63a5\u53e3\u5e73\u53f0\u89e3\u6790\u5165\u53c2\u5f02\u5e38"}) + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void invokeTransBack(MsgContext msgContext) {
        String xml = msgContext.getEsbAbility().getBackXmlLogic();
        try {
            this.interfaceService.doService((Object)msgContext, xml);
        }
        catch (InterfaceException e) {
            throw new AbilityException(CodeMsg.E_INVOKE_COMLOGIC_ERROR.fillArgs(new Object[]{"\n\u63a5\u53e3\u5e73\u53f0\u89e3\u6790\u51fa\u53c2\u5f02\u5e38"}) + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void deployEsbServiceReq(EsbAbility esbAbility, AbilityTransPO abilityTransPO) {
        esbAbility.setReqTransType(abilityTransPO.getReqTransType());
        esbAbility.setFrontXmlLogic(abilityTransPO.getFrontXmlLogic());
    }

    @Override
    public void deployEsbServiceRsp(EsbAbility esbAbility, AbilityTransPO abilityTransPO) {
        esbAbility.setRspTransType(abilityTransPO.getRspTransType());
        esbAbility.setBackXmlLogic(abilityTransPO.getBackXmlLogic());
    }

    @Service(value="ability")
    class DataProcessingVegaServiceImpl
    implements DataProcessingService {
        DataProcessingVegaServiceImpl() {
        }

        public <M> FaceMsgContext<M> doInitService(FaceMsgContext<M> faceMsgContext) throws InterfaceException {
            MsgContext base = (MsgContext)faceMsgContext.getSystem().getBase();
            if (base.getTlogRspHeader() != null && base.getTlogRspHeader().getRspData() != null) {
                String rspJson = new String(base.getTlogReqHeader().getReqData(), Consts.UTF_8);
                if (rspJson.charAt(0) == '[' && rspJson.charAt(rspJson.length() - 1) == ']') {
                    faceMsgContext.getSystem().getVariable().put("rspText", JSONArray.parseArray((String)rspJson));
                } else {
                    faceMsgContext.getSystem().getVariable().put("rspText", JSONObject.parseObject((String)rspJson));
                }
            } else if (base.getTlogReqHeader() != null && base.getTlogReqHeader().getReqData() != null) {
                String reqJson = new String(base.getTlogReqHeader().getReqData(), Consts.UTF_8);
                if (reqJson.charAt(0) == '[' && reqJson.charAt(reqJson.length() - 1) == ']') {
                    faceMsgContext.getSystem().getVariable().put("reqText", JSONArray.parseArray((String)reqJson));
                } else {
                    faceMsgContext.getSystem().getVariable().put("reqText", JSONObject.parseObject((String)reqJson));
                }
            } else {
                throw new InterfaceException("\n\t\u811a\u672c\u521d\u59cb\u5316\u53d1\u751f\u9519\u8bef\uff0c\u6ca1\u6709\u8bf7\u6c42\u6216\u54cd\u5e94\u62a5\u6587");
            }
            return null;
        }

        public <M> FaceMsgContext<M> doAssignmentService(FaceMsgContext<M> faceMsgContext) throws InterfaceException {
            MsgContext base = (MsgContext)faceMsgContext.getSystem().getBase();
            if (faceMsgContext.getSystem().getVariable().get("rspText") != null) {
                ((MsgContext)faceMsgContext.getSystem().getBase()).getTlogRspHeader().setRspData(faceMsgContext.getSystem().getVariable().get("rspText").toString().getBytes(Consts.UTF_8));
            } else if (faceMsgContext.getSystem().getVariable().get("reqText") != null) {
                ((MsgContext)faceMsgContext.getSystem().getBase()).getTlogReqHeader().setReqData(faceMsgContext.getSystem().getVariable().get("reqText").toString().getBytes(Consts.UTF_8));
            } else {
                throw new InterfaceException("\n\t\u811a\u672c\u7ed3\u675f\u8d4b\u503c\u53d1\u751f\u9519\u8bef\uff0c\u6ca1\u6709\u8bf7\u6c42\u6216\u54cd\u5e94\u62a5\u6587");
            }
            return null;
        }
    }
}

