/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityweb.service.vega;

import com.ohaotian.abilitycommon.model.bo.system.MsgContext;
import com.ohaotian.abilitycommon.util.GsonUtil;
import com.ohaotian.abilityweb.mapper.AbilityToVegaMapper;
import com.ohaotian.abilityweb.model.po.AbilityToVegaPo;
import com.ohaotian.abilityweb.service.vega.AbilityToVegaService;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Consts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class AbilityToVegaServiceImpl
implements AbilityToVegaService {
    private static final Logger log = LoggerFactory.getLogger(AbilityToVegaServiceImpl.class);
    @Value(value="${ability.to.vega.path:http://39.107.158.51:8080}")
    private String vegaPath;
    @Value(value="${ability.to.vega.oapkey:}")
    private String oapkey;
    @Value(value="${ability.to.vega.oapkeyLabel:oapkey}")
    private String oapkeyLabel;
    @Value(value="${ability.to.vega.defaultHsnLabel:hsn}")
    private String defaultHsnLabel;
    @Autowired
    private AbilityToVegaMapper abilityToVegaMapper;

    @Override
    public void init(MsgContext msgContext) {
        Long abilityId = msgContext.getEsbAbility().getAbilityId();
        AbilityToVegaPo abilityToVegaPo = this.abilityToVegaMapper.queryByAbilityId(abilityId);
        if (Boolean.FALSE.equals(ObjectUtils.isEmpty((Object)abilityToVegaPo))) {
            if (abilityToVegaPo.getForwardStatus().equals(0)) {
                msgContext.getAbilityToVega().setToVega(Boolean.FALSE);
                return;
            }
            msgContext.getAbilityToVega().setToVega(Boolean.TRUE);
            msgContext.getAbilityToVega().setOapkey(this.oapkey);
            msgContext.getAbilityToVega().setOapkeyLabel(this.oapkeyLabel);
            if (Boolean.TRUE.equals(StringUtils.isBlank((CharSequence)abilityToVegaPo.getToVegaPath()))) {
                msgContext.getAbilityToVega().setVegaPath(this.vegaPath);
            } else {
                msgContext.getAbilityToVega().setVegaPath(abilityToVegaPo.getToVegaPath());
            }
            if (Boolean.TRUE.equals(StringUtils.isNotBlank((CharSequence)abilityToVegaPo.getRouterAddress()))) {
                msgContext.getAbilityToVega().setRouterAddress(abilityToVegaPo.getRouterAddress());
            }
        } else {
            return;
        }
        msgContext.getAbilityToVega().setHsnLabel(this.defaultHsnLabel);
        msgContext.getAbilityToVega().setRegionCodes(abilityToVegaPo.getRegionCodes());
        if (StringUtils.isBlank((CharSequence)msgContext.getAbilityToVega().getVegaPath()) || StringUtils.isBlank((CharSequence)msgContext.getAbilityToVega().getOapkey())) {
            log.error("\u8c03\u7528\u6c47\u805a\u5e73\u53f0\u5931\u8d25\uff01\u68c0\u67e5\u914d\u7f6e\uff01");
            msgContext.getAbilityToVega().setToVega(Boolean.FALSE);
            return;
        }
        String jsonStr = new String(msgContext.getTlogReqHeader().getReqData(), Consts.UTF_8);
        Map map = GsonUtil.toObjectMap((String)jsonStr);
        Boolean flag = this.determinePartitionForward(msgContext.getAbilityToVega().getRegionCodes(), map.get(msgContext.getAbilityToVega().getHsnLabel()));
        if (Boolean.TRUE.equals(flag)) {
            log.info("\u8be5\u843d\u5730\u5206\u533a\u6ca1\u6709\u914d\u7f6e\u6c47\u805a\u8f6c\u53d1\uff01");
            msgContext.getAbilityToVega().setToVega(Boolean.FALSE);
        }
    }

    @Override
    public void doService(MsgContext msgContext) {
        if (Boolean.FALSE.equals(msgContext.getAbilityToVega().getToVega())) {
            return;
        }
        String jsonStr = new String(msgContext.getAbilityToVega().getReqData(), Consts.UTF_8);
        if (Boolean.TRUE.equals(msgContext.getAbilityToVega().getUpdateReqBody())) {
            log.info("\u66f4\u65b0\u8bf7\u6c42\u8f6c\u5316\u62a5\u6587\u8fdb\u884c\u6c47\u805a\u8f6c\u53d1\uff01");
            jsonStr = new String(msgContext.getTlogReqHeader().getReqData(), StandardCharsets.UTF_8);
        }
        Map map = GsonUtil.toObjectMap((String)jsonStr);
        msgContext.getSelfDefHeader().getSelfDefMap().put(msgContext.getAbilityToVega().getOapkeyLabel(), msgContext.getAbilityToVega().getOapkey());
        jsonStr = GsonUtil.toJson((Object)map);
        msgContext.getTlogReqHeader().setReqData(jsonStr.getBytes(StandardCharsets.UTF_8));
        msgContext.getAbilityToVega().setRouterAddress(msgContext.getAbilityToVega().getVegaPath() + msgContext.getAbilityToVega().getRouterAddress());
    }

    private Boolean determinePartitionForward(String regionCodes, Object hsn) {
        if (ObjectUtils.isEmpty((Object)hsn)) {
            log.info("\u6ca1\u6709\u4f20\u5165\u8def\u7531\u6807\u8bc6\u76f4\u63a5\u6c47\u805a\u8f6c\u53d1\uff01");
            return Boolean.FALSE;
        }
        if (!ObjectUtils.isEmpty((Object)regionCodes)) {
            List<String> regionCodeList = Arrays.asList(regionCodes.split(","));
            return regionCodeList.stream().noneMatch(str -> str.equals(String.valueOf(hsn)));
        }
        return Boolean.FALSE;
    }
}

