/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityweb.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JsonLoader;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import java.io.IOException;

public class JsonShemaValidator {
    private static final JsonSchemaFactory factory = JsonSchemaFactory.byDefault();

    public static ProcessingReport validatorSchema(String mainSchema, String instance) throws IOException, ProcessingException {
        JsonNode mainNode = JsonLoader.fromString((String)mainSchema);
        JsonNode instanceNode = JsonLoader.fromString((String)instance);
        JsonSchema schema = factory.getJsonSchema(mainNode);
        ProcessingReport processingReport = schema.validate(instanceNode);
        return processingReport;
    }

    public static ProcessingReport validateJson(JsonSchema schema, JsonNode instance) throws ProcessingException {
        return schema.validate(instance);
    }

    public static JsonNode resolveJson(String jsonStr) throws IOException {
        try {
            return JsonLoader.fromString((String)jsonStr);
        }
        catch (IOException e) {
            return JsonLoader.fromString((String)"{}");
        }
    }

    public static void main(String[] args) {
        String sch = "{\n  \"$schema\": \"http://json-schema.org/draft-04/schema#\",\n  \"type\": \"object\",\n  \"properties\": {\n    \"body\": {\n      \"type\": \"object\",\n      \"properties\": {\n        \"username\": {\n          \"type\": \"string\"\n        },\n        \"age\": {\n          \"type\": \"string\"\n        },\n        \"call\": {\n          \"type\": \"object\",\n          \"properties\": {\n            \"english\": {\n              \"type\": \"string\"\n            },\n            \"chinese\": {\n              \"type\": \"string\",\n              \"minLength\": 0,\n              \"maxLength\": 15\n            }\n          },\n          \"required\": [\n            \"english\",\n            \"chinese\"\n          ]\n        }\n      },\n      \"required\": [\n        \"call\"\n      ]\n    }\n  },\n  \"required\": [\n    \"body\"\n  ]\n}";
        String json = "{\n  \"body\": {\n    \"username\": \"haha\",\n    \"age\": \"12\",\n    \"call\": {\n      \"english\": \"12:12:12111:122222222222222222222222222222\",\n      \"chinese\": \"str12322222222222222222222222222222222222222222222222224\"\n    }\n  }\n}";
        try {
            ProcessingReport processingMessages = JsonShemaValidator.validatorSchema(sch, json);
            System.out.println(processingMessages.toString());
        }
        catch (IOException iOException) {
        }
        catch (ProcessingException processingException) {
            // empty catch block
        }
    }
}

