/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityweb.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ObjectUtil {
    private static final Logger log = LoggerFactory.getLogger(ObjectUtil.class);

    public static <T extends Serializable> Object clone(T obj) {
        Object clonedObj = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(obj);
            oos.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bais);
            clonedObj = ois.readObject();
            ois.close();
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return clonedObj;
    }
}

