/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityweb.util;

import com.ohaotian.abilitycommon.config.systemcol.SystemColMap;
import com.ohaotian.abilitycommon.constant.Constants;
import com.ohaotian.abilitycommon.enums.LogTypeEnum;
import com.ohaotian.abilitycommon.model.bo.AbilityExtColumnBO;
import com.ohaotian.abilitycommon.model.bo.AppBO;
import com.ohaotian.abilitycommon.model.bo.AppExtColumnBO;
import com.ohaotian.abilitycommon.model.bo.RegionAddrBO;
import com.ohaotian.abilitycommon.model.bo.RegionBO;
import com.ohaotian.abilitycommon.model.bo.SystemExtColumnBO;
import com.ohaotian.abilitycommon.model.bo.system.EsbAbility;
import com.ohaotian.abilitycommon.model.bo.system.MsgContext;
import com.ohaotian.abilitycommon.model.bo.system.SelfDefHeader;
import com.ohaotian.abilitycommon.model.bo.system.TlogReqHeader;
import com.ohaotian.abilitycommon.model.bo.system.TlogRspHeader;
import com.ohaotian.abilitycommon.util.DateUtil;
import com.ohaotian.abilitylog.bo.TlogInfo;
import com.ohaotian.abilitylog.util.TLogUtil;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.http.Consts;
import org.springframework.util.CollectionUtils;
import org.springframework.web.reactive.function.server.ServerRequest;

public class PrintTLogUtil {
    public static void printRequestInLog(ServerRequest request, MsgContext msgContext) {
        TlogReqHeader tlogReqHeader = msgContext.getTlogReqHeader();
        TlogInfo tlogInfo = PrintTLogUtil.buildTlogInfo(msgContext);
        tlogInfo.setLogType(LogTypeEnum.REQUEST_IN.getCode());
        tlogInfo.setSuccessFlag(Constants.AbilityBooleanType.YES);
        tlogInfo.setJoinTime(DateUtil.getCurrentDateSSSTime());
        msgContext.getTlogReqHeader().setJoinTime(tlogInfo.getJoinTime());
        if (request != null) {
            String platformIp = request.headers().host().getHostName();
            Integer platformPort = request.headers().host().getPort();
            tlogInfo.setPlatformIp(platformIp);
            tlogInfo.setPlatformPort(platformPort);
        } else {
            tlogInfo.setPlatformIp("127.0.0.1");
            tlogInfo.setPlatformPort(Integer.valueOf(8001));
        }
        if (tlogReqHeader != null) {
            if (tlogReqHeader.getReqData() != null) {
                tlogInfo.setRequestMessage(new String(tlogReqHeader.getReqData(), Consts.UTF_8));
            }
            if (tlogReqHeader.getHeadersMap() != null) {
                tlogInfo.setSendHeaderInfo(tlogReqHeader.getHeadersMap().toString());
            }
            tlogInfo.setRequestIp(tlogReqHeader.getFromIp());
        }
        TLogUtil.requestInLog((TlogInfo)tlogInfo);
    }

    public static void printRespondInLog(MsgContext msgContext) {
        TlogReqHeader tlogReqHeader = msgContext.getTlogReqHeader();
        SelfDefHeader selfDefHeader = msgContext.getSelfDefHeader();
        AppBO appBO = selfDefHeader.getApp();
        RegionBO regionBO = selfDefHeader.getRegionBO();
        EsbAbility esbAbility = msgContext.getEsbAbility();
        RegionAddrBO regionAddrBO = selfDefHeader.getRegionAddrBO();
        AppExtColumnBO appExtColumn = selfDefHeader.getAppExtColumn();
        TlogInfo tlogInfo = PrintTLogUtil.buildTlogInfo(msgContext);
        tlogInfo.setLogType(LogTypeEnum.RESPOND_IN.getCode());
        tlogInfo.setSuccessFlag(Constants.AbilityBooleanType.YES);
        if (appBO != null) {
            tlogInfo.setCosumerAppCode(appBO.getAppCode());
            tlogInfo.setCosumerAppName(appBO.getAppName());
        }
        if (appExtColumn != null) {
            String appOne = appExtColumn.getAppOne();
            tlogInfo.setCosumerAppExtOne(appOne);
            PrintTLogUtil.setExtName(tlogInfo, appOne, "1039", 1);
            String appTwo = appExtColumn.getAppTwo();
            tlogInfo.setCosumerAppExtTwo(appTwo);
            PrintTLogUtil.setExtName(tlogInfo, appTwo, "1040", 1);
            String appThree = appExtColumn.getAppThree();
            tlogInfo.setCosumerAppExtThree(appThree);
            PrintTLogUtil.setExtName(tlogInfo, appThree, "1041", 1);
            String appFour = appExtColumn.getAppFour();
            tlogInfo.setCosumerAppExtFour(appFour);
            PrintTLogUtil.setExtName(tlogInfo, appFour, "1042", 1);
            String appFive = appExtColumn.getAppFive();
            tlogInfo.setCosumerAppExtFive(appFive);
            PrintTLogUtil.setExtName(tlogInfo, appFive, "1043", 1);
        }
        tlogInfo.setSendTime(DateUtil.getCurrentDateSSSTime());
        if (regionBO != null) {
            tlogInfo.setRegionCode(regionBO.getRegionCode());
            tlogInfo.setRegionName(regionBO.getRegionName());
        }
        if (regionAddrBO != null) {
            tlogInfo.setDropIp(regionAddrBO.getIp());
            tlogInfo.setDropPort(regionAddrBO.getPort());
        }
        tlogInfo.setUrl(selfDefHeader.getUrl());
        if (esbAbility.getOutputTransProtocal().equalsIgnoreCase("RPC")) {
            tlogInfo.setSendMethod("POST");
        } else {
            tlogInfo.setSendMethod(esbAbility.getOutputTransProtocal());
        }
        if (tlogReqHeader != null) {
            if (tlogReqHeader.getReqData() != null) {
                tlogInfo.setSendMessage(new String(tlogReqHeader.getReqData(), Consts.UTF_8));
            }
            if (selfDefHeader.getSelfDefMap() != null) {
                tlogInfo.setSendHeaderInfo(selfDefHeader.getSelfDefMap().toString());
            }
        }
        TLogUtil.respondInLog((TlogInfo)tlogInfo);
    }

    public static void printRespondOutLog(MsgContext msgContext) {
        TlogRspHeader tlogRspHeader = msgContext.getTlogRspHeader();
        SelfDefHeader selfDefHeader = msgContext.getSelfDefHeader();
        AppBO appBO = selfDefHeader.getApp();
        RegionBO regionBO = selfDefHeader.getRegionBO();
        EsbAbility esbAbility = msgContext.getEsbAbility();
        RegionAddrBO regionAddrBO = selfDefHeader.getRegionAddrBO();
        AppExtColumnBO appExtColumn = selfDefHeader.getAppExtColumn();
        TlogInfo tlogInfo = PrintTLogUtil.buildTlogInfo(msgContext);
        tlogInfo.setLogType(LogTypeEnum.RESPOND_OUT.getCode());
        tlogInfo.setSuccessFlag(Constants.AbilityBooleanType.YES);
        if (appBO != null) {
            tlogInfo.setCosumerAppCode(appBO.getAppCode());
            tlogInfo.setCosumerAppName(appBO.getAppName());
        }
        if (appExtColumn != null) {
            String appOne = appExtColumn.getAppOne();
            tlogInfo.setCosumerAppExtOne(appOne);
            PrintTLogUtil.setExtName(tlogInfo, appOne, "1039", 1);
            String appTwo = appExtColumn.getAppTwo();
            tlogInfo.setCosumerAppExtTwo(appTwo);
            PrintTLogUtil.setExtName(tlogInfo, appTwo, "1040", 1);
            String appThree = appExtColumn.getAppThree();
            tlogInfo.setCosumerAppExtThree(appThree);
            PrintTLogUtil.setExtName(tlogInfo, appThree, "1041", 1);
            String appFour = appExtColumn.getAppFour();
            tlogInfo.setCosumerAppExtFour(appFour);
            PrintTLogUtil.setExtName(tlogInfo, appFour, "1042", 1);
            String appFive = appExtColumn.getAppFive();
            tlogInfo.setCosumerAppExtFive(appFive);
            PrintTLogUtil.setExtName(tlogInfo, appFive, "1043", 1);
        }
        if (regionBO != null) {
            tlogInfo.setRegionCode(regionBO.getRegionCode());
            tlogInfo.setRegionName(regionBO.getRegionName());
        }
        if (regionAddrBO != null) {
            tlogInfo.setDropIp(regionAddrBO.getIp());
            tlogInfo.setDropPort(regionAddrBO.getPort());
        }
        tlogInfo.setUrl(selfDefHeader.getUrl());
        if (esbAbility.getOutputTransProtocal().equalsIgnoreCase("RPC")) {
            tlogInfo.setSendMethod("POST");
        } else {
            tlogInfo.setSendMethod(esbAbility.getOutputTransProtocal());
        }
        tlogInfo.setReceiveTime(DateUtil.getCurrentDateSSSTime());
        if (tlogRspHeader != null) {
            if (tlogRspHeader.getRspData() != null) {
                tlogInfo.setRecieveMessage(new String(tlogRspHeader.getRspData(), Consts.UTF_8));
            }
            if (tlogRspHeader.getHeaders() != null) {
                tlogInfo.setRecieveHeaderInfo(tlogRspHeader.getHeaders().toString());
            }
        }
        TLogUtil.respondOutLog((TlogInfo)tlogInfo);
    }

    public static void printRequestOutLog(MsgContext msgContext) {
        SelfDefHeader selfDefHeader = msgContext.getSelfDefHeader();
        TlogRspHeader tlogRspHeader = msgContext.getTlogRspHeader();
        AppBO appBO = selfDefHeader.getApp();
        RegionBO regionBO = selfDefHeader.getRegionBO();
        EsbAbility esbAbility = msgContext.getEsbAbility();
        RegionAddrBO regionAddrBO = selfDefHeader.getRegionAddrBO();
        AppExtColumnBO appExtColumn = selfDefHeader.getAppExtColumn();
        TlogInfo tlogInfo = PrintTLogUtil.buildTlogInfo(msgContext);
        tlogInfo.setLogType(LogTypeEnum.REQUEST_OUT.getCode());
        tlogInfo.setSuccessFlag(Constants.AbilityBooleanType.YES);
        if (appBO != null) {
            tlogInfo.setCosumerAppCode(appBO.getAppCode());
            tlogInfo.setCosumerAppName(appBO.getAppName());
        }
        if (appExtColumn != null) {
            String appOne = appExtColumn.getAppOne();
            tlogInfo.setCosumerAppExtOne(appOne);
            PrintTLogUtil.setExtName(tlogInfo, appOne, "1039", 1);
            String appTwo = appExtColumn.getAppTwo();
            tlogInfo.setCosumerAppExtTwo(appTwo);
            PrintTLogUtil.setExtName(tlogInfo, appTwo, "1040", 1);
            String appThree = appExtColumn.getAppThree();
            tlogInfo.setCosumerAppExtThree(appThree);
            PrintTLogUtil.setExtName(tlogInfo, appThree, "1041", 1);
            String appFour = appExtColumn.getAppFour();
            tlogInfo.setCosumerAppExtFour(appFour);
            PrintTLogUtil.setExtName(tlogInfo, appFour, "1042", 1);
            String appFive = appExtColumn.getAppFive();
            tlogInfo.setCosumerAppExtFive(appFive);
            PrintTLogUtil.setExtName(tlogInfo, appFive, "1043", 1);
        }
        tlogInfo.setRespondTime(DateUtil.getCurrentDateSSSTime());
        if (regionBO != null) {
            tlogInfo.setRegionCode(regionBO.getRegionCode());
            tlogInfo.setRegionName(regionBO.getRegionName());
        }
        if (regionAddrBO != null) {
            tlogInfo.setDropIp(regionAddrBO.getIp());
            tlogInfo.setDropPort(regionAddrBO.getPort());
        }
        tlogInfo.setUrl(selfDefHeader.getUrl());
        if (esbAbility.getOutputTransProtocal().equalsIgnoreCase("RPC")) {
            tlogInfo.setSendMethod("POST");
        } else {
            tlogInfo.setSendMethod(esbAbility.getOutputTransProtocal());
        }
        if (tlogRspHeader != null) {
            if (tlogRspHeader.getRspData() != null) {
                tlogInfo.setRespondMessage(new String(tlogRspHeader.getRspData(), Consts.UTF_8));
            }
            if (tlogRspHeader.getHeaders() != null) {
                tlogInfo.setRespondHeaderInfo(tlogRspHeader.getHeaders().toString());
            }
        }
        TLogUtil.requestOutLog((TlogInfo)tlogInfo);
    }

    public static void printErrorRequestOutLog(MsgContext msgContext, Object msg) {
        SelfDefHeader selfDefHeader = msgContext.getSelfDefHeader();
        TlogRspHeader tlogRspHeader = msgContext.getTlogRspHeader();
        AppBO appBO = selfDefHeader.getApp();
        RegionBO regionBO = selfDefHeader.getRegionBO();
        EsbAbility esbAbility = msgContext.getEsbAbility();
        RegionAddrBO regionAddrBO = selfDefHeader.getRegionAddrBO();
        AppExtColumnBO appExtColumn = selfDefHeader.getAppExtColumn();
        TlogInfo tlogInfo = PrintTLogUtil.buildTlogInfo(msgContext);
        tlogInfo.setLogType(LogTypeEnum.REQUEST_OUT.getCode());
        tlogInfo.setSuccessFlag(Constants.AbilityBooleanType.NO);
        if (appBO != null) {
            tlogInfo.setCosumerAppCode(appBO.getAppCode());
            tlogInfo.setCosumerAppName(appBO.getAppName());
            if (appExtColumn != null) {
                String appOne = appExtColumn.getAppOne();
                tlogInfo.setCosumerAppExtOne(appOne);
                PrintTLogUtil.setExtName(tlogInfo, appOne, "1039", 1);
                String appTwo = appExtColumn.getAppTwo();
                tlogInfo.setCosumerAppExtTwo(appTwo);
                PrintTLogUtil.setExtName(tlogInfo, appTwo, "1040", 1);
                String appThree = appExtColumn.getAppThree();
                tlogInfo.setCosumerAppExtThree(appThree);
                PrintTLogUtil.setExtName(tlogInfo, appThree, "1041", 1);
                String appFour = appExtColumn.getAppFour();
                tlogInfo.setCosumerAppExtFour(appFour);
                PrintTLogUtil.setExtName(tlogInfo, appFour, "1042", 1);
                String appFive = appExtColumn.getAppFive();
                tlogInfo.setCosumerAppExtFive(appFive);
                PrintTLogUtil.setExtName(tlogInfo, appFive, "1043", 1);
            }
        }
        tlogInfo.setRespondTime(DateUtil.getCurrentDateSSSTime());
        if (regionAddrBO != null) {
            tlogInfo.setRegionCode(regionBO.getRegionCode());
            tlogInfo.setRegionName(regionBO.getRegionName());
        }
        if (regionAddrBO != null) {
            tlogInfo.setDropIp(regionAddrBO.getIp());
            tlogInfo.setDropPort(regionAddrBO.getPort());
        }
        tlogInfo.setUrl(selfDefHeader.getUrl());
        if (esbAbility.getOutputTransProtocal().equalsIgnoreCase("RPC")) {
            tlogInfo.setSendMethod("POST");
        } else {
            tlogInfo.setSendMethod(esbAbility.getOutputTransProtocal());
        }
        if (tlogRspHeader != null) {
            if (tlogRspHeader.getRspData() != null) {
                tlogInfo.setRespondMessage(new String(tlogRspHeader.getRspData(), Consts.UTF_8));
            }
            if (tlogRspHeader.getHeaders() != null) {
                tlogInfo.setRespondHeaderInfo(tlogRspHeader.getHeaders().toString());
            }
        }
        tlogInfo.setErrorMsg(msg.toString());
        TLogUtil.requestOutLog((TlogInfo)tlogInfo);
    }

    public static TlogInfo buildTlogInfo(MsgContext msgContext) {
        SelfDefHeader selfDefHeader = msgContext.getSelfDefHeader();
        EsbAbility esbAbility = msgContext.getEsbAbility();
        AbilityExtColumnBO abilityExtColumn = esbAbility.getAbilityExtColumn();
        AppBO appBO = esbAbility.getProviderApp();
        AppExtColumnBO appExtColumnBO = esbAbility.getProviderAppColumn();
        TlogInfo tlogInfo = new TlogInfo();
        tlogInfo.setTraceId(selfDefHeader.getSysTransId());
        tlogInfo.setParentTraceId(selfDefHeader.getParentTransId());
        tlogInfo.setAbilityEname(esbAbility.getAbilityEname());
        tlogInfo.setAbilityName(esbAbility.getAbilityName());
        tlogInfo.setAbilityVersion(esbAbility.getAbilityVersion());
        tlogInfo.setBusinessCenterCode(msgContext.getBusinessCenterCode());
        tlogInfo.setClusterId(selfDefHeader.getClusterId());
        tlogInfo.setRequestMethod("POST");
        tlogInfo.setInputProtocal(msgContext.getInputProtocal());
        tlogInfo.setOutputProtocal(esbAbility.getOutputProtocal());
        tlogInfo.setProviderAppCode(appBO.getAppCode());
        tlogInfo.setProviderAppName(appBO.getAppName());
        String appOne = appExtColumnBO.getAppOne();
        tlogInfo.setProviderAppExtOne(appOne);
        PrintTLogUtil.setExtName(tlogInfo, appOne, "1039", 0);
        String appTwo = appExtColumnBO.getAppTwo();
        tlogInfo.setProviderAppExtTwo(appTwo);
        PrintTLogUtil.setExtName(tlogInfo, appTwo, "1040", 0);
        String appThree = appExtColumnBO.getAppThree();
        tlogInfo.setProviderAppExtThree(appThree);
        PrintTLogUtil.setExtName(tlogInfo, appThree, "1041", 0);
        String appFour = appExtColumnBO.getAppFour();
        tlogInfo.setProviderAppExtFour(appFour);
        PrintTLogUtil.setExtName(tlogInfo, appFour, "1042", 0);
        String appFive = appExtColumnBO.getAppFive();
        tlogInfo.setProviderAppExtFive(appFive);
        PrintTLogUtil.setExtName(tlogInfo, appFive, "1043", 0);
        String extOne = abilityExtColumn.getExtOne();
        tlogInfo.setExtOne(extOne);
        PrintTLogUtil.setExtName(tlogInfo, extOne, "1025", 0);
        String extTwo = abilityExtColumn.getExtTwo();
        tlogInfo.setExtTwo(extTwo);
        PrintTLogUtil.setExtName(tlogInfo, extTwo, "1026", 0);
        String extThree = abilityExtColumn.getExtThree();
        tlogInfo.setExtThree(extThree);
        PrintTLogUtil.setExtName(tlogInfo, extThree, "1027", 0);
        String extFour = abilityExtColumn.getExtFour();
        tlogInfo.setExtFour(extFour);
        PrintTLogUtil.setExtName(tlogInfo, extFour, "1028", 0);
        String extFive = abilityExtColumn.getExtFive();
        tlogInfo.setExtFive(extFive);
        PrintTLogUtil.setExtName(tlogInfo, extFive, "1029", 0);
        String extSix = abilityExtColumn.getExtSix();
        tlogInfo.setExtSix(extSix);
        PrintTLogUtil.setExtName(tlogInfo, extSix, "1030", 0);
        String extSeven = abilityExtColumn.getExtSeven();
        tlogInfo.setExtSeven(extSeven);
        PrintTLogUtil.setExtName(tlogInfo, extSeven, "1031", 0);
        String extEight = abilityExtColumn.getExtEight();
        tlogInfo.setExtEight(extEight);
        PrintTLogUtil.setExtName(tlogInfo, extEight, "1032", 0);
        String extNine = abilityExtColumn.getExtNine();
        tlogInfo.setExtNine(extNine);
        PrintTLogUtil.setExtName(tlogInfo, extNine, "1033", 0);
        String extTen = abilityExtColumn.getExtTen();
        tlogInfo.setExtTen(extTen);
        PrintTLogUtil.setExtName(tlogInfo, extTen, "1034", 0);
        return tlogInfo;
    }

    private static void setExtName(TlogInfo tlogInfo, String extValue, String flag, int type) {
        List extColList;
        if (extValue != null && !CollectionUtils.isEmpty((Collection)(extColList = SystemColMap.getSystemColList((String)flag)))) {
            String[] splitStr = extValue.split(",");
            if (splitStr.length > 1) {
                StringBuilder sb = new StringBuilder();
                for (String str : splitStr) {
                    List filterList = extColList.stream().filter(po -> po.getColValue().equals(str)).collect(Collectors.toList());
                    if (CollectionUtils.isEmpty(filterList)) continue;
                    sb.append(((SystemExtColumnBO)filterList.get(0)).getColLabel()).append(",");
                }
                String str = sb.toString();
                if (str.length() > 0) {
                    tlogInfo.setExtName(flag, str.substring(0, str.length() - 1), type);
                }
            } else {
                List filterList = extColList.stream().filter(po -> po.getColValue().equals(extValue)).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(filterList)) {
                    tlogInfo.setExtName(flag, ((SystemExtColumnBO)filterList.get(0)).getColLabel(), type);
                }
            }
        }
    }
}

