/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.common.util;

import com.ohaotian.plugin.common.util.FSTSerializer;
import com.ohaotian.plugin.common.util.Serializer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializationUtils {
    private static final Logger log = LoggerFactory.getLogger(SerializationUtils.class);
    private static final Serializer G_SERIALIZER = new FSTSerializer();

    public static byte[] serialize(Object obj) throws IOException {
        return obj == null ? null : G_SERIALIZER.serialize(obj);
    }

    public static byte[] serializeWithoutException(Object obj) {
        try {
            return SerializationUtils.serialize(obj);
        }
        catch (IOException var2) {
            throw new RuntimeException();
        }
    }

    public static byte[] serializeSlightly(Object obj) {
        try {
            return SerializationUtils.serialize(obj);
        }
        catch (IOException var2) {
            log.error(var2.getMessage(), (Throwable)var2);
            throw new RuntimeException(var2.getMessage());
        }
    }

    public static Object deserialize(byte[] bytes) throws IOException {
        return bytes != null && bytes.length != 0 ? G_SERIALIZER.deserialize(bytes) : null;
    }

    public static Object deserializeSlightly(byte[] bytes) {
        if (bytes != null && bytes.length != 0) {
            try {
                return G_SERIALIZER.deserialize(bytes);
            }
            catch (IOException var2) {
                log.error(var2.getMessage(), (Throwable)var2);
                throw new RuntimeException(var2.getMessage());
            }
        }
        return null;
    }

    public static Object deserialize(Object obj) throws IOException {
        return obj == null ? null : G_SERIALIZER.deserialize(SerializationUtils.toByteArray(obj));
    }

    public static byte[] toByteArray(Object obj) {
        byte[] bytes = null;
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
             ObjectOutputStream oos = new ObjectOutputStream(bos);){
            oos.writeObject(obj);
            oos.flush();
            bytes = bos.toByteArray();
        }
        catch (IOException var4) {
            var4.printStackTrace();
        }
        return bytes;
    }
}

