--/**
--* -1: 异常
--* 10000: 流控通过
--* 10001: 能力限量超出
--* 10002: 能力日限量超出
--* 10003: 能力限速超出
--* 10004: 订购限量超出
--* 10005: 订购日限量超出
--* 10006: 订购限速超出
--*/

-- 能力限量
local ability_capacity_key = KEYS[1]  --能力限量KEY
local ability_capacity = tonumber(ARGV[1]) --能力限量大小

-- 能力日限量
local ability_daily_capacity_key = KEYS[2]  --能力日限量KEY
local ability_daily_capacity = tonumber(ARGV[2]) --能力日限量大小

--能力限速
local ability_rate_key = KEYS[3]  --能力限速KEY
local ability_rate = tonumber(ARGV[3]) --能力限流速率大小


-- 订购限量
local subscribe_capacity_key = KEYS[4]  --订购限量KEY
local subscribe_capacity = tonumber(ARGV[4]) --订购限量大小

-- 订购日限量
local subscribe_daily_capacity_key = KEYS[5]  --订购日限量KEY
local subscribe_daily_capacity = tonumber(ARGV[5]) --订购日限量大小

-- 订购限速
local subscribe_rate_key = KEYS[6]  --订购限速KEY
local subscribe_rate = tonumber(ARGV[6]) --订购限流速率大小

-- 日限量过期时间
local dailyExpireTime = ARGV[7]


-- 限流判断开始
-- 判断能力限量
if ability_capacity > 0 then
    local ability_current_capacity = tonumber(redis.call('get', ability_capacity_key) or "0") --当前能力使用量
    if ability_current_capacity + 1 > ability_capacity then
        return 10001
    end
end

-- 判断能力日限量
if ability_daily_capacity > 0 then
    local ability_daily_current_capacity = tonumber(redis.call('get', ability_daily_capacity_key) or "0") --能力日限量大小
    if ability_daily_current_capacity + 1 > ability_daily_capacity then
        return 10002
    end
end

-- 判断能力限速
if ability_rate > 0 then
    local ability_current_rate = tonumber(redis.call('get', ability_rate_key) or "0") --当前速率
    if ability_current_rate + 1 > ability_rate then
        return 10003
    end
end


-- 判断订购限量
if subscribe_capacity > 0 then
    local current_capacity = tonumber(redis.call('get', subscribe_capacity_key) or "0") --当前订购使用量
    if current_capacity + 1 > subscribe_capacity then
        return 10004
    end
end

-- 判断订购日限量
if subscribe_daily_capacity > 0 then
    local daily_current_capacity = tonumber(redis.call('get', subscribe_daily_capacity_key) or "0") --当前订购日使用量
    if daily_current_capacity + 1 > subscribe_daily_capacity then
        return 10005
    end
end

-- 判断订购限速
if subscribe_rate > 0 then
    local current_rate = tonumber(redis.call('get', subscribe_rate_key) or "0") --当前速率
    if current_rate + 1 > subscribe_rate then
        return 10006
    end
end
-- 限流判断结束


-- 限流通过后修改redis数据
-- 能力调用量加1
if ability_capacity > 0 then
    redis.call("INCR", ability_capacity_key)
end

-- 能力日调用量加1
if ability_daily_capacity > 0 then
    redis.call("INCR", ability_daily_capacity_key)
    redis.call("EXPIRE", ability_daily_capacity_key, dailyExpireTime)
end

-- 能力速率加1
if ability_rate > 0 then
    redis.call("INCR", ability_rate_key)
    redis.call("EXPIRE", ability_rate_key,"1")
end

-- 能力订购量加1
if subscribe_capacity > 0 then
    redis.call("INCR", subscribe_capacity_key)
end

-- 判断订购日限量
if subscribe_daily_capacity > 0 then
    redis.call("INCR", subscribe_daily_capacity_key)
    redis.call("EXPIRE", subscribe_daily_capacity_key, dailyExpireTime)
end

-- 能力订购速率加1，并设置2秒过期
if subscribe_rate > 0 then
    redis.call("INCR", subscribe_rate_key)
    redis.call("EXPIRE", subscribe_rate_key, "1")

end

-- 流控通过返回
return 10000