/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.config;

import com.ohaotian.authority.config.bo.ConfigInfoBO;
import com.ohaotian.authority.config.bo.SelectConfigInfoReqBO;
import com.ohaotian.authority.config.bo.SelectConfigInfoRspBO;
import com.ohaotian.authority.config.bo.SelectInfoByConfigReqBO;
import com.ohaotian.authority.config.bo.SelectInfoByConfigRspBO;
import com.ohaotian.authority.config.bo.SelectUserInfoByConfigCodeReqBO;
import com.ohaotian.authority.config.bo.SelectUserInfoByConfigCodeRspBO;
import com.ohaotian.authority.config.service.SelectConfigInfoService;
import com.ohaotian.authority.dao.AuthDistributeMapper;
import com.ohaotian.authority.dao.ConfigInfoMapper;
import com.ohaotian.authority.dao.OrganizationMapper;
import com.ohaotian.authority.dao.UserMapper;
import com.ohaotian.authority.dao.po.ConfigInfoPO;
import com.ohaotian.authority.dao.po.OrganisationPO;
import com.ohaotian.authority.dao.po.UserPO;
import com.ohaotian.authority.user.bo.UserInfo;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SelectConfigInfoServiceImpl
implements SelectConfigInfoService {
    @Autowired
    ConfigInfoMapper configInfoMapper;
    @Autowired
    UserMapper userMapper;
    @Autowired
    AuthDistributeMapper authDistributeMapper;
    @Autowired
    OrganizationMapper organizationMapper;

    public SelectInfoByConfigRspBO selectConfigInfoByShopId(SelectInfoByConfigReqBO selectConfigInfoReqBO) {
        if (selectConfigInfoReqBO == null || selectConfigInfoReqBO.getOrgId() == null) {
            throw new ZTBusinessException("\u95e8\u5e97\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SelectInfoByConfigRspBO selectInfoByConfigRspBO = new SelectInfoByConfigRspBO();
        ArrayList<UserInfo> userInfoList = new ArrayList<UserInfo>();
        List<UserInfo> userList = this.userMapper.selectSearchByOrgId(selectConfigInfoReqBO.getOrgId());
        ArrayList<Long> orgIds = new ArrayList<Long>();
        List<OrganisationPO> organisationPOs = this.organizationMapper.selectAllOrgByPId(selectConfigInfoReqBO.getOrgId());
        for (OrganisationPO organisationPO : organisationPOs) {
            orgIds.add(organisationPO.getOrgId());
        }
        orgIds.add(selectConfigInfoReqBO.getOrgId());
        List<UserInfo> userConfigList = this.configInfoMapper.selectInfoByShopId(orgIds, selectConfigInfoReqBO.getConfigId());
        for (UserInfo userInfoConfig : userList) {
            UserInfo userInfo = new UserInfo();
            userInfo.setUserId(userInfoConfig.getUserId());
            userInfo.setLoginName(userInfoConfig.getLoginName());
            userInfo.setName(userInfoConfig.getName());
            userInfo.setTypeName(userInfoConfig.getTypeName());
            for (UserInfo userConfig : userConfigList) {
                if (userInfoConfig.getUserId().longValue() == userConfig.getUserId().longValue()) {
                    userInfo.setStatus(Integer.valueOf(1));
                    break;
                }
                userInfo.setStatus(Integer.valueOf(0));
            }
            userInfoList.add(userInfo);
        }
        selectInfoByConfigRspBO.setConfigUserInfo(userInfoList);
        return selectInfoByConfigRspBO;
    }

    public RspPage<ConfigInfoBO> selectConfigInfo(SelectConfigInfoReqBO selectConfigInfoReqBO) {
        Page page = new Page(selectConfigInfoReqBO.getPageNo(), selectConfigInfoReqBO.getPageSize());
        ArrayList<ConfigInfoBO> configInfoBOList = new ArrayList<ConfigInfoBO>();
        List<ConfigInfoPO> configInfoList = this.configInfoMapper.selectConfigInfo(page);
        for (ConfigInfoPO configInfoPO : configInfoList) {
            ConfigInfoBO configInfoBO = new ConfigInfoBO();
            try {
                BeanUtils.copyProperties((Object)configInfoBO, (Object)configInfoPO);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            configInfoBOList.add(configInfoBO);
        }
        RspPage rspPage = new RspPage();
        rspPage.setPageNo(selectConfigInfoReqBO.getPageNo());
        rspPage.setRecordsTotal(page.getTotalCount());
        rspPage.setRows(configInfoBOList);
        rspPage.setTotal(page.getTotalPages());
        return rspPage;
    }

    public SelectConfigInfoRspBO selectConfigInfoById(SelectConfigInfoReqBO selectConfigInfoReqBO) {
        ConfigInfoPO configInfo = this.configInfoMapper.selectConfigInfoById(selectConfigInfoReqBO.getConfigId());
        if (configInfo != null) {
            SelectConfigInfoRspBO selectConfigInfoRspBO = new SelectConfigInfoRspBO();
            selectConfigInfoRspBO.setConfigCode(configInfo.getConfigCode());
            selectConfigInfoRspBO.setConfigName(configInfo.getConfigName());
            selectConfigInfoRspBO.setStatus(configInfo.getStatus());
            selectConfigInfoRspBO.setRemark(configInfo.getRemark());
            return selectConfigInfoRspBO;
        }
        return null;
    }

    public RspPage<ConfigInfoBO> selectConfigInfoByName(SelectConfigInfoReqBO selectConfigInfoReqBO) {
        Page page = new Page(selectConfigInfoReqBO.getPageNo(), selectConfigInfoReqBO.getPageSize());
        ArrayList<ConfigInfoBO> configInfoBOList = new ArrayList<ConfigInfoBO>();
        List<ConfigInfoPO> configInfo = this.configInfoMapper.selectConfigInfoByName(page, selectConfigInfoReqBO.getConfigName());
        for (ConfigInfoPO configInfoPO : configInfo) {
            ConfigInfoBO configInfoBO = new ConfigInfoBO();
            configInfoBO.setConfigCode(configInfoPO.getConfigCode());
            configInfoBO.setConfigName(configInfoPO.getConfigName());
            configInfoBO.setStatus(configInfoPO.getStatus());
            configInfoBO.setRemark(configInfoPO.getRemark());
            configInfoBOList.add(configInfoBO);
        }
        RspPage rspPage = new RspPage();
        rspPage.setPageNo(selectConfigInfoReqBO.getPageNo());
        rspPage.setRecordsTotal(page.getTotalCount());
        rspPage.setRows(configInfoBOList);
        rspPage.setTotal(page.getTotalPages());
        return rspPage;
    }

    public SelectUserInfoByConfigCodeRspBO selectConfigInfoByCode(SelectUserInfoByConfigCodeReqBO selectUserInfoByConfigCodeReqBO) {
        SelectUserInfoByConfigCodeRspBO selectUserInfoByConfigCodeRspBO = new SelectUserInfoByConfigCodeRspBO();
        ArrayList<Long> orgIds = new ArrayList<Long>();
        try {
            ConfigInfoPO configInfoPO = this.configInfoMapper.selectConfigInfoByCode(selectUserInfoByConfigCodeReqBO.getConfigCode());
            if (configInfoPO == null || configInfoPO.getStatus() == 0) {
                throw new ZTBusinessException("\u914d\u7f6e\u9879\u4e0d\u5b58\u5728\u6216\u672a\u542f\u7528\uff01");
            }
            if (selectUserInfoByConfigCodeReqBO.getOrgId() != null) {
                List<OrganisationPO> parentOrgIdIds = this.organizationMapper.selectOrgByPId(selectUserInfoByConfigCodeReqBO.getOrgId());
                for (OrganisationPO parentOrgIdId : parentOrgIdIds) {
                    orgIds.add(parentOrgIdId.getOrgId());
                }
                orgIds.add(selectUserInfoByConfigCodeReqBO.getOrgId());
            } else if (CollectionUtils.isNotEmpty((Collection)selectUserInfoByConfigCodeReqBO.getShopId())) {
                selectUserInfoByConfigCodeReqBO.getShopId().forEach(shopId -> orgIds.add((Long)shopId));
            }
            List<UserPO> userPOs = this.configInfoMapper.selectUserInfoByConfigId(configInfoPO.getConfigId(), orgIds);
            ArrayList<UserInfo> userInfos = new ArrayList<UserInfo>();
            for (UserPO userPO : userPOs) {
                UserInfo userInfo = new UserInfo();
                BeanUtils.copyProperties((Object)userInfo, (Object)userPO);
                userInfos.add(userInfo);
            }
            selectUserInfoByConfigCodeRspBO.setUserInfo(userInfos);
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u7cfb\u7edf\u51fa\u9519\uff01" + e.getMessage());
        }
        return selectUserInfoByConfigCodeRspBO;
    }
}

