/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.manager;

import com.ohaotian.authority.busi.impl.organisation.OrgSearchServiceImpl;
import com.ohaotian.authority.dao.OrganizationMapper;
import com.ohaotian.authority.dao.UserMapper;
import com.ohaotian.authority.dao.po.OrganisationPO;
import com.ohaotian.authority.manager.bo.ManagerSearchReqBO;
import com.ohaotian.authority.manager.service.ManagerSearchService;
import com.ohaotian.authority.organisation.bo.OrganisationBO;
import com.ohaotian.authority.organisation.service.SelectOrgTreeNameService;
import com.ohaotian.authority.user.bo.OrgUser;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.ohaotian.plugin.db.Page;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ManagerSearchServiceImpl
implements ManagerSearchService {
    private static final Logger logger = LoggerFactory.getLogger(OrgSearchServiceImpl.class);
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private OrganizationMapper organizationMapper;
    @Autowired
    private SelectOrgTreeNameService selectOrgTreeNameService;

    @Transactional
    public RspPage<OrgUser> selectManagerSearch(ManagerSearchReqBO managerSearchReqBO) {
        logger.debug("[\u5165\u53c2managerSearchReqBO]={}", (Object)managerSearchReqBO);
        Page page = new Page(managerSearchReqBO.getPageNo(), managerSearchReqBO.getPageSize());
        List<OrgUser> orgUsers = this.userMapper.queryManager(managerSearchReqBO, (Page<Map<String, Object>>)page);
        orgUsers.forEach(orgUser -> {
            String orgTreeName;
            OrganisationBO organisationBO;
            OrganisationPO organisationPO = this.organizationMapper.selectOrganisationByOrgId(orgUser.getmOrgId());
            if (organisationPO != null) {
                organisationBO = null;
                if (organisationPO != null) {
                    organisationBO = (OrganisationBO)BeanMapper.map((Object)organisationPO, OrganisationBO.class);
                }
                orgTreeName = this.selectOrgTreeNameService.selectOrgTreeName(organisationBO);
                orgUser.setmOrgName(orgTreeName);
            }
            if ((organisationPO = this.organizationMapper.selectOrganisationByOrgId(orgUser.getOrgId())) != null) {
                organisationBO = (OrganisationBO)BeanMapper.map((Object)organisationPO, OrganisationBO.class);
                orgTreeName = this.selectOrgTreeNameService.selectOrgTreeName(organisationBO);
                orgUser.setOrgName(orgTreeName);
            }
        });
        RspPage result = new RspPage();
        result.setRows(orgUsers);
        result.setPageNo(managerSearchReqBO.getPageNo());
        result.setRecordsTotal(page.getTotalCount());
        result.setTotal(page.getTotalPages());
        return result;
    }
}

