/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.organisation;

import com.ohaotian.authority.dao.OrganizationMapper;
import com.ohaotian.authority.dao.po.OrganisationPO;
import com.ohaotian.authority.organisation.bo.OrganisationBO;
import com.ohaotian.authority.organisation.service.CreateOrganisationService;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.HanyuPinyinHelper;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CreateOrganisationServiceImpl
implements CreateOrganisationService {
    private static final Logger logger = LoggerFactory.getLogger(CreateOrganisationServiceImpl.class);
    @Autowired
    private OrganizationMapper organizationMapper;

    @Transactional(rollbackFor={Exception.class})
    public Long createOrganisation(OrganisationBO organisationBO) {
        Long existOrgCode;
        OrganisationPO dbPOrganisationPO;
        if (organisationBO == null) {
            throw new ZTBusinessException("\u7ec4\u7ec7\u673a\u6784\u4e3a\u7a7a");
        }
        logger.debug("[\u5165\u53c2organisationBO]={}", (Object)organisationBO);
        organisationBO.setCreatUserId(organisationBO.getCreateUserId());
        Integer deep = 0;
        String orgTreePath = "";
        if (organisationBO.getDeep() == null) {
            Long parentId = organisationBO.getParentId();
            dbPOrganisationPO = this.organizationMapper.selectOrganisationByOrgId(parentId);
            deep = dbPOrganisationPO.getDeep();
        }
        organisationBO.setExtJson(organisationBO.mapToJsaon());
        OrganisationPO organisationPO = new OrganisationPO();
        if (organisationBO != null) {
            BeanUtils.copyProperties((Object)organisationBO, (Object)organisationPO);
        }
        organisationPO.setDeep(deep + 1);
        organisationPO.setStatus(0);
        String orgCode = organisationPO.getAutoCode();
        if (StringUtils.isBlank((CharSequence)orgCode)) {
            orgCode = HanyuPinyinHelper.getPinyinString((String)organisationPO.getTitle()) + "::" + organisationPO.getTenantId();
        }
        if ((existOrgCode = this.organizationMapper.isExistOrgCode(organisationPO.getTenantId(), orgCode)) > 0L) {
            throw new ZTBusinessException("\u7ec4\u7ec7\u673a\u6784\u7f16\u7801\u4e0d\u80fd\u91cd\u590d");
        }
        this.organizationMapper.insertOrganisation(organisationPO);
        Long orgId = organisationPO.getOrgId();
        if (StringUtils.isBlank((CharSequence)orgTreePath)) {
            dbPOrganisationPO = this.organizationMapper.selectOrganisationByOrgId(organisationBO.getParentId());
            orgTreePath = dbPOrganisationPO.getOrgTreePath();
        }
        String newOrgTreePath = orgTreePath + orgId + "-";
        OrganisationPO newOrganisationPO = new OrganisationPO();
        newOrganisationPO.setOrgTreePath(newOrgTreePath);
        newOrganisationPO.setOrgId(orgId);
        this.organizationMapper.updateOrganisation(newOrganisationPO);
        logger.debug("createOrganisation() \u521b\u5efa\u7ec4\u7ec7\u673a\u6784\u6210\u529f");
        return organisationPO.getOrgId();
    }
}

