/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.organisation;

import com.ohaotian.authority.constant.Constants;
import com.ohaotian.authority.dao.OrganizationMapper;
import com.ohaotian.authority.dao.TenantMapper;
import com.ohaotian.authority.dao.po.OrganisationPO;
import com.ohaotian.authority.dic.bo.SelectDicBypDicValReqBO;
import com.ohaotian.authority.dic.bo.SelectDicBypDicValRspBO;
import com.ohaotian.authority.dic.service.SelectDicBypDicValBusiService;
import com.ohaotian.authority.organisation.bo.OrgSearchPageReqBO;
import com.ohaotian.authority.organisation.bo.OrgSearchPageRspBO;
import com.ohaotian.authority.organisation.service.OrgSearchService;
import com.ohaotian.authority.tenant.bo.TenantRspBO;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.db.Page;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrgSearchServiceImpl
implements OrgSearchService {
    private static final Logger logger = LoggerFactory.getLogger(OrgSearchServiceImpl.class);
    @Autowired
    private OrganizationMapper organizationMapper;
    @Autowired
    private SelectDicBypDicValBusiService selectDicBypDicValBusiService;
    @Autowired
    private TenantMapper tenantMapper;

    public RspPage<OrgSearchPageRspBO> selectSearchOrg(OrgSearchPageReqBO orgSearchPageReqBO) {
        logger.debug("\u5f00\u59cb\u8c03\u7528selectSearchOrg\u65b9\u6cd5[\u5165\u53c2orgSearchPageReqBO]={}", (Object)orgSearchPageReqBO);
        Page page = new Page(orgSearchPageReqBO.getPageNo(), orgSearchPageReqBO.getPageSize());
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("title", orgSearchPageReqBO.getTitle());
        map.put("autoCode", orgSearchPageReqBO.getAutoCode());
        map.put("status", orgSearchPageReqBO.getStatus());
        map.put("type", orgSearchPageReqBO.getType());
        map.put("isvirtual", orgSearchPageReqBO.getIsvirtual());
        map.put("orgIdReq", orgSearchPageReqBO.getOrgIdReq());
        List<OrganisationPO> organisationPOList = this.organizationMapper.selectSearchOrg(map, (Page<Map<String, Object>>)page);
        SelectDicBypDicValReqBO dicBypDicValReqBO = new SelectDicBypDicValReqBO();
        dicBypDicValReqBO.setpDicVal(Constants.DICVAL_ORG_TYPE);
        SelectDicBypDicValRspBO selectDicBypDicValRspBO = this.selectDicBypDicValBusiService.selectDicBypDicVal(dicBypDicValReqBO);
        List organisationBOList = organisationPOList.stream().map(e -> {
            TenantRspBO tenantRspBO;
            OrgSearchPageRspBO orgSearchPageRspBO = new OrgSearchPageRspBO();
            orgSearchPageRspBO.setOrganisationId(e.getOrgId());
            BeanUtils.copyProperties((Object)e, (Object)orgSearchPageRspBO);
            Map dicMap = selectDicBypDicValRspBO.getDicMap();
            if (dicMap != null) {
                orgSearchPageRspBO.setTypeName((String)dicMap.get(e.getType()));
            }
            if ((tenantRspBO = this.tenantMapper.selectTenantById(e.getTenantId())) != null) {
                orgSearchPageRspBO.setTenantName(tenantRspBO.getTenantName());
            }
            return orgSearchPageRspBO;
        }).collect(Collectors.toList());
        RspPage rsp = new RspPage();
        rsp.setPageNo(orgSearchPageReqBO.getPageNo());
        rsp.setTotal(page.getTotalPages());
        rsp.setRecordsTotal(page.getTotalCount());
        rsp.setRows(organisationBOList);
        logger.debug("\u8c03\u7528selectSearchOrg\u65b9\u6cd5\u7ed3\u675f[\u51fa\u53c2rsp]={}", (Object)rsp);
        return rsp;
    }
}

