/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.organisation;

import com.ohaotian.authority.constant.Constants;
import com.ohaotian.authority.dao.OrganizationMapper;
import com.ohaotian.authority.dao.TenantMapper;
import com.ohaotian.authority.dao.po.OrganisationPO;
import com.ohaotian.authority.dic.bo.SelectDicBypDicValReqBO;
import com.ohaotian.authority.dic.bo.SelectDicBypDicValRspBO;
import com.ohaotian.authority.dic.service.SelectDicBypDicValBusiService;
import com.ohaotian.authority.organisation.bo.OrganisationIdReqBO;
import com.ohaotian.authority.organisation.bo.RspOrganisationBO;
import com.ohaotian.authority.organisation.service.SelectOrganisationByOrgIdService;
import com.ohaotian.authority.tenant.bo.TenantRspBO;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SelectOrganisationByOrgIdServiceImpl
implements SelectOrganisationByOrgIdService {
    private static final Logger logger = LoggerFactory.getLogger(SelectOrganisationByOrgIdServiceImpl.class);
    @Autowired
    private OrganizationMapper organizationMapper;
    @Autowired
    private SelectDicBypDicValBusiService selectDicBypDicValBusiService;
    @Autowired
    private TenantMapper tenantMapper;

    public RspOrganisationBO selectOrganisationByOrgId(OrganisationIdReqBO organisationBO) {
        logger.debug("[\u5165\u53c2organisationBO]={}", (Object)organisationBO);
        RspOrganisationBO rspOrganisationBO = new RspOrganisationBO();
        OrganisationPO organisationPO = this.organizationMapper.selectOrganisationByOrgId(organisationBO.getOrganisationId());
        if (organisationPO != null) {
            Map map;
            BeanUtils.copyProperties((Object)organisationPO, (Object)rspOrganisationBO);
            SelectDicBypDicValReqBO dicBypDicValReqBO = new SelectDicBypDicValReqBO();
            dicBypDicValReqBO.setpDicVal(Constants.DICVAL_ORG_TYPE);
            SelectDicBypDicValRspBO selectDicBypDicValRspBO = this.selectDicBypDicValBusiService.selectDicBypDicVal(dicBypDicValReqBO);
            Map dicMap = selectDicBypDicValRspBO.getDicMap();
            if (dicMap != null) {
                rspOrganisationBO.setTypeName((String)dicMap.get(organisationPO.getType()));
            }
            if ((map = organisationPO.jsonToMap()) != null) {
                rspOrganisationBO.setTel((String)map.get("tel"));
                rspOrganisationBO.setEmail((String)map.get("email"));
                rspOrganisationBO.setFax((String)map.get("fax"));
                rspOrganisationBO.setAddress((String)map.get("address"));
                rspOrganisationBO.setRemark((String)map.get("remark"));
                rspOrganisationBO.setLinkman((String)map.get("linkman"));
                BeanUtils.copyProperties((Object)map, (Object)rspOrganisationBO);
            }
        }
        rspOrganisationBO.setOrganisationId(organisationPO.getOrgId());
        TenantRspBO tenantRspBO = this.tenantMapper.selectTenantById(organisationPO.getTenantId());
        if (tenantRspBO != null) {
            rspOrganisationBO.setTenantName(tenantRspBO.getTenantName());
        }
        logger.debug("[\u51fa\u53c2rspOrganisationBO]={}", (Object)rspOrganisationBO);
        return rspOrganisationBO;
    }
}

