/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.user;

import com.ohaotian.authority.dao.UserMapper;
import com.ohaotian.authority.dao.po.UserPO;
import com.ohaotian.authority.user.bo.RegisterIndividualUserReqBO;
import com.ohaotian.authority.user.bo.RegisterIndividualUserRspBO;
import com.ohaotian.authority.user.service.RegisterIndividualUserService;
import com.ohaotian.authority.util.SaltUtils;
import com.ohaotian.plugin.common.util.DigestUtils;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class RegisterIndividualUserServiceImpl
implements RegisterIndividualUserService {
    @Autowired
    private UserMapper userMapper;

    public RegisterIndividualUserRspBO registerIndividualUser(RegisterIndividualUserReqBO reqBO) {
        UserPO userPO = new UserPO();
        userPO.setName(reqBO.getName());
        userPO.setEmail(reqBO.getEmail());
        userPO.setCellPhone(reqBO.getCellPhone());
        String way = reqBO.getRegisterWay();
        userPO.setType("register:personal");
        switch (way) {
            case "alipay": {
                userPO.setAlipayId(reqBO.getOauth2Id());
                userPO.setLoginName("alipay" + reqBO.getOauth2Id());
                userPO.setSource(1);
                userPO.setInitialPassword(this.getStringRandom(8));
                break;
            }
            case "dingtalk": {
                userPO.setDingding(reqBO.getOauth2Id());
                userPO.setLoginName("dingtalk" + reqBO.getOauth2Id());
                userPO.setSource(1);
                break;
            }
            case "wechat": {
                userPO.setWechat(reqBO.getOauth2Id());
                userPO.setLoginName("wechat" + reqBO.getOauth2Id());
                userPO.setSource(1);
                userPO.setInitialPassword(this.getStringRandom(8));
                break;
            }
            default: {
                String password = reqBO.getPassword();
                if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{password})) break;
                String encrypt = DigestUtils.Encrypt((String)password, (String)"");
                String salt = SaltUtils.getSerialNo(8);
                String pwd = DigestUtils.Encrypt((String)(encrypt + salt), (String)"");
                userPO.setPassword(pwd);
                userPO.setSalt(salt);
                userPO.setLoginName(reqBO.getLoginName());
                userPO.setSource(2);
            }
        }
        this.userMapper.insertUser(userPO);
        RegisterIndividualUserRspBO rspBO = new RegisterIndividualUserRspBO();
        rspBO.setUserId(userPO.getUserId());
        return rspBO;
    }

    private String getStringRandom(int length) {
        String val = "";
        Random random = new Random();
        for (int i = 0; i < length; ++i) {
            String charOrNum;
            String string = charOrNum = random.nextInt(2) % 2 == 0 ? "char" : "num";
            if ("char".equalsIgnoreCase(charOrNum)) {
                int temp = random.nextInt(2) % 2 == 0 ? 65 : 97;
                val = val + (char)(random.nextInt(26) + temp);
                continue;
            }
            if (!"num".equalsIgnoreCase(charOrNum)) continue;
            val = val + String.valueOf(random.nextInt(10));
        }
        return val.toLowerCase();
    }
}

