/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.user;

import com.ohaotian.authority.constant.Constants;
import com.ohaotian.authority.role.bo.AuthDistributeBO;
import com.ohaotian.authority.role.bo.SelectRoleByIdReqBO;
import com.ohaotian.authority.role.bo.SelectRoleByIdRspBO;
import com.ohaotian.authority.role.service.SaveDistributeBusiService;
import com.ohaotian.authority.role.service.SelectRoleByIdBusiService;
import com.ohaotian.authority.user.bo.SaveUserAuthReqBO;
import com.ohaotian.authority.user.service.DeleteRoleByUserIdService;
import com.ohaotian.authority.user.service.SaveRoleAuthService;
import com.ohaotian.authority.user.service.SelectUserInfoService;
import com.ohaotian.authority.util.RoleGrantReqUtils;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SaveRoleAuthServiceImpl
implements SaveRoleAuthService {
    @Autowired
    private DeleteRoleByUserIdService deleteRoleByUserIdService;
    @Autowired
    private SaveDistributeBusiService saveDistributeBusiService;
    @Autowired
    private SelectRoleByIdBusiService selectRoleByIdBusiService;
    @Autowired
    private SelectUserInfoService selectUserInfoService;

    @Transactional(rollbackFor={Exception.class})
    public void saveRoleAuthService(SaveUserAuthReqBO saveUserAuthReqBO) {
        Set<Long> delete;
        Long roleId = saveUserAuthReqBO.getRoleId();
        SelectRoleByIdReqBO reqBO = new SelectRoleByIdReqBO();
        reqBO.setRoleId(roleId);
        SelectRoleByIdRspBO rspBO = this.selectRoleByIdBusiService.selectRoleById(reqBO);
        String json = saveUserAuthReqBO.getJson();
        Map<String, Set<Long>> stringSetMap = RoleGrantReqUtils.otherGrant(json);
        Set<Long> add = stringSetMap.get("add");
        if (add != null && add.size() > 0) {
            add.forEach(e -> {
                AuthDistributeBO authDistributeBO = new AuthDistributeBO();
                authDistributeBO.setUserId(e);
                authDistributeBO.setRoleId(roleId);
                authDistributeBO.setDisFlag(Constants.AUTH_USER);
                this.saveDistributeBusiService.saveDistribute(authDistributeBO);
            });
        }
        if ((delete = stringSetMap.get("delete")) != null && delete.size() > 0) {
            delete.forEach(e -> {
                AuthDistributeBO authDistributeBO = new AuthDistributeBO();
                authDistributeBO.setUserId(e);
                authDistributeBO.setRoleId(roleId);
                this.deleteRoleByUserIdService.deleteRoleByUserId(authDistributeBO);
            });
        }
    }
}

