/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.user;

import com.ohaotian.authority.constant.Constants;
import com.ohaotian.authority.role.bo.AuthDistributeBO;
import com.ohaotian.authority.role.service.SaveDistributeBusiService;
import com.ohaotian.authority.user.bo.SaveUserRolesAuthReqBO;
import com.ohaotian.authority.user.service.DeleteRoleByUserIdService;
import com.ohaotian.authority.user.service.SaveUserAuthService;
import com.ohaotian.authority.util.RoleGrantReqUtils;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SaveUserAuthServiceImpl
implements SaveUserAuthService {
    @Autowired
    private DeleteRoleByUserIdService deleteRoleByUserIdService;
    @Autowired
    private SaveDistributeBusiService saveDistributeBusiService;

    @Transactional(rollbackFor={Exception.class})
    public void saveUserAuthService(SaveUserRolesAuthReqBO saveUserAuthReqBO) {
        Set<Long> delete;
        Long userId = saveUserAuthReqBO.getUserId();
        String json = saveUserAuthReqBO.getJson();
        Map<String, Set<Long>> stringSetMap = RoleGrantReqUtils.otherGrant(json);
        Set<Long> add = stringSetMap.get("add");
        if (add != null && add.size() > 0) {
            add.forEach(e -> {
                AuthDistributeBO authDistributeBO = new AuthDistributeBO();
                authDistributeBO.setUserId(userId);
                authDistributeBO.setRoleId(e);
                authDistributeBO.setDisFlag(Constants.AUTH_USER);
                this.saveDistributeBusiService.saveDistribute(authDistributeBO);
            });
        }
        if ((delete = stringSetMap.get("delete")) != null && delete.size() > 0) {
            delete.forEach(e -> {
                AuthDistributeBO authDistributeBO = new AuthDistributeBO();
                authDistributeBO.setUserId(userId);
                authDistributeBO.setRoleId(e);
                this.deleteRoleByUserIdService.deleteRoleByUserId(authDistributeBO);
            });
        }
    }
}

