/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.user;

import com.ohaotian.authority.dao.AuthDistributeMapper;
import com.ohaotian.authority.dao.OrganizationMapper;
import com.ohaotian.authority.dao.TenantMapper;
import com.ohaotian.authority.dao.UserMapper;
import com.ohaotian.authority.dao.po.OrganisationPO;
import com.ohaotian.authority.dao.po.UserPO;
import com.ohaotian.authority.role.bo.HasAndNotGrantRoleBO;
import com.ohaotian.authority.tenant.bo.TenantRspBO;
import com.ohaotian.authority.user.bo.SelectUserInfoBatchRspBO;
import com.ohaotian.authority.user.bo.SelectUserInfoRspBO;
import com.ohaotian.authority.user.bo.StoreInfoReqBO;
import com.ohaotian.authority.user.bo.UserIdBO;
import com.ohaotian.authority.user.service.SelectUserDetailService;
import com.ohaotian.authority.user.service.StoreUserService;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.BeanMapper;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SelectUserDetailServiceImpl
implements SelectUserDetailService {
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private OrganizationMapper organizationMapper;
    @Autowired
    private TenantMapper tenantMapper;
    @Autowired
    private StoreUserService storeUserService;
    @Autowired
    private AuthDistributeMapper authDistributeMapper;

    public SelectUserInfoRspBO selectUserDetailByUserId(UserIdBO userIdBO) {
        OrganisationPO organisation;
        TenantRspBO tenant;
        UserPO userPO = this.userMapper.selectUserInfo(userIdBO.getUserId());
        SelectUserInfoRspBO selectUserInfoRspBO = null;
        if (userPO != null) {
            selectUserInfoRspBO = (SelectUserInfoRspBO)BeanMapper.map((Object)userPO, SelectUserInfoRspBO.class);
        }
        if ((tenant = this.tenantMapper.selectTenantById(userPO.getTenantId())) != null) {
            selectUserInfoRspBO.setTenantName(tenant.getTenantName());
        }
        if ((organisation = this.organizationMapper.selectOrganisationByOrgId(userPO.getOrgId())) != null) {
            selectUserInfoRspBO.setTitle(organisation.getTitle());
            selectUserInfoRspBO.setField1(organisation.getField1());
            selectUserInfoRspBO.setField2(organisation.getField2());
        }
        StoreInfoReqBO storeInfoReqBO = new StoreInfoReqBO();
        storeInfoReqBO.setUserId(userIdBO.getUserId());
        selectUserInfoRspBO.setStoreInfo(this.storeUserService.qryStoreInfoByUserId(storeInfoReqBO));
        List<HasAndNotGrantRoleBO> hasAndNotGrantRoleBOS = this.authDistributeMapper.selectRoleByUserId(userIdBO.getUserId());
        selectUserInfoRspBO.setUserRoles(hasAndNotGrantRoleBOS);
        return selectUserInfoRspBO;
    }

    public SelectUserInfoBatchRspBO selectUserDetailByLoginName(List<String> loginNames) {
        List<UserPO> userInfos;
        if (CollectionUtils.isEmpty(loginNames)) {
            throw new ZTBusinessException("\u767b\u5f55\u540d\u96c6\u5408\u4e3a\u7a7a");
        }
        try {
            userInfos = this.userMapper.selectUserInfoBatch(loginNames);
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
        ArrayList<SelectUserInfoRspBO> rows = null;
        if (CollectionUtils.isNotEmpty(userInfos)) {
            rows = new ArrayList<SelectUserInfoRspBO>(userInfos.size());
            for (UserPO user : userInfos) {
                SelectUserInfoRspBO rspBO = new SelectUserInfoRspBO();
                rspBO.setUserId(user.getUserId());
                rspBO.setLoginName(user.getLoginName());
                rspBO.setCellPhone(user.getCellPhone());
                rspBO.setField1(user.getField1());
                rspBO.setEmail(user.getEmail());
                rspBO.setName(user.getName());
                rspBO.setOrgId(user.getOrgId());
                rspBO.setType(user.getType());
                rspBO.setTenantId(user.getTenantId());
                rspBO.setmOrgId(user.getmOrgId());
                rows.add(rspBO);
            }
        }
        return new SelectUserInfoBatchRspBO("0000", "\u67e5\u8be2\u6210\u529f", rows);
    }
}

