/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.user;

import com.ohaotian.authority.dao.AuthDistributeMapper;
import com.ohaotian.authority.dao.RoleMapper;
import com.ohaotian.authority.dao.UserMapper;
import com.ohaotian.authority.dao.po.AuthDistribute;
import com.ohaotian.authority.dao.po.Role;
import com.ohaotian.authority.dao.po.UserPO;
import com.ohaotian.authority.role.bo.AuthDistributeBO;
import com.ohaotian.authority.tenant.bo.TenantIdBO;
import com.ohaotian.authority.tenant.bo.TenantRspBO;
import com.ohaotian.authority.tenant.service.SelectTenantByIdService;
import com.ohaotian.authority.user.bo.UpdateUserBOReq;
import com.ohaotian.authority.user.service.UpdateUserService;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UpdateUserServiceImpl
implements UpdateUserService {
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private RoleMapper roleMapper;
    @Autowired
    private AuthDistributeMapper authDistributeMapper;
    @Autowired
    private SelectTenantByIdService selectTenantByIdService;

    @Transactional(rollbackFor={Exception.class})
    public int updateUserByUserId(UpdateUserBOReq updateUserBOReq) {
        Role newRole;
        UserPO userPO = this.userMapper.selectUserInfo(updateUserBOReq.getUserIdReq());
        if (null == userPO) {
            return 0;
        }
        updateUserBOReq.setUpdateUserId(updateUserBOReq.getUserId());
        updateUserBOReq.setUpdateTime(new Date());
        if ("auth:tenant:manage".equals(updateUserBOReq.getType())) {
            TenantIdBO tenantIdBO = new TenantIdBO();
            tenantIdBO.setTenantId(userPO.getTenantId());
            TenantRspBO tenantRspBO = this.selectTenantByIdService.selectTenantById(tenantIdBO);
            if (tenantRspBO != null) {
                updateUserBOReq.setmOrgId(tenantRspBO.getOrgRootId());
            }
        } else if ("auth:org:manage".equals(updateUserBOReq.getType())) {
            updateUserBOReq.setmOrgId(userPO.getOrgId());
        }
        int result = this.userMapper.updateUserByUserId(updateUserBOReq);
        if (userPO.getType().equals(updateUserBOReq.getType())) {
            return result;
        }
        Role oldRole = this.roleMapper.selectRoleByAuthId(userPO.getType());
        if (null != oldRole) {
            AuthDistributeBO delete = new AuthDistributeBO();
            delete.setUserId(updateUserBOReq.getUserIdReq());
            delete.setRoleId(oldRole.getRoleId());
            this.authDistributeMapper.deleteRoleByUserId(delete);
        }
        if (null != (newRole = this.roleMapper.selectRoleByAuthId(updateUserBOReq.getType()))) {
            AuthDistribute authDistribute = new AuthDistribute();
            authDistribute.setRoleId(newRole.getRoleId());
            authDistribute.setUserId(updateUserBOReq.getUserIdReq());
            authDistribute.setDisFlag(1);
            this.authDistributeMapper.insert(authDistribute);
        }
        return result;
    }
}

