/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.controller.organisation;

import com.alibaba.dubbo.config.annotation.Reference;
import com.ohaotian.authority.log.BussinessLog;
import com.ohaotian.authority.log.LogObjectHolder;
import com.ohaotian.authority.organisation.bo.OrgSearchPageReqBO;
import com.ohaotian.authority.organisation.bo.OrganisationBO;
import com.ohaotian.authority.organisation.bo.OrganisationIdReqBO;
import com.ohaotian.authority.organisation.bo.POrdIdBO;
import com.ohaotian.authority.organisation.bo.RspOrganisationBO;
import com.ohaotian.authority.organisation.bo.SelectTreePathByOrgId;
import com.ohaotian.authority.organisation.bo.TenanNameRspBO;
import com.ohaotian.authority.organisation.bo.TenantNameListRspBO;
import com.ohaotian.authority.organisation.bo.TreePathRspBO;
import com.ohaotian.authority.organisation.bo.TreePathRspBOS;
import com.ohaotian.authority.organisation.service.CreateOrganisationService;
import com.ohaotian.authority.organisation.service.DeleteOrganizationServer;
import com.ohaotian.authority.organisation.service.OrgSearchService;
import com.ohaotian.authority.organisation.service.ReopenOrganisationByOrgId;
import com.ohaotian.authority.organisation.service.SelectAllOrgTreePathService;
import com.ohaotian.authority.organisation.service.SelectOrgRootTreePathService;
import com.ohaotian.authority.organisation.service.SelectOrgTreePathService;
import com.ohaotian.authority.organisation.service.SelectOrganisationByOrgIdService;
import com.ohaotian.authority.organisation.service.SelectTenantNameService;
import com.ohaotian.authority.organisation.service.SelectTreePathByOrgIdService;
import com.ohaotian.authority.organisation.service.StopOrganisationByOrgId;
import com.ohaotian.authority.organisation.service.UpdateOrganisationService;
import com.ohaotian.authority.role.bo.SaveOrgGrantRolesReqBO;
import com.ohaotian.authority.role.bo.SelectOrgAlreadyRolesReqBO;
import com.ohaotian.authority.role.bo.SelectOrgAlreadyRolesRspBO;
import com.ohaotian.authority.role.bo.SelectOrgDistributeReqBO;
import com.ohaotian.authority.role.bo.SelectOrgDistributeRspBO;
import com.ohaotian.authority.role.bo.SelectUserOperateRolesReqBO;
import com.ohaotian.authority.role.bo.SelectUserOperateRolesRspBO;
import com.ohaotian.authority.role.service.SaveOrgGrantRolesBusiService;
import com.ohaotian.authority.role.service.SelectOrgAlreadyRolesBusiService;
import com.ohaotian.authority.role.service.SelectUserOperateRolesBusiService;
import com.ohaotian.authority.tenant.bo.SelectUserTenantReqBO;
import com.ohaotian.authority.tenant.bo.TenantIdBO;
import com.ohaotian.authority.tenant.bo.TenantRspBO;
import com.ohaotian.authority.tenant.service.SelectTenantByIdService;
import com.ohaotian.authority.tenant.service.SelectUserTenantService;
import com.ohaotian.authority.user.bo.SelectUserInfoReqBO;
import com.ohaotian.authority.user.bo.SelectUserInfoRspBO;
import com.ohaotian.authority.user.service.SelectUserInfoService;
import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.security.entity.UserInfo;
import com.ohaotian.plugin.security.utils.SecurityHelper;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/org"}, method={RequestMethod.GET, RequestMethod.POST})
public class OrgController {
    private static final Logger logger = LoggerFactory.getLogger(OrgController.class);
    @Reference(version="1.0.0", group="authority")
    private CreateOrganisationService createOrganisationService;
    @Reference(version="1.0.0", group="authority")
    private UpdateOrganisationService updateOrganisationService;
    @Reference(version="1.0.0", group="authority")
    private StopOrganisationByOrgId stopOrganisationByOrgId;
    @Reference(version="1.0.0", group="authority")
    private ReopenOrganisationByOrgId reopenOrganisationByOrgId;
    @Reference(version="1.0.0", group="authority")
    private OrgSearchService orgSearchService;
    @Reference(version="1.0.0", group="authority")
    private SelectOrganisationByOrgIdService selectOrganisationByOrgIdService;
    @Reference(version="1.0.0", group="authority")
    private SelectUserOperateRolesBusiService selectUserOperateRolesBusiService;
    @Reference(version="1.0.0", group="authority")
    private SelectOrgAlreadyRolesBusiService selectOrgAlreadyRolesBusiService;
    @Reference(version="1.0.0", group="authority")
    private SaveOrgGrantRolesBusiService saveOrgGrantRolesBusiService;
    @Reference(version="1.0.0", group="authority")
    private SelectOrgTreePathService selectOrgTreePathService;
    @Reference(version="1.0.0", group="authority")
    private SelectOrgRootTreePathService selectOrgRootTreePathService;
    @Reference(version="1.0.0", group="authority")
    private SelectTreePathByOrgIdService selectTreePathByOrgIdService;
    @Reference(version="1.0.0", group="authority")
    private DeleteOrganizationServer deleteOrganizationServer;
    @Reference(version="1.0.0", group="authority")
    private SelectTenantNameService selectTenantNameService;
    @Reference(version="1.0.0", group="authority")
    private SelectTenantByIdService selectTenantByIdService;
    @Reference(version="1.0.0", group="authority")
    private SelectUserTenantService selectUserTenantService;
    @Reference(version="1.0.0", group="authority")
    private SelectAllOrgTreePathService selectAllOrgTreePathService;
    @Reference(version="1.0.0", group="authority")
    private SelectUserInfoService selectUserInfoService;

    @RequestMapping(value={"/add"})
    @BusiResponseBody
    @BussinessLog(module="\u673a\u6784\u7ba1\u7406", operat="\u65b0\u589e")
    public Object add(OrganisationBO organisationBO) {
        Date createTime = new Date();
        organisationBO.setCreatTime(createTime);
        Sequence sequence = Sequence.getInstance();
        long l = sequence.nextId();
        organisationBO.setOrganisationId(Long.valueOf(l));
        this.createOrganisationService.createOrganisation(organisationBO);
        return null;
    }

    @RequestMapping(value={"/select"})
    @BusiResponseBody
    public Object select(OrganisationIdReqBO organisationBO) {
        RspOrganisationBO rspOrganisationBO = this.selectOrganisationByOrgIdService.selectOrganisationByOrgId(organisationBO);
        return rspOrganisationBO;
    }

    @RequestMapping(value={"/selectTenant"})
    @BusiResponseBody
    public Object selectTenant() {
        if (SecurityHelper.hasAuthority((String)"auth:system:manage") || SecurityHelper.hasAuthority((String)"auth:overall:manage")) {
            return this.selectTenantNameService.selectTenanNameService();
        }
        if (SecurityHelper.hasAuthority((String)"auth:tenant:manage")) {
            SelectUserTenantReqBO selectUserTenantReqBO = new SelectUserTenantReqBO();
            TenantRspBO tenantRspBO = this.selectUserTenantService.selectUserTenant(selectUserTenantReqBO);
            TenantNameListRspBO rspBO = new TenantNameListRspBO();
            LinkedList<TenanNameRspBO> list = new LinkedList<TenanNameRspBO>();
            TenanNameRspBO tenanNameRspBO = new TenanNameRspBO();
            tenanNameRspBO.setTenantId(tenantRspBO.getTenantId());
            tenanNameRspBO.setTenantName(tenantRspBO.getTenantName());
            tenanNameRspBO.setOrgRootId(tenantRspBO.getOrgRootId());
            list.add(tenanNameRspBO);
            rspBO.setTenanNameRspBOList(list);
            return rspBO;
        }
        return null;
    }

    @RequestMapping(value={"/delete"})
    @BusiResponseBody
    @BussinessLog(module="\u673a\u6784\u7ba1\u7406", operat="\u5220\u9664")
    public Object deleteOrg(OrganisationIdReqBO organisationBO) {
        try {
            OrganisationIdReqBO reqBO = new OrganisationIdReqBO();
            reqBO.setOrganisationId(organisationBO.getOrganisationId());
            RspOrganisationBO rspBO = this.selectOrganisationByOrgIdService.selectOrganisationByOrgId(reqBO);
            LogObjectHolder.me().set((Object)rspBO);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u673a\u6784", (Throwable)e);
        }
        this.deleteOrganizationServer.deleteOrganization(organisationBO);
        return null;
    }

    @RequestMapping(value={"/update"})
    @BusiResponseBody
    @BussinessLog(module="\u673a\u6784\u7ba1\u7406", operat="\u7f16\u8f91")
    public Object update(OrganisationBO organisationBO) {
        try {
            OrganisationIdReqBO reqBO = new OrganisationIdReqBO();
            reqBO.setOrganisationId(organisationBO.getOrganisationId());
            RspOrganisationBO rspBO = this.selectOrganisationByOrgIdService.selectOrganisationByOrgId(reqBO);
            LogObjectHolder.me().set((Object)rspBO);
        }
        catch (Exception e) {
            logger.error("\u7f16\u8f91\u673a\u6784", (Throwable)e);
        }
        Date updateTime = new Date();
        organisationBO.setUpdateTime(updateTime);
        this.updateOrganisationService.updateOrganisation(organisationBO);
        return null;
    }

    @RequestMapping(value={"/stop"})
    @BusiResponseBody
    @BussinessLog(module="\u673a\u6784\u7ba1\u7406", operat="\u505c\u7528")
    public Object stop(OrganisationIdReqBO organisationBO) {
        this.stopOrganisationByOrgId.stopOrganisationByOrgId(organisationBO);
        return null;
    }

    @RequestMapping(value={"/reopen"})
    @BusiResponseBody
    @BussinessLog(module="\u673a\u6784\u7ba1\u7406", operat="\u542f\u7528")
    public Object reopen(OrganisationIdReqBO organisationBO) {
        this.reopenOrganisationByOrgId.reopenOrganisationByOrgId(organisationBO);
        return null;
    }

    @RequestMapping(value={"/search"})
    @BusiResponseBody
    public Object orgSearch(OrgSearchPageReqBO orgSearchPageReqBO) {
        return this.orgSearchService.selectSearchOrg(orgSearchPageReqBO);
    }

    @RequestMapping(value={"/rootPath"})
    @BusiResponseBody
    public Object getRootPath(@RequestParam(required=false) Long tenantId) {
        UserInfo currentUser = SecurityHelper.getCurrentUser();
        if (SecurityHelper.hasAuthority((String)"auth:system:manage") || SecurityHelper.hasAuthority((String)"auth:overall:manage")) {
            if (tenantId != null && tenantId != 0L) {
                TenantIdBO tenantIdBO = new TenantIdBO();
                tenantIdBO.setTenantId(tenantId);
                TenantRspBO tenantRspBO = this.selectTenantByIdService.selectTenantById(tenantIdBO);
                return this.selectOrgRootTreePathService.selectOrgTreePath(tenantRspBO.getOrgRootId());
            }
            POrdIdBO pOrdIdBO = new POrdIdBO();
            pOrdIdBO.setParentId(Long.valueOf(1L));
            return this.selectOrgTreePathService.selectOrgTreePath(pOrdIdBO);
        }
        if (SecurityHelper.hasAuthority((String)"auth:tenant:manage") && currentUser != null) {
            SelectUserInfoReqBO reqBO = new SelectUserInfoReqBO();
            reqBO.setUserId(currentUser.getUserId());
            SelectUserInfoRspBO userInfoRspBO = this.selectUserInfoService.selectUserInfo(reqBO);
            return this.selectOrgRootTreePathService.selectOrgTreePath(userInfoRspBO.getmOrgId());
        }
        return null;
    }

    @RequestMapping(value={"/getOrgByParentId"})
    @BusiResponseBody
    public Object getTreePath(POrdIdBO pOrdIdBO) {
        return this.selectOrgTreePathService.selectOrgTreePath(pOrdIdBO);
    }

    @RequestMapping(value={"/getAllOrgByParentId"})
    @BusiResponseBody
    public Object getAllTreePath(POrdIdBO pOrdIdBO) {
        return this.selectAllOrgTreePathService.selectAllOrgTreePath(pOrdIdBO);
    }

    @RequestMapping(value={"/qryParent"})
    @BusiResponseBody
    public Object qryParent(SelectTreePathByOrgId selectTreePathByOrgId) {
        return this.selectTreePathByOrgIdService.selectTreePathByOrgIdService(selectTreePathByOrgId);
    }

    @RequestMapping(value={"/alreadyAndNorRoles"})
    @BusiResponseBody
    public Object alreadyAndNorRoles(SelectOrgDistributeReqBO orgDistributeReqBO) {
        SelectUserOperateRolesReqBO map = (SelectUserOperateRolesReqBO)BeanMapper.map((Object)orgDistributeReqBO, SelectUserOperateRolesReqBO.class);
        SelectUserOperateRolesRspBO userOperateRolesRspBO = this.selectUserOperateRolesBusiService.selectUserOperateRoles(map);
        List userOperateRoles = userOperateRolesRspBO.getUserOperateRoles();
        SelectOrgAlreadyRolesReqBO orgAlreadyRolesReqBO = new SelectOrgAlreadyRolesReqBO();
        orgAlreadyRolesReqBO.setOrgTreePath(orgDistributeReqBO.getOrgTreePath());
        SelectOrgAlreadyRolesRspBO selectOrgAlreadyRolesRspBO = this.selectOrgAlreadyRolesBusiService.selectOrgAlreadyRoles(orgAlreadyRolesReqBO);
        List hasGrantRoles = selectOrgAlreadyRolesRspBO.getHasGrantRoles();
        userOperateRoles.removeAll(hasGrantRoles);
        SelectOrgDistributeRspBO orgDistributeRspBO = new SelectOrgDistributeRspBO();
        orgDistributeRspBO.setHasGrantRoles(hasGrantRoles);
        orgDistributeRspBO.setNotGrantRoles(userOperateRoles);
        return orgDistributeRspBO;
    }

    @RequestMapping(value={"/grantToOrg"})
    @BusiResponseBody
    @BussinessLog(module="\u673a\u6784\u7ba1\u7406", operat="\u673a\u6784\u5206\u914d\u89d2\u8272")
    public Object grantToOrg(SaveOrgGrantRolesReqBO saveOrgGrantRolesReqBO) {
        this.saveOrgGrantRolesBusiService.saveOrgGrantRoles(saveOrgGrantRolesReqBO);
        return null;
    }

    @RequestMapping(value={"/tenantRootOrg"})
    @BusiResponseBody
    public Object tenantRootOrg(TenantIdBO tenantIdBO) {
        TenantRspBO tenantRspBO = this.selectTenantByIdService.selectTenantById(tenantIdBO);
        OrganisationIdReqBO organisationIdReqBO = new OrganisationIdReqBO();
        organisationIdReqBO.setOrganisationId(tenantRspBO.getOrgRootId());
        RspOrganisationBO rspOrganisationBO = this.selectOrganisationByOrgIdService.selectOrganisationByOrgId(organisationIdReqBO);
        TreePathRspBOS treePathRspBOS = new TreePathRspBOS();
        LinkedList<TreePathRspBO> treePathRspBOList = new LinkedList<TreePathRspBO>();
        TreePathRspBO treePathRspBO = (TreePathRspBO)BeanMapper.map((Object)rspOrganisationBO, TreePathRspBO.class);
        POrdIdBO pOrdIdBO = new POrdIdBO();
        pOrdIdBO.setParentId(tenantRspBO.getOrgRootId());
        TreePathRspBOS treePathRspBOS1 = this.selectOrgTreePathService.selectOrgTreePath(pOrdIdBO);
        if (treePathRspBOS1.getTreePathRspBOList() != null && treePathRspBOS1.getTreePathRspBOList().size() > 0) {
            treePathRspBO.setIsParent(Integer.valueOf(0));
        } else {
            treePathRspBO.setIsParent(Integer.valueOf(1));
        }
        treePathRspBOList.add(treePathRspBO);
        treePathRspBOS.setTreePathRspBOList(treePathRspBOList);
        return treePathRspBOS;
    }
}

