/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.controller.user;

import com.alibaba.dubbo.config.annotation.Reference;
import com.alibaba.fastjson.JSON;
import com.ohaotian.authority.log.BussinessLog;
import com.ohaotian.authority.log.LogObjectHolder;
import com.ohaotian.authority.logger.bo.SaveLoginLogReqBO;
import com.ohaotian.authority.logger.service.SaveLoginLogBusiService;
import com.ohaotian.authority.manager.bo.UpdateManagerOrgReqBO;
import com.ohaotian.authority.manager.service.UpdateManagerOrgService;
import com.ohaotian.authority.organisation.bo.OrganisationIdReqBO;
import com.ohaotian.authority.organisation.bo.RspOrganisationBO;
import com.ohaotian.authority.organisation.service.SelectOrganisationByOrgIdService;
import com.ohaotian.authority.role.bo.SelectOrgAlreadyRolesRspBO;
import com.ohaotian.authority.role.bo.SelectOrgDistributeRspBO;
import com.ohaotian.authority.role.bo.SelectRolesByOrgTreePathReqBO;
import com.ohaotian.authority.role.bo.SelectRolesByOrgTreePathRspBO;
import com.ohaotian.authority.role.bo.SelectUserOperateRolesReqBO;
import com.ohaotian.authority.role.bo.SelectUserOperateRolesRspBO;
import com.ohaotian.authority.role.bo.SelectUserRolesReqBO;
import com.ohaotian.authority.role.service.SelectOverallRoleService;
import com.ohaotian.authority.role.service.SelectRolesByOrgTreePathBusiService;
import com.ohaotian.authority.role.service.SelectUserOperateRolesBusiService;
import com.ohaotian.authority.role.service.SelectUserRolesBusiService;
import com.ohaotian.authority.tenant.bo.TenantIdBO;
import com.ohaotian.authority.tenant.bo.TenantRspBO;
import com.ohaotian.authority.tenant.service.SelectTenantByIdService;
import com.ohaotian.authority.user.bo.AddUserReqBO;
import com.ohaotian.authority.user.bo.AddUserWebReqBO;
import com.ohaotian.authority.user.bo.ChangePwdIsOrNotReqBO;
import com.ohaotian.authority.user.bo.ChangePwdReqBO;
import com.ohaotian.authority.user.bo.ChangePwdWebReqBO;
import com.ohaotian.authority.user.bo.DeleteUserReqBO;
import com.ohaotian.authority.user.bo.InsertExtUserConditionWebReqBO;
import com.ohaotian.authority.user.bo.LoginNameBO;
import com.ohaotian.authority.user.bo.OAuth2UserInfoReqBO;
import com.ohaotian.authority.user.bo.OAuth2UserInfoRspBO;
import com.ohaotian.authority.user.bo.RegIndividualUserWebReqBO;
import com.ohaotian.authority.user.bo.RegisterIndividualUserReqBO;
import com.ohaotian.authority.user.bo.RegisterIndividualUserRspBO;
import com.ohaotian.authority.user.bo.SaveUserDefaultAppReqBO;
import com.ohaotian.authority.user.bo.SaveUserRolesAuthReqBO;
import com.ohaotian.authority.user.bo.SelectExtUserIdWebReqBO;
import com.ohaotian.authority.user.bo.SelectPublicUserInfoReqBO;
import com.ohaotian.authority.user.bo.SelectSearchByUserInfoReqBO;
import com.ohaotian.authority.user.bo.SelectUserByCellphoneReqBO;
import com.ohaotian.authority.user.bo.SelectUserByLoginNameReqBO;
import com.ohaotian.authority.user.bo.SelectUserDefaultAppReqBO;
import com.ohaotian.authority.user.bo.SelectUserInfoRspBO;
import com.ohaotian.authority.user.bo.SelectUserInfoSearchRspBO;
import com.ohaotian.authority.user.bo.UpdatePersonCellPhoneNullReqBO;
import com.ohaotian.authority.user.bo.UpdatePublicUserBOReq;
import com.ohaotian.authority.user.bo.UpdateUserBOReq;
import com.ohaotian.authority.user.bo.UpdateUserInfoByRecReqBO;
import com.ohaotian.authority.user.bo.UserAuthReqBO;
import com.ohaotian.authority.user.bo.UserIdBO;
import com.ohaotian.authority.user.bo.UserParentIdOrgReqBO;
import com.ohaotian.authority.user.service.AddManageUserService;
import com.ohaotian.authority.user.service.AddPortalUserWebService;
import com.ohaotian.authority.user.service.ChangePwdByUserIdService;
import com.ohaotian.authority.user.service.ChangePwdByUserIdWebService;
import com.ohaotian.authority.user.service.ChangePwdOfExpireService;
import com.ohaotian.authority.user.service.DeleteUserService;
import com.ohaotian.authority.user.service.InsertExtUserConditionWebService;
import com.ohaotian.authority.user.service.RegIndividualUserOAuth2WebService;
import com.ohaotian.authority.user.service.RegisterIndividualUserOAuth2Service;
import com.ohaotian.authority.user.service.ReopenUserStatusByUserIdService;
import com.ohaotian.authority.user.service.ResetPasswordService;
import com.ohaotian.authority.user.service.SaveUserAuthService;
import com.ohaotian.authority.user.service.SaveUserDefaultAppService;
import com.ohaotian.authority.user.service.SelectExtUserIdWebService;
import com.ohaotian.authority.user.service.SelectPublicUserInfoService;
import com.ohaotian.authority.user.service.SelectSearchByUserInfoService;
import com.ohaotian.authority.user.service.SelectUserAlreadyAuthRolesService;
import com.ohaotian.authority.user.service.SelectUserByCellphoneService;
import com.ohaotian.authority.user.service.SelectUserByLoginNameService;
import com.ohaotian.authority.user.service.SelectUserDefaultAppService;
import com.ohaotian.authority.user.service.SelectUserDetailService;
import com.ohaotian.authority.user.service.SelectUserIdByOAuth2Service;
import com.ohaotian.authority.user.service.SelectUserNameServer;
import com.ohaotian.authority.user.service.SelectUserStaionByUserIdService;
import com.ohaotian.authority.user.service.StopUserStatusByUserIdService;
import com.ohaotian.authority.user.service.UpdatePersonCellPhoneNullService;
import com.ohaotian.authority.user.service.UpdatePublicUserService;
import com.ohaotian.authority.user.service.UpdateUserInfoByRecWebService;
import com.ohaotian.authority.user.service.UpdateUserService;
import com.ohaotian.authority.user.service.UserParentIdOrgService;
import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.base.bo.RspMapInfoBO;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.security.entity.UserInfo;
import com.ohaotian.plugin.security.utils.SecurityHelper;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import redis.clients.jedis.Jedis;

@Controller
@RequestMapping(value={"/user"}, method={RequestMethod.GET, RequestMethod.POST})
public class UserController {
    private static final Logger logger = LoggerFactory.getLogger(UserController.class);
    @Reference(version="1.0.0", group="authority")
    private SelectSearchByUserInfoService selectSearchByUserInfoService;
    @Reference(version="1.0.0", group="authority")
    private SelectUserDetailService selectUserDetailService;
    @Reference(version="1.0.0", group="authority")
    private UpdateUserService updateUserService;
    @Reference(version="1.0.0", group="authority")
    private StopUserStatusByUserIdService stopUserStatusByUserIdService;
    @Reference(version="1.0.0", group="authority")
    private ReopenUserStatusByUserIdService reopenUserStatusByUserIdService;
    @Reference(version="1.0.0", group="authority")
    private ResetPasswordService resetPasswordService;
    @Reference(version="1.0.0", group="authority")
    private AddManageUserService addManageUserService;
    @Reference(version="1.0.0", group="authority")
    private UserParentIdOrgService userParentIdOrgService;
    @Reference(version="1.0.0", group="authority")
    private SelectUserOperateRolesBusiService selectUserOperateRolesBusiService;
    @Reference(version="1.0.0", group="authority")
    private SelectUserAlreadyAuthRolesService selectUserAlreadyAuthRolesService;
    @Reference(version="1.0.0", group="authority")
    private SaveUserAuthService saveUserAuthService;
    @Reference(version="1.0.0", group="authority")
    private SelectUserRolesBusiService selectUserRolesBusiService;
    @Reference(version="1.0.0", group="authority")
    private UpdateManagerOrgService updateManagerOrgService;
    @Reference(version="1.0.0", group="authority")
    private SelectUserNameServer selectUserNameServer;
    @Reference(version="1.0.0", group="authority")
    private DeleteUserService deleteUserService;
    @Reference(version="1.0.0", group="authority")
    private SelectOrganisationByOrgIdService selectOrganisationByOrgIdService;
    @Reference(version="1.0.0", group="authority")
    private SelectTenantByIdService selectTenantByIdService;
    @Reference(version="1.0.0", group="authority")
    private ChangePwdByUserIdService changePwdByUserIdService;
    @Reference(version="1.0.0", group="authority")
    private SelectUserByLoginNameService selectUserByLoginNameService;
    @Reference(version="1.0.0", group="authority")
    private SelectUserStaionByUserIdService selectUserStaionByUserIdService;
    @Reference(version="1.0.0", group="authority")
    private RegisterIndividualUserOAuth2Service registerIndividualUserService;
    @Reference(version="1.0.0", group="authority")
    private SelectUserIdByOAuth2Service selectUserIdByOAuth2Service;
    @Reference(version="1.0.0", group="authority")
    private SelectExtUserIdWebService selectExtUserIdWebService;
    @Reference(version="1.0.0", group="authority")
    private SaveLoginLogBusiService saveLoginLogBusiService;
    @Reference(version="1.0.0", group="authority")
    private SelectUserByCellphoneService selectUserByCellphoneService;
    @Reference(version="1.0.0", group="authority")
    private InsertExtUserConditionWebService insertExtUserConditionWebService;
    @Reference(version="1.0.0", group="authority")
    private RegIndividualUserOAuth2WebService regIndividualUserOAuth2WebService;
    @Reference(version="1.0.0", group="authority")
    private SelectPublicUserInfoService selectPublicUserInfoService;
    @Reference(version="1.0.0", group="authority")
    private UpdatePublicUserService updatePublicUserService;
    @Reference(version="1.0.0", group="authority")
    private UpdatePersonCellPhoneNullService updatePersonCellPhoneNullService;
    @Reference(version="1.0.0", group="authority")
    private UpdateUserInfoByRecWebService updateUserInfoByRecWebService;
    @Reference(version="1.0.0", group="authority")
    private SelectRolesByOrgTreePathBusiService selectRolesByOrgTreePathBusiService;
    @Reference(version="1.0.0", group="authority")
    private AddPortalUserWebService addPortalUserWebService;
    @Reference(version="1.0.0", group="authority")
    private ChangePwdByUserIdWebService changePwdByUserIdWebService;
    @Reference(version="1.0.0", group="authority")
    private ChangePwdOfExpireService changePwdOfExpireService;
    @Autowired
    private CacheClient cacheClient;
    @Value(value="${redis.database:2}")
    private int redisDatabase;
    @Reference(version="1.0.0", group="authority")
    private SelectOverallRoleService selectOverallRoleService;
    @Reference(version="1.0.0", group="authority")
    private SelectUserDefaultAppService selectUserDefaultAppService;
    @Reference(version="1.0.0", group="authority")
    private SaveUserDefaultAppService saveUserDefaultAppService;

    @RequestMapping(value={"/search"})
    @BusiResponseBody
    public Object selectSearchByUserInfoService(SelectSearchByUserInfoReqBO selectSearchByUserInfoReqBO) {
        LinkedList<String> typeList = new LinkedList<String>();
        if (SecurityHelper.hasAuthority((String)"auth:system:manage")) {
            typeList.add("auth:overall:manage");
            typeList.add("auth:tenant:manage");
            typeList.add("auth:default:manage");
            selectSearchByUserInfoReqBO.setTypeList(typeList);
        } else if (SecurityHelper.hasAuthority((String)"auth:overall:manage")) {
            typeList.add("auth:tenant:manage");
            typeList.add("auth:default:manage");
            selectSearchByUserInfoReqBO.setTypeList(typeList);
        } else if (SecurityHelper.hasAuthority((String)"auth:tenant:manage") || SecurityHelper.hasAuthority((String)"auth:org:manage")) {
            UserInfo currentUser = SecurityHelper.getCurrentUser();
            typeList.add("auth:default:manage");
            typeList.add("auth:org:manage");
            selectSearchByUserInfoReqBO.setTypeList(typeList);
            RspPage orgUser = this.selectSearchByUserInfoService.selectSearchByUserInfoService(selectSearchByUserInfoReqBO);
            ArrayList<SelectUserInfoSearchRspBO> selectUserInfoSearchRspBO = new ArrayList<SelectUserInfoSearchRspBO>();
            for (SelectUserInfoSearchRspBO sOrgUser : orgUser.getRows()) {
                if (currentUser.getUserId().equals(sOrgUser.getUserId())) continue;
                selectUserInfoSearchRspBO.add(sOrgUser);
            }
            orgUser.setRows(selectUserInfoSearchRspBO);
            return orgUser;
        }
        return this.selectSearchByUserInfoService.selectSearchByUserInfoService(selectSearchByUserInfoReqBO);
    }

    @RequestMapping(value={"/select"})
    @BusiResponseBody
    public Object select(UserIdBO userIdBO) {
        SelectUserInfoRspBO selectUserInfoRspBO = this.selectUserDetailService.selectUserDetailByUserId(userIdBO);
        return selectUserInfoRspBO;
    }

    @RequestMapping(value={"/getUserInfo"})
    @BusiResponseBody
    public Object getUserInfo() {
        RspMapInfoBO rspMapInfoBO = new RspMapInfoBO();
        HashMap<String, String> resMap = new HashMap<String, String>();
        UserInfo user = SecurityHelper.getCurrentUser();
        UserIdBO userIdBO = new UserIdBO();
        userIdBO.setUserId(user.getUserId());
        SelectUserInfoRspBO selectUserInfoRspBO = this.selectUserDetailService.selectUserDetailByUserId(userIdBO);
        if (selectUserInfoRspBO != null) {
            resMap.put("loginName", selectUserInfoRspBO.getLoginName());
            resMap.put("name", selectUserInfoRspBO.getName());
            resMap.put("cellPhone", selectUserInfoRspBO.getCellPhone());
            resMap.put("email", selectUserInfoRspBO.getEmail());
        }
        if (user.getOrgId() != null) {
            OrganisationIdReqBO organisationIdReqBO = new OrganisationIdReqBO();
            organisationIdReqBO.setOrganisationId(user.getOrgId());
            RspOrganisationBO organisationBO = this.selectOrganisationByOrgIdService.selectOrganisationByOrgId(organisationIdReqBO);
            if (organisationBO != null) {
                resMap.put("orgName", organisationBO.getTitle());
            }
        } else {
            resMap.put("orgName", "");
        }
        if (user.getTenantId() != null) {
            TenantIdBO tenantIdBO = new TenantIdBO();
            tenantIdBO.setTenantId(user.getTenantId());
            TenantRspBO tenantRspBO = this.selectTenantByIdService.selectTenantById(tenantIdBO);
            if (tenantRspBO != null) {
                resMap.put("tenantName", tenantRspBO.getTenantName());
            }
        } else {
            resMap.put("tenantName", "");
        }
        rspMapInfoBO.setData(resMap);
        return rspMapInfoBO;
    }

    @RequestMapping(value={"/commit"})
    @BusiResponseBody
    @BussinessLog(module="\u7528\u6237\u7ba1\u7406", operat="\u7f16\u8f91")
    public Object updateUserByUserId(UpdateUserBOReq updateUserBOReq) {
        try {
            UserIdBO reqBo = new UserIdBO();
            reqBo.setUserId(updateUserBOReq.getUserIdReq());
            SelectUserInfoRspBO rspBO = this.selectUserDetailService.selectUserDetailByUserId(reqBo);
            LogObjectHolder.me().set((Object)rspBO);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664", (Throwable)e);
        }
        this.updateUserService.updateUserByUserId(updateUserBOReq);
        return null;
    }

    @RequestMapping(value={"/stop"})
    @BusiResponseBody
    @BussinessLog(module="\u7528\u6237\u7ba1\u7406", operat="\u505c\u7528")
    public Object stop(UserIdBO userIdBO) {
        this.stopUserStatusByUserIdService.stopUserStatusByUserId(userIdBO);
        return null;
    }

    @RequestMapping(value={"/reopen"})
    @BusiResponseBody
    @BussinessLog(module="\u7528\u6237\u7ba1\u7406", operat="\u542f\u7528")
    public Object reopen(UserIdBO userIdBO) {
        this.reopenUserStatusByUserIdService.reopenUserStatusByUserId(userIdBO);
        return null;
    }

    @RequestMapping(value={"/reset"})
    @BusiResponseBody
    @BussinessLog(module="\u7528\u6237\u7ba1\u7406", operat="\u91cd\u7f6e\u5bc6\u7801")
    public Object reset(String userId) {
        List userIds = JSON.parseArray((String)userId, Long.class);
        this.resetPasswordService.resetPasswordByUserId(userIds);
        for (Long userIdReq : userIds) {
            UserIdBO userIdBO = new UserIdBO();
            userIdBO.setUserId(userIdReq);
            SelectUserInfoRspBO userRspBO = this.selectUserDetailService.selectUserDetailByUserId(userIdBO);
            Jedis resource = this.cacheClient.getJedisPool().getResource();
            String select = resource.select(this.redisDatabase);
            resource.del("cas" + userRspBO.getLoginName());
            resource.close();
        }
        return null;
    }

    @RequestMapping(value={"/add/commit"})
    @BusiResponseBody
    @BussinessLog(module="\u7528\u6237\u7ba1\u7406", operat="\u65b0\u589e")
    public Object commit(AddUserReqBO addUserReqBO) {
        addUserReqBO.setDetialSource("00");
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{addUserReqBO.getNameReq()})) {
            try {
                addUserReqBO.setName(new String(addUserReqBO.getNameReq().getBytes("iso-8859-1"), "utf-8"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        if ("auth:overall:manage".equals(addUserReqBO.getType())) {
            addUserReqBO.setOrgIdReq(null);
            addUserReqBO.setTenantIdReq(null);
        } else if ("auth:tenant:manage".equals(addUserReqBO.getType())) {
            TenantIdBO tenantIdBO = new TenantIdBO();
            tenantIdBO.setTenantId(addUserReqBO.getTenantIdReq());
            TenantRspBO tenantRspBO = this.selectTenantByIdService.selectTenantById(tenantIdBO);
            if (tenantRspBO != null) {
                addUserReqBO.setmOrgId(tenantRspBO.getOrgRootId());
            }
        }
        Sequence sequence = Sequence.getInstance();
        long l = sequence.nextId();
        addUserReqBO.setAuthUserId(Long.valueOf(l));
        addUserReqBO.setRegisterType("register:personal");
        this.addManageUserService.insertUser(addUserReqBO);
        return l;
    }

    @RequestMapping(value={"/add/commit/select"})
    @BusiResponseBody
    public Object selectUserName(LoginNameBO loginNameBO) {
        return this.selectUserNameServer.selectUserNameByLoginName(loginNameBO);
    }

    @PostMapping(value={"/add/tree"})
    @BusiResponseBody
    public Object tree(UserParentIdOrgReqBO userParentIdOrgReqBO) {
        return this.userParentIdOrgService.selectUserParentIdOrg(userParentIdOrgReqBO);
    }

    @RequestMapping(value={"/authUser"})
    @BusiResponseBody
    public Object authUser(UserAuthReqBO userAuthReqBO) {
        List userOperateRoles = new ArrayList();
        if (SecurityHelper.hasAuthority((String)"auth:org:manage")) {
            SelectRolesByOrgTreePathReqBO selectRolesByOrgTreePathReqBO = new SelectRolesByOrgTreePathReqBO();
            selectRolesByOrgTreePathReqBO.setOrgTreePath(userAuthReqBO.getManaOrgTreePath());
            SelectRolesByOrgTreePathRspBO overallRole = this.selectOverallRoleService.overallRole(selectRolesByOrgTreePathReqBO);
            SelectRolesByOrgTreePathRspBO select = this.selectRolesByOrgTreePathBusiService.select(selectRolesByOrgTreePathReqBO);
            userOperateRoles.addAll(select.getHasGrantRoles());
            userOperateRoles.addAll(overallRole.getHasGrantRoles());
        } else {
            SelectUserOperateRolesReqBO operateRolesReqBO = new SelectUserOperateRolesReqBO();
            operateRolesReqBO.setPrarmUserId(userAuthReqBO.getPrarmUserId());
            SelectUserOperateRolesRspBO selectUserOperateRolesRspBO = this.selectUserOperateRolesBusiService.selectUserOperateRoles(operateRolesReqBO);
            userOperateRoles = selectUserOperateRolesRspBO.getUserOperateRoles();
        }
        SelectOrgAlreadyRolesRspBO selectOrgAlreadyRolesRspBO = this.selectUserAlreadyAuthRolesService.selectOrgAlreadyRoles(userAuthReqBO);
        List hasGrantRoles = selectOrgAlreadyRolesRspBO.getHasGrantRoles();
        userOperateRoles.removeAll(hasGrantRoles);
        SelectOrgDistributeRspBO orgDistributeRspBO = new SelectOrgDistributeRspBO();
        orgDistributeRspBO.setHasGrantRoles(hasGrantRoles);
        orgDistributeRspBO.setNotGrantRoles(userOperateRoles);
        return orgDistributeRspBO;
    }

    @RequestMapping(value={"/authUserCommit"})
    @BusiResponseBody
    @BussinessLog(module="\u7528\u6237\u7ba1\u7406", operat="\u6388\u6743")
    public Object authUserCommit(SaveUserRolesAuthReqBO saveUserRolesAuthReqBO) {
        if (StringUtils.isEmpty((CharSequence)saveUserRolesAuthReqBO.getJson())) {
            throw new ZTBusinessException("\u8bf7\u91cd\u65b0\u9009\u62e9");
        }
        if (saveUserRolesAuthReqBO.getUserId() == null) {
            throw new ZTBusinessException("\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.saveUserAuthService.saveUserAuthService(saveUserRolesAuthReqBO);
        return null;
    }

    @RequestMapping(value={"/selectUserRoles"})
    @BusiResponseBody
    public Object selectUserRoles(SelectUserRolesReqBO userRolesReqBO) {
        return this.selectUserRolesBusiService.selectUserRoles(userRolesReqBO);
    }

    @RequestMapping(value={"/update"})
    @BusiResponseBody
    public Object updateManagerService(UpdateManagerOrgReqBO updateManagerOrgReqBO) {
        this.updateManagerOrgService.updateManager(updateManagerOrgReqBO);
        return null;
    }

    @RequestMapping(value={"/delete"})
    @BusiResponseBody
    @BussinessLog(module="\u7528\u6237\u7ba1\u7406", operat="\u5220\u9664")
    public Object deleteUser(DeleteUserReqBO deleteUserReqBO) {
        try {
            UserIdBO userIdBO = new UserIdBO();
            userIdBO.setUserId(deleteUserReqBO.getUserId());
            SelectUserInfoRspBO rspBO = this.selectUserDetailService.selectUserDetailByUserId(userIdBO);
            LogObjectHolder.me().set((Object)rspBO);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664", (Throwable)e);
        }
        this.deleteUserService.deleteUserByUserId(deleteUserReqBO);
        return null;
    }

    @RequestMapping(value={"/changeUserPwd"})
    @BusiResponseBody
    @BussinessLog(module="\u7528\u6237\u7ba1\u7406", operat="\u4fee\u6539\u5bc6\u7801")
    public Object changeUserPwd(ChangePwdReqBO changePwdReqBO) {
        this.changePwdByUserIdService.changePasswordByUserId(changePwdReqBO);
        Jedis resource = this.cacheClient.getJedisPool().getResource();
        String select = resource.select(this.redisDatabase);
        resource.del("cas" + SecurityHelper.getCurrentUser().getUsername());
        resource.close();
        return null;
    }

    @RequestMapping(value={"/checkLoginName"})
    @BusiResponseBody
    public Object checkLoginName(@RequestParam String username, @RequestParam String password, @RequestParam(required=false) String type, SelectUserByLoginNameReqBO selectUserByLoginNameReqBO) {
        return this.selectUserByLoginNameService.selectUserByLoginNameService(selectUserByLoginNameReqBO);
    }

    @RequestMapping(value={"/selectUserStation"})
    @BusiResponseBody
    public Object selectUserStation(UserIdBO userId) {
        return this.selectUserStaionByUserIdService.selectUserStation(userId);
    }

    @RequestMapping(value={"/registerIndividualUser"})
    @BusiResponseBody
    public Object registerIndividualUser(@RequestParam(required=false) String name, @RequestParam(required=false) String loginName, RegisterIndividualUserReqBO reqBO) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{name})) {
            try {
                reqBO.setName(new String(name.getBytes("iso-8859-1"), "utf-8"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{loginName})) {
            try {
                reqBO.setLoginName(new String(loginName.getBytes("iso-8859-1"), "utf-8"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        Sequence sequence = Sequence.getInstance();
        long id = sequence.nextId();
        reqBO.setUserId(Long.valueOf(id));
        RegisterIndividualUserRspBO rspBO = this.registerIndividualUserService.registerIndividualUser(reqBO);
        return rspBO;
    }

    @RequestMapping(value={"/getUserIdByOAuth2"})
    @BusiResponseBody
    public Object registerIndividualUser(OAuth2UserInfoReqBO reqBO) {
        OAuth2UserInfoRspBO rspBO = this.selectUserIdByOAuth2Service.selectUserIdByOAuth2(reqBO);
        if (rspBO.getUserId() != null) {
            UserIdBO userIdBO = new UserIdBO();
            userIdBO.setUserId(rspBO.getUserId());
            SelectUserInfoRspBO selectUserInfoRspBO = this.selectUserDetailService.selectUserDetailByUserId(userIdBO);
            SaveLoginLogReqBO saveLoginLogReqBO = new SaveLoginLogReqBO();
            saveLoginLogReqBO.setLoginName(selectUserInfoRspBO.getLoginName());
            saveLoginLogReqBO.setMacInfo("\u767b\u5f55\u6210\u529f");
            this.saveLoginLogBusiService.saveLoginLog(saveLoginLogReqBO);
        }
        return rspBO;
    }

    @RequestMapping(value={"/selectExtUserId"})
    @BusiResponseBody
    public Object selectExtUserId(SelectExtUserIdWebReqBO reqBO) {
        return this.selectExtUserIdWebService.selectExtUserId(reqBO);
    }

    @RequestMapping(value={"/selPersonUserByPhone"})
    @BusiResponseBody
    public Object selPersonUserByPhone(SelectUserByCellphoneReqBO selectUserByCellphoneReqBO) {
        return this.selectUserByCellphoneService.selectUserByCellphone(selectUserByCellphoneReqBO);
    }

    @RequestMapping(value={"/insertExtUserCondition"})
    @BusiResponseBody
    public Object insertExtUserCondition(InsertExtUserConditionWebReqBO insertExtUserConditionWebReqBO) {
        this.insertExtUserConditionWebService.insertExtUserConditionWeb(insertExtUserConditionWebReqBO);
        return null;
    }

    @RequestMapping(value={"/regIndividualUserOAuth2Web"})
    @BusiResponseBody
    public Object regIndividualUserOAuth2Web(RegIndividualUserWebReqBO regIndividualUserWebReqBO) {
        if (StringUtils.isNotEmpty((CharSequence)regIndividualUserWebReqBO.getName())) {
            try {
                regIndividualUserWebReqBO.setName(new String(regIndividualUserWebReqBO.getName().getBytes("iso-8859-1"), "utf-8"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)regIndividualUserWebReqBO.getLoginName())) {
            try {
                regIndividualUserWebReqBO.setLoginName(new String(regIndividualUserWebReqBO.getLoginName().getBytes("iso-8859-1"), "utf-8"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return this.regIndividualUserOAuth2WebService.registerIndividualUser(regIndividualUserWebReqBO);
    }

    @RequestMapping(value={"/selectPublicUser"})
    @BusiResponseBody
    public Object selectPublicUser(SelectPublicUserInfoReqBO reqBO) {
        if (SecurityHelper.hasAuthority((String)"auth:system:manage") || SecurityHelper.hasAuthority((String)"auth:overall:manage") || SecurityHelper.hasAuthority((String)"auth:tenant:manage")) {
            return this.selectPublicUserInfoService.selectPublicUserInfo(reqBO);
        }
        return null;
    }

    @RequestMapping(value={"/publicCommit"})
    @BusiResponseBody
    @BussinessLog(module="\u516c\u4f17\u7528\u6237\u7ba1\u7406", operat="\u7f16\u8f91")
    public Object updatePublicUserByUserId(UpdatePublicUserBOReq updatePublicUserBOReq) {
        try {
            UserIdBO reqBo = new UserIdBO();
            reqBo.setUserId(updatePublicUserBOReq.getUserIdReq());
            SelectUserInfoRspBO rspBO = this.selectUserDetailService.selectUserDetailByUserId(reqBo);
            LogObjectHolder.me().set((Object)rspBO);
        }
        catch (Exception e) {
            logger.error("\u7f16\u8f91", (Throwable)e);
        }
        this.updatePublicUserService.updatePublicUser(updatePublicUserBOReq);
        return null;
    }

    @RequestMapping(value={"/updatePersonCellPhoneNull"})
    @BusiResponseBody
    public Object updatePersonCellPhoneNull(UpdatePersonCellPhoneNullReqBO updatePersonCellPhoneNullReqBO) {
        this.updatePersonCellPhoneNullService.updatePersonCellPhoneNull(updatePersonCellPhoneNullReqBO);
        return null;
    }

    @RequestMapping(value={"/updateUserInfoByRec"})
    @BusiResponseBody
    public Object updateUserInfoByRec(UpdateUserInfoByRecReqBO userInfoByRecReqBO) {
        try {
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{userInfoByRecReqBO.getName()})) {
                userInfoByRecReqBO.setName(new String(userInfoByRecReqBO.getName().getBytes("iso-8859-1"), "utf-8"));
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{userInfoByRecReqBO.getLoginName()})) {
                userInfoByRecReqBO.setLoginName(new String(userInfoByRecReqBO.getLoginName().getBytes("iso-8859-1"), "utf-8"));
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        this.updateUserInfoByRecWebService.updateUserInfoByRecWeb(userInfoByRecReqBO);
        return null;
    }

    @RequestMapping(value={"/manageSearch"})
    @BusiResponseBody
    public Object searchTwoLevelManage(SelectSearchByUserInfoReqBO selectSearchByUserInfoReqBO) {
        LinkedList<String> typeList = new LinkedList<String>();
        if (SecurityHelper.hasAuthority((String)"auth:system:manage") || SecurityHelper.hasAuthority((String)"auth:overall:manage") || SecurityHelper.hasAuthority((String)"auth:tenant:manage") || SecurityHelper.hasAuthority((String)"auth:org:manage")) {
            typeList.add("auth:default:manage");
            selectSearchByUserInfoReqBO.setTypeList(typeList);
        }
        return this.selectSearchByUserInfoService.selectSearchByUserInfoService(selectSearchByUserInfoReqBO);
    }

    @RequestMapping(value={"/addPortalUser"})
    @BusiResponseBody
    public Object addPortalUserWeb(AddUserWebReqBO addUserWebReqBO) {
        try {
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{addUserWebReqBO.getName()})) {
                addUserWebReqBO.setName(new String(addUserWebReqBO.getName().getBytes("iso-8859-1"), "utf-8"));
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{addUserWebReqBO.getLoginNameReq()})) {
                addUserWebReqBO.setLoginNameReq(new String(addUserWebReqBO.getLoginNameReq().getBytes("iso-8859-1"), "utf-8"));
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{addUserWebReqBO.getCellPhoneReq()})) {
                addUserWebReqBO.setCellPhoneReq(new String(addUserWebReqBO.getCellPhoneReq().getBytes("iso-8859-1"), "utf-8"));
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        this.addPortalUserWebService.insertUser(addUserWebReqBO);
        return null;
    }

    @RequestMapping(value={"/updatePassword"})
    @BusiResponseBody
    @BussinessLog(module="\u7528\u6237\u7ba1\u7406", operat="\u8bbe\u7f6e\u5bc6\u7801")
    public Object updatePassword(ChangePwdWebReqBO changePwdWebReqBO) {
        this.changePwdByUserIdWebService.changePasswordByUserId(changePwdWebReqBO);
        Jedis resource = this.cacheClient.getJedisPool().getResource();
        String select = resource.select(this.redisDatabase);
        if (changePwdWebReqBO.getUserIdReq() != null) {
            UserIdBO userIdBO = new UserIdBO();
            userIdBO.setUserId(changePwdWebReqBO.getUserIdReq());
            SelectUserInfoRspBO userRspBO = this.selectUserDetailService.selectUserDetailByUserId(userIdBO);
            resource.del("cas" + userRspBO.getLoginName());
        } else {
            resource.del("cas" + SecurityHelper.getCurrentUser().getUsername());
        }
        resource.close();
        return null;
    }

    @RequestMapping(value={"/changeInvalidPwd"})
    @BusiResponseBody
    public Object changeInvalidPwd(ChangePwdIsOrNotReqBO changePwdIsOrNotReqBO) {
        return this.changePwdOfExpireService.changePwd(changePwdIsOrNotReqBO);
    }

    @RequestMapping(value={"/selectUserDefaultApp"})
    @BusiResponseBody
    public Object selectUserDefaultApp(SelectUserDefaultAppReqBO reqBO) {
        return this.selectUserDefaultAppService.selectUserDefaultApp(reqBO);
    }

    @RequestMapping(value={"/saveUserDefaultApp"})
    @BusiResponseBody
    public Object saveUserDefaultApp(SaveUserDefaultAppReqBO reqBO) {
        if (StringUtils.isEmpty((CharSequence)reqBO.getAppCode())) {
            throw new ZTBusinessException("\u5e94\u7528\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.saveUserDefaultAppService.saveUserDefaultApp(reqBO);
        return null;
    }
}

