/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.controller.area;

import com.ohaotian.authority.area.bo.SelectAreaByOrgType;
import com.ohaotian.authority.area.bo.SelectAreaReqBO;
import com.ohaotian.authority.area.bo.SelectAreaTreeReqBO;
import com.ohaotian.authority.area.service.SelectAreaByParentAreaIdService;
import com.ohaotian.authority.area.service.SelectAreaTreeByParentIdService;
import com.ohaotian.authority.user.bo.SelectUserInfoRspBO;
import com.ohaotian.authority.user.bo.UserIdBO;
import com.ohaotian.authority.user.service.SelectUserDetailService;
import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.security.entity.UserInfo;
import com.ohaotian.plugin.security.utils.SecurityHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/area"}, method={RequestMethod.GET, RequestMethod.POST})
public class AreaController {
    private static final Logger logger = LoggerFactory.getLogger(AreaController.class);
    @Autowired
    private SelectAreaTreeByParentIdService selectAreaTreeByParentIdService;
    @Autowired
    private SelectAreaByParentAreaIdService selectAreaByParentAreaIdService;
    @Autowired
    private SelectUserDetailService selectUserDetailService;

    @RequestMapping(value={"/selectAreaTree"})
    @BusiResponseBody
    public Object selectAreaTree(SelectAreaTreeReqBO selectAreaTreeReqBO) {
        logger.info("AreaController::selectAreaTreeReqBO.getDefaultQryFlag=" + selectAreaTreeReqBO.getDefaultQryFlag());
        logger.info("AreaController::selectAreaTreeReqBO.getProvinceCode=" + selectAreaTreeReqBO.getProvinceCode());
        logger.info("AreaController::selectAreaTreeReqBO.getCityCode=" + selectAreaTreeReqBO.getCityCode());
        logger.info("AreaController::selectAreaTreeReqBO.getDistrictCode=" + selectAreaTreeReqBO.getDistrictCode());
        UserInfo currentUser = SecurityHelper.getCurrentUser();
        UserIdBO userIdBO = new UserIdBO();
        userIdBO.setUserId(currentUser.getUserId());
        SelectUserInfoRspBO selectUserInfoRspBO = this.selectUserDetailService.selectUserDetailByUserId(userIdBO);
        if (selectUserInfoRspBO.getProvinceCode() != null && !selectUserInfoRspBO.getProvinceCode().equals("")) {
            selectAreaTreeReqBO.setmProvince(selectUserInfoRspBO.getProvinceCode());
        }
        if (selectUserInfoRspBO.getCityCode() != null && !selectUserInfoRspBO.getCityCode().equals("")) {
            selectAreaTreeReqBO.setmCity(selectUserInfoRspBO.getCityCode());
        }
        if (selectUserInfoRspBO.getDistrictCode() != null && !selectUserInfoRspBO.getDistrictCode().equals("")) {
            selectAreaTreeReqBO.setmDistrict(selectUserInfoRspBO.getDistrictCode());
        }
        if (selectUserInfoRspBO.getUserLevel() != null && !selectUserInfoRspBO.getUserLevel().equals("")) {
            selectAreaTreeReqBO.setmUserLevel(selectUserInfoRspBO.getUserLevel());
        }
        return this.selectAreaTreeByParentIdService.selectAreaTree(selectAreaTreeReqBO);
    }

    @RequestMapping(value={"/selectArea"})
    @BusiResponseBody
    public Object selectArea(SelectAreaReqBO selectAreaReqBO) {
        return this.selectAreaByParentAreaIdService.selectAreaTree(selectAreaReqBO);
    }

    @RequestMapping(value={"/selectAreaByOrgType"})
    @BusiResponseBody
    public Object selectAreaByUserLevel(SelectAreaByOrgType selectAreaByOrgType) {
        UserInfo currentUser = SecurityHelper.getCurrentUser();
        UserIdBO userIdBO = new UserIdBO();
        userIdBO.setUserId(currentUser.getUserId());
        SelectUserInfoRspBO selectUserInfoRspBO = this.selectUserDetailService.selectUserDetailByUserId(userIdBO);
        if (selectUserInfoRspBO.getProvinceCode() != null && !selectUserInfoRspBO.getProvinceCode().equals("")) {
            selectAreaByOrgType.setmProvince(selectUserInfoRspBO.getProvinceCode());
        }
        return this.selectAreaTreeByParentIdService.selectAreaByOrgType(selectAreaByOrgType);
    }
}

