/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.controller.customer;

import com.ohaotian.authority.customer.bo.CustomerByIdReqBO;
import com.ohaotian.authority.customer.bo.CustomerInfoReqBO;
import com.ohaotian.authority.customer.bo.SearchCustomerInfoByConditionReqBO;
import com.ohaotian.authority.customer.bo.SelectCustomerByUserInfoReqBO;
import com.ohaotian.authority.customer.service.AddCustomerService;
import com.ohaotian.authority.customer.service.DeleteCustomerService;
import com.ohaotian.authority.customer.service.ReopenCustomerService;
import com.ohaotian.authority.customer.service.SelectAllCustomerService;
import com.ohaotian.authority.customer.service.SelectCustomerByUserInfoService;
import com.ohaotian.authority.customer.service.SelectCustomerDetailService;
import com.ohaotian.authority.customer.service.SelectSearchByCustomerInfoService;
import com.ohaotian.authority.customer.service.StopCustomerService;
import com.ohaotian.authority.customer.service.UpdateCustomerService;
import com.ohaotian.authority.log.BussinessLog;
import com.ohaotian.authority.user.bo.SelectUserInfoRspBO;
import com.ohaotian.authority.user.bo.UserIdBO;
import com.ohaotian.authority.user.service.SelectUserDetailService;
import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.security.entity.UserInfo;
import com.ohaotian.plugin.security.utils.SecurityHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/customer"}, method={RequestMethod.GET, RequestMethod.POST})
public class CustomerController {
    @Autowired
    private AddCustomerService addCustomerService;
    @Autowired
    private UpdateCustomerService updateCustomerService;
    @Autowired
    private DeleteCustomerService deleteCustomerService;
    @Autowired
    private ReopenCustomerService reopenCustomerService;
    @Autowired
    private StopCustomerService stopCustomerService;
    @Autowired
    private SelectCustomerDetailService selectCustomerDetailService;
    @Autowired
    private SelectSearchByCustomerInfoService selectSearchByCustomerInfoService;
    @Autowired
    private SelectCustomerByUserInfoService selectCustomerByUserInfoService;
    @Autowired
    private SelectAllCustomerService selectAllCustomerService;
    @Autowired
    private SelectUserDetailService selectUserDetailService;

    @RequestMapping(value={"/selectAll"})
    @BusiResponseBody
    public Object selectAll() {
        return this.selectAllCustomerService.selectAllCustomer();
    }

    @RequestMapping(value={"/selectCustomerByUserInfo"})
    @BusiResponseBody
    public Object selectCustomerByUserInfo(SelectCustomerByUserInfoReqBO selectCustomerByUserInfoReqBO) {
        return this.selectCustomerByUserInfoService.selectCustomerByUserInfo(selectCustomerByUserInfoReqBO);
    }

    @RequestMapping(value={"/selectCustomerByCondition"})
    @BusiResponseBody
    public Object selectCustomerByCondition(SearchCustomerInfoByConditionReqBO searchCustomerInfoByConditionReqBO) {
        return this.selectSearchByCustomerInfoService.selectSearchByCustomerInfo(searchCustomerInfoByConditionReqBO);
    }

    @RequestMapping(value={"/selectCustomerById"})
    @BusiResponseBody
    public Object selectCustomerById(CustomerByIdReqBO customerByIdReqBO) {
        return this.selectCustomerDetailService.selectCustomerDetail(customerByIdReqBO);
    }

    @RequestMapping(value={"/stop"})
    @BusiResponseBody
    @BussinessLog(module="\u5ba2\u6237\u7ba1\u7406", operat="\u505c\u7528")
    public Object stopCustomer(CustomerByIdReqBO customerByIdReqBO) {
        return this.stopCustomerService.stopCustomer(customerByIdReqBO);
    }

    @RequestMapping(value={"/reopen"})
    @BusiResponseBody
    @BussinessLog(module="\u5ba2\u6237\u7ba1\u7406", operat="\u542f\u7528")
    public Object reopenCustomer(CustomerByIdReqBO customerByIdReqBO) {
        return this.reopenCustomerService.reopenCustomer(customerByIdReqBO);
    }

    @RequestMapping(value={"/delete"})
    @BusiResponseBody
    @BussinessLog(module="\u5ba2\u6237\u7ba1\u7406", operat="\u5220\u9664")
    public Object deleteCustomer(CustomerByIdReqBO customerByIdReqBO) {
        return this.deleteCustomerService.deleteCustomer(customerByIdReqBO);
    }

    @RequestMapping(value={"/update"})
    @BusiResponseBody
    @BussinessLog(module="\u5ba2\u6237\u7ba1\u7406", operat="\u4fee\u6539")
    public Object updateCustomer(CustomerInfoReqBO customerInfoReqBO) {
        UserInfo currentUser = SecurityHelper.getCurrentUser();
        UserIdBO userIdBO = new UserIdBO();
        userIdBO.setUserId(currentUser.getUserId());
        SelectUserInfoRspBO selectUserInfoRspBO = this.selectUserDetailService.selectUserDetailByUserId(userIdBO);
        customerInfoReqBO.setmUserId(selectUserInfoRspBO.getUserId());
        return this.updateCustomerService.updateCustomer(customerInfoReqBO);
    }

    @RequestMapping(value={"/add"})
    @BusiResponseBody
    @BussinessLog(module="\u5ba2\u6237\u7ba1\u7406", operat="\u65b0\u589e")
    public Object addCustomer(CustomerInfoReqBO customerInfoReqBO) {
        UserInfo currentUser = SecurityHelper.getCurrentUser();
        UserIdBO userIdBO = new UserIdBO();
        userIdBO.setUserId(currentUser.getUserId());
        SelectUserInfoRspBO selectUserInfoRspBO = this.selectUserDetailService.selectUserDetailByUserId(userIdBO);
        customerInfoReqBO.setmUserId(selectUserInfoRspBO.getUserId());
        customerInfoReqBO.setProvinceCode(selectUserInfoRspBO.getProvinceCode());
        customerInfoReqBO.setCityCode(selectUserInfoRspBO.getCityCode());
        customerInfoReqBO.setDistrictCode(selectUserInfoRspBO.getDistrictCode());
        return this.addCustomerService.addCustomer(customerInfoReqBO);
    }
}

