/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.controller.infopay;

import com.ohaotian.authority.log.BussinessLog;
import com.ohaotian.authority.pay.bo.BelongOrgReqBO;
import com.ohaotian.authority.pay.bo.InfoPayBO;
import com.ohaotian.authority.pay.bo.PayIdReqBO;
import com.ohaotian.authority.pay.bo.PaySearchPageReqBO;
import com.ohaotian.authority.pay.service.CreateInfoPayService;
import com.ohaotian.authority.pay.service.DeleteInfoPayService;
import com.ohaotian.authority.pay.service.ReopenInfoPayService;
import com.ohaotian.authority.pay.service.SearchInfoPayService;
import com.ohaotian.authority.pay.service.SelectInfoPayByIdService;
import com.ohaotian.authority.pay.service.SelectPayListByOrgIdService;
import com.ohaotian.authority.pay.service.StopInfoPayService;
import com.ohaotian.authority.pay.service.UpdateInfoPayService;
import com.ohaotian.authority.user.bo.SelectUserInfoRspBO;
import com.ohaotian.authority.user.bo.UserIdBO;
import com.ohaotian.authority.user.service.SelectUserDetailService;
import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.security.entity.UserInfo;
import com.ohaotian.plugin.security.utils.SecurityHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/infopay"}, method={RequestMethod.GET, RequestMethod.POST})
public class InfoPayController {
    private static final Logger logger = LoggerFactory.getLogger(InfoPayController.class);
    @Autowired
    private CreateInfoPayService createInfoPayService;
    @Autowired
    private SearchInfoPayService searchInfoPayService;
    @Autowired
    private SelectInfoPayByIdService selectInfoPayByIdService;
    @Autowired
    private SelectPayListByOrgIdService selectPayListByOrgIdService;
    @Autowired
    private StopInfoPayService stopInfoPayService;
    @Autowired
    private ReopenInfoPayService reopenInfoPayService;
    @Autowired
    private UpdateInfoPayService updateInfoPayService;
    @Autowired
    private DeleteInfoPayService deleteInfoPayService;
    @Autowired
    private SelectUserDetailService selectUserDetailService;

    @RequestMapping(value={"/createInfoPay"})
    @BusiResponseBody
    @BussinessLog(module="\u8d26\u6237\u4fe1\u606f\u7ba1\u7406", operat="\u65b0\u589e")
    public Object createInfoPay(InfoPayBO infoPayBO) {
        return this.createInfoPayService.createInfoPay(infoPayBO);
    }

    @RequestMapping(value={"/searchInfoPay"})
    @BusiResponseBody
    public Object searchInfoPay(PaySearchPageReqBO paySearchPageReqBO) {
        logger.info("paySearchPageReqBO.getBelongOrgId()=" + paySearchPageReqBO.getBelongOrgId());
        if (paySearchPageReqBO.getBelongOrgId() == null || "".equals(paySearchPageReqBO.getBelongOrgId()) || paySearchPageReqBO.getBelongOrgId() == 0L) {
            UserInfo currentUser = SecurityHelper.getCurrentUser();
            UserIdBO userIdBO = new UserIdBO();
            userIdBO.setUserId(currentUser.getUserId());
            SelectUserInfoRspBO selectUserInfoRspBO = this.selectUserDetailService.selectUserDetailByUserId(userIdBO);
            paySearchPageReqBO.setBelongOrgId(selectUserInfoRspBO.getOrgId());
        }
        return this.searchInfoPayService.selectSearchPay(paySearchPageReqBO);
    }

    @RequestMapping(value={"/selectInfoPayById"})
    @BusiResponseBody
    public Object selectInfoPayById(PayIdReqBO payIdReqBO) {
        return this.selectInfoPayByIdService.selectInfoPayById(payIdReqBO);
    }

    @RequestMapping(value={"/selectInfoPayByOrgId"})
    @BusiResponseBody
    public Object selectInfoPayByOrgId(BelongOrgReqBO belongOrgReqBO) {
        return this.selectPayListByOrgIdService.selectInfoPayByOrgId(belongOrgReqBO);
    }

    @RequestMapping(value={"/stopInfoPayByPayId"})
    @BusiResponseBody
    @BussinessLog(module="\u8d26\u6237\u4fe1\u606f\u7ba1\u7406", operat="\u505c\u7528")
    public Object stopInfoPayByPayId(PayIdReqBO payIdReqBO) {
        return this.stopInfoPayService.stopInfoPayByPayId(payIdReqBO);
    }

    @RequestMapping(value={"/reopenInfoPayByPayId"})
    @BusiResponseBody
    @BussinessLog(module="\u8d26\u6237\u4fe1\u606f\u7ba1\u7406", operat="\u542f\u7528")
    public Object reopenInfoPayByPayId(PayIdReqBO payIdReqBO) {
        return this.reopenInfoPayService.reopenInfoPayByPayId(payIdReqBO);
    }

    @RequestMapping(value={"/updateInfoPay"})
    @BusiResponseBody
    @BussinessLog(module="\u8d26\u6237\u4fe1\u606f\u7ba1\u7406", operat="\u7f16\u8f91")
    public Object updateInfoPay(InfoPayBO infoPayBO) {
        return this.updateInfoPayService.updateInfoPay(infoPayBO);
    }

    @RequestMapping(value={"/deleteInfoPay"})
    @BusiResponseBody
    @BussinessLog(module="\u8d26\u6237\u4fe1\u606f\u7ba1\u7406", operat="\u5220\u9664")
    public Object deleteInfoPay(PayIdReqBO payIdReqBO) {
        return this.deleteInfoPayService.deleteInfoPay(payIdReqBO);
    }
}

