/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.controller.role;

import com.alibaba.fastjson.JSON;
import com.ohaotian.authority.cached.bo.CachedReqBO;
import com.ohaotian.authority.cached.service.QryAuthorityEscapeBusiService;
import com.ohaotian.authority.config.bo.AddConfigInfoReqBo;
import com.ohaotian.authority.config.bo.ConfigInfoBO;
import com.ohaotian.authority.config.bo.DeleteConfigInfoReqBO;
import com.ohaotian.authority.config.bo.SelectConfigInfoReqBO;
import com.ohaotian.authority.config.bo.SelectConfigInfoRspBO;
import com.ohaotian.authority.config.bo.SelectInfoByConfigReqBO;
import com.ohaotian.authority.config.bo.SelectInfoByConfigRspBO;
import com.ohaotian.authority.config.bo.UpdateInfoByConfigReqBO;
import com.ohaotian.authority.config.service.AddConfigInfoService;
import com.ohaotian.authority.config.service.DeleteConfigInfoService;
import com.ohaotian.authority.config.service.SelectConfigInfoService;
import com.ohaotian.authority.config.service.UpdateConfigInfoService;
import com.ohaotian.authority.constant.Constants;
import com.ohaotian.authority.organisation.bo.POrdIdBO;
import com.ohaotian.authority.organisation.bo.TreePathRspBO;
import com.ohaotian.authority.organisation.bo.TreePathRspBOS;
import com.ohaotian.authority.organisation.service.SelectOrgTreePathService;
import com.ohaotian.authority.role.bo.CreatRoleReqBO;
import com.ohaotian.authority.role.bo.DeleteRoleReqBO;
import com.ohaotian.authority.role.bo.FilterRoleLevelReqBO;
import com.ohaotian.authority.role.bo.HasAllUserListBO;
import com.ohaotian.authority.role.bo.HasUserListBO;
import com.ohaotian.authority.role.bo.OrgBO;
import com.ohaotian.authority.role.bo.RoleStatusReqBO;
import com.ohaotian.authority.role.bo.SaveOrgGrantUsersReqBO;
import com.ohaotian.authority.role.bo.SaveRoleConfigMenusReqBO;
import com.ohaotian.authority.role.bo.SaveRoleOrgsReqBO;
import com.ohaotian.authority.role.bo.SelectAlreadyAndNorUsersReqBO;
import com.ohaotian.authority.role.bo.SelectOrgDistributeRspBO;
import com.ohaotian.authority.role.bo.SelectRoleByIdReqBO;
import com.ohaotian.authority.role.bo.SelectRolesPageReqBO;
import com.ohaotian.authority.role.bo.UpdateRoleByIDReqBO;
import com.ohaotian.authority.role.service.CreatRoleBusiService;
import com.ohaotian.authority.role.service.DeleteRoleBusiService;
import com.ohaotian.authority.role.service.FilterRoleLevelService;
import com.ohaotian.authority.role.service.RestartRoleByIdBusiService;
import com.ohaotian.authority.role.service.SaveOrgGrantUsersBusiService;
import com.ohaotian.authority.role.service.SaveRoleConfigMenusBusiService;
import com.ohaotian.authority.role.service.SaveRoleOrgsService;
import com.ohaotian.authority.role.service.SelectAllUserByRoleId;
import com.ohaotian.authority.role.service.SelectAlreadyUser;
import com.ohaotian.authority.role.service.SelectHasOrgsByRoleService;
import com.ohaotian.authority.role.service.SelectOverAllRolesPageService;
import com.ohaotian.authority.role.service.SelectRoleByIdBusiService;
import com.ohaotian.authority.role.service.SelectRolesByOrgPageService;
import com.ohaotian.authority.role.service.SelectRolesPageBusiService;
import com.ohaotian.authority.role.service.SelectTenantRolesPageService;
import com.ohaotian.authority.role.service.StopRoleByIdBusiService;
import com.ohaotian.authority.role.service.UpdateRoleByIDBusiService;
import com.ohaotian.authority.user.bo.SaveUserAuthReqBO;
import com.ohaotian.authority.user.bo.SelectUserInfoRspBO;
import com.ohaotian.authority.user.bo.UserIdBO;
import com.ohaotian.authority.user.service.SaveRoleAuthService;
import com.ohaotian.authority.user.service.SelectUserDetailService;
import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.security.entity.UserInfo;
import com.ohaotian.plugin.security.utils.SecurityHelper;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/role"}, method={RequestMethod.GET, RequestMethod.POST})
public class RoleController {
    private static final Logger logger = LoggerFactory.getLogger(RoleController.class);
    @Autowired
    private CreatRoleBusiService creatRoleBusiService;
    @Autowired
    private StopRoleByIdBusiService stopRoleByIdBusiService;
    @Autowired
    private RestartRoleByIdBusiService restartRoleByIdBusiService;
    @Autowired
    private UpdateRoleByIDBusiService updateRoleByIDBusiService;
    @Autowired
    private SelectRoleByIdBusiService selectRoleByIdBusiService;
    @Autowired
    private SelectRolesPageBusiService selectRolesPageBusiService;
    @Autowired
    private SelectAllUserByRoleId selectAllUserByRoleId;
    @Autowired
    private SelectAlreadyUser selectAlreadyUser;
    @Autowired
    private SaveOrgGrantUsersBusiService saveOrgGrantUsersBusiService;
    @Autowired
    private SelectHasOrgsByRoleService selectHasOrgsByRoleService;
    @Autowired
    private SaveRoleOrgsService saveRoleOrgsService;
    @Autowired
    private SelectOrgTreePathService selectOrgTreePathService;
    @Autowired
    private SaveRoleAuthService saveRoleAuthService;
    @Autowired
    private SaveRoleConfigMenusBusiService saveRoleConfigMenusBusiService;
    @Autowired
    private DeleteRoleBusiService deleteRoleBusiService;
    @Autowired
    private SelectOverAllRolesPageService selectOverAllRolesPageService;
    @Autowired
    private SelectTenantRolesPageService selectTenantRolesPageService;
    @Autowired
    private SelectConfigInfoService selectConfigInfoService;
    @Autowired
    private UpdateConfigInfoService updateConfigInfoService;
    @Autowired
    private AddConfigInfoService addConfigInfoService;
    @Autowired
    private DeleteConfigInfoService deleteConfigInfoService;
    @Autowired
    private SelectRolesByOrgPageService selectRolesByOrgPageService;
    @Autowired
    private QryAuthorityEscapeBusiService qryAuthorityEscapeBusiService;
    @Autowired
    private SelectUserDetailService selectUserDetailService;
    @Autowired
    private FilterRoleLevelService filterRoleLevelService;

    @RequestMapping(value={"/alreadyAndNorUsers"})
    @BusiResponseBody
    public Object getAlreadyAndNorUsers(SelectAlreadyAndNorUsersReqBO reqBO) {
        if (reqBO.getOrgId() == null || reqBO.getRoleId() == null) {
            throw new ZTBusinessException("\u89d2\u8272id\u6216\u673a\u6784id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HasUserListBO hasAllUserListBO = this.selectAllUserByRoleId.selectAllUserByRoleId(reqBO);
        List allUser = hasAllUserListBO.getAllUser();
        HasUserListBO hasUserListBO = this.selectAlreadyUser.selectAlreadyDistributeUser(reqBO);
        List user = hasUserListBO.getAllUser();
        allUser.removeAll(user);
        SelectOrgDistributeRspBO orgDistributeRspBO = new SelectOrgDistributeRspBO();
        orgDistributeRspBO.setHasGrantRoles(user);
        orgDistributeRspBO.setNotGrantRoles(allUser);
        return orgDistributeRspBO;
    }

    @RequestMapping(value={"/commit"})
    @BusiResponseBody
    public Object commit(SaveOrgGrantUsersReqBO reqBO) {
        this.saveOrgGrantUsersBusiService.saveOrgGrantUsers(reqBO);
        return null;
    }

    @RequestMapping(value={"/alreadyAndNorOrg"})
    @BusiResponseBody
    public Object getAlreadyAndNorOrg(SelectAlreadyAndNorUsersReqBO reqBO) {
        POrdIdBO pOrdIdBO = new POrdIdBO();
        pOrdIdBO.setParentId(reqBO.getOrgId());
        LinkedList<OrgBO> allOrgs = new LinkedList<OrgBO>();
        TreePathRspBOS treePathRspBOS = this.selectOrgTreePathService.selectOrgTreePath(pOrdIdBO);
        if (treePathRspBOS != null && treePathRspBOS.getTreePathRspBOList() != null && treePathRspBOS.getTreePathRspBOList().size() > 0) {
            for (TreePathRspBO bo : treePathRspBOS.getTreePathRspBOList()) {
                OrgBO orgBO = new OrgBO();
                orgBO.setOrgId(bo.getOrganisationId());
                orgBO.setTitle(bo.getTitle());
                orgBO.setOrgTreePath(bo.getOrgTreePath());
                allOrgs.add(orgBO);
            }
        }
        HasAllUserListBO hasOrgsByRole = this.selectHasOrgsByRoleService.getHasOrgsByRole(reqBO);
        List hasOrgs = hasOrgsByRole.getAllUser();
        allOrgs.removeAll(hasOrgs);
        SelectOrgDistributeRspBO orgDistributeRspBO = new SelectOrgDistributeRspBO();
        orgDistributeRspBO.setHasGrantRoles(hasOrgs);
        orgDistributeRspBO.setNotGrantRoles(allOrgs);
        return orgDistributeRspBO;
    }

    @RequestMapping(value={"/orgCommit"})
    @BusiResponseBody
    public Object orgCommit(SaveRoleOrgsReqBO reqBO) {
        this.saveRoleOrgsService.saveRoleOrgs(reqBO);
        return null;
    }

    @PostMapping(value={"/creatRole"})
    @BusiResponseBody
    public Object creatRole(CreatRoleReqBO creatRoleReqBO) throws Exception {
        UserInfo currentUser = SecurityHelper.getCurrentUser();
        UserIdBO userIdBO = new UserIdBO();
        userIdBO.setUserId(currentUser.getUserId());
        SelectUserInfoRspBO selectUserInfoRspBO = this.selectUserDetailService.selectUserDetailByUserId(userIdBO);
        creatRoleReqBO.setUserLevel(selectUserInfoRspBO.getUserLevel());
        creatRoleReqBO.setUserOrgId(selectUserInfoRspBO.getOrgId());
        creatRoleReqBO.setProvinceCode(selectUserInfoRspBO.getProvinceCode());
        creatRoleReqBO.setProvinceName(selectUserInfoRspBO.getProvinceName());
        creatRoleReqBO.setCityCode(selectUserInfoRspBO.getCityCode());
        creatRoleReqBO.setCityName(selectUserInfoRspBO.getCityName());
        creatRoleReqBO.setDistrictCode(selectUserInfoRspBO.getDistrictCode());
        creatRoleReqBO.setDistrictName(selectUserInfoRspBO.getDistrictName());
        creatRoleReqBO.setTenantIdReq(selectUserInfoRspBO.getTenantId());
        if (selectUserInfoRspBO.getField2() != null && !"".equals(selectUserInfoRspBO.getField2())) {
            creatRoleReqBO.setUserStoreId(Long.valueOf(Long.parseLong(selectUserInfoRspBO.getField2())));
        }
        if (SecurityHelper.hasAuthority((String)"auth:system:manage")) {
            if (creatRoleReqBO.getTenantIdReq() == null) {
                creatRoleReqBO.setRoleType(Constants.ORG_TYPE_OVERALL);
            } else {
                creatRoleReqBO.setRoleType(Constants.ORG_TYPE_TENANT);
            }
        } else if (SecurityHelper.hasAuthority((String)"auth:overall:manage")) {
            if (creatRoleReqBO.getTenantIdReq() == null) {
                creatRoleReqBO.setRoleType(Constants.ORG_TYPE_PART);
            } else {
                creatRoleReqBO.setRoleType(Constants.ORG_TYPE_TENANT);
            }
        } else if (SecurityHelper.hasAuthority((String)"auth:tenant:manage")) {
            creatRoleReqBO.setRoleType(Constants.ORG_TYPE_TENANT);
        } else if (SecurityHelper.hasAuthority((String)"auth:org:manage")) {
            creatRoleReqBO.setRoleType(Constants.ORG_TYPE_TENANT);
        }
        if (creatRoleReqBO.getTenantId() != null) {
            creatRoleReqBO.setRoleType(Constants.ORG_TYPE_TENANT);
        }
        this.creatRoleBusiService.creatRole(creatRoleReqBO);
        return null;
    }

    @PostMapping(value={"/stop"})
    @BusiResponseBody
    public Object stopRole(RoleStatusReqBO roleStatusReqBO) {
        this.stopRoleByIdBusiService.stopRoleById(roleStatusReqBO);
        return null;
    }

    @PostMapping(value={"/restart"})
    @BusiResponseBody
    public Object restartRole(RoleStatusReqBO roleStatusReqBO) {
        this.restartRoleByIdBusiService.restartRoleById(roleStatusReqBO);
        return null;
    }

    @PostMapping(value={"/selectRole"})
    @BusiResponseBody
    public Object selectRole(SelectRoleByIdReqBO selectRoleByIdReqBO) {
        return this.selectRoleByIdBusiService.selectRoleById(selectRoleByIdReqBO);
    }

    @PostMapping(value={"/updateRole"})
    @BusiResponseBody
    public Object updateRole(UpdateRoleByIDReqBO updateRoleByIDReqBO) throws Exception {
        logger.info("\u89d2\u8272\u4fee\u6539\u5165\u53c2\uff1a" + JSON.toJSONString((Object)updateRoleByIDReqBO));
        this.updateRoleByIDBusiService.updateRoleByID(updateRoleByIDReqBO);
        return null;
    }

    @RequestMapping(value={"/selectRoles"})
    @BusiResponseBody
    public RspPage<Map<String, Object>> selectRoles(SelectRolesPageReqBO rolesPageReqBO) {
        logger.info("RoleController:/selectRoles:begin");
        logger.info("RoleController:SecurityHelper.hasAuthority(PermissionConstants.SYSTEM_ADMIN_CODE)" + SecurityHelper.hasAuthority((String)"auth:system:manage"));
        logger.info("RoleController:SecurityHelper.hasAuthority(PermissionConstants.OVERALL_ADMIN_CODE)" + SecurityHelper.hasAuthority((String)"auth:overall:manage"));
        logger.info("RoleController:SecurityHelper.hasAuthority(PermissionConstants.TENANT_ADMIN_CODE)" + SecurityHelper.hasAuthority((String)"auth:tenant:manage"));
        logger.info("RoleController:SecurityHelper.hasAuthority(PermissionConstants.TENANT_ADMIN_CODE)" + SecurityHelper.hasAuthority((String)"auth:org:manage"));
        if (SecurityHelper.hasAuthority((String)"auth:system:manage")) {
            return this.selectRolesPageBusiService.selectRolesPage(rolesPageReqBO);
        }
        if (SecurityHelper.hasAuthority((String)"auth:overall:manage")) {
            return this.selectOverAllRolesPageService.selectOverAllRolesPage(rolesPageReqBO);
        }
        if (SecurityHelper.hasAuthority((String)"auth:tenant:manage")) {
            logger.info("TENANT_ADMIN_CODE:selectTenantRolesPage begin");
            logger.info("TENANT_ADMIN_CODE:selectTenantRolesPage rolesPageReqBO.getTenantId()=" + rolesPageReqBO.getTenantId());
            return this.selectTenantRolesPageService.selectTenantRolesPage(rolesPageReqBO);
        }
        if (SecurityHelper.hasAuthority((String)"auth:org:manage")) {
            UserInfo currentUser = SecurityHelper.getCurrentUser();
            UserIdBO userIdBO = new UserIdBO();
            userIdBO.setUserId(currentUser.getUserId());
            SelectUserInfoRspBO selectUserInfoRspBO = this.selectUserDetailService.selectUserDetailByUserId(userIdBO);
            LinkedList<String> roleLevels = new LinkedList<String>();
            if ("2".equals(selectUserInfoRspBO.getUserLevel())) {
                roleLevels.add("01");
                roleLevels.add("02");
                roleLevels.add("03");
            } else if ("3".equals(selectUserInfoRspBO.getUserLevel())) {
                roleLevels.add("02");
                roleLevels.add("03");
            } else if ("4".equals(selectUserInfoRspBO.getUserLevel())) {
                roleLevels.add("03");
            } else if ("5".equals(selectUserInfoRspBO.getUserLevel())) {
                roleLevels.add("03");
            }
            rolesPageReqBO.setRoleLevels(roleLevels);
            rolesPageReqBO.setOrgId(selectUserInfoRspBO.getOrgId());
            return this.selectRolesByOrgPageService.selectRoles(rolesPageReqBO);
        }
        logger.info("RoleController:/selectRoles:end");
        return null;
    }

    @RequestMapping(value={"/selectRoleIdAndRoleName"})
    @BusiResponseBody
    public Object selectRoleIdAndRoleName(FilterRoleLevelReqBO filterRoleLevelReqBO) {
        try {
            UserInfo currentUser = SecurityHelper.getCurrentUser();
            UserIdBO userIdBO = new UserIdBO();
            userIdBO.setUserId(currentUser.getUserId());
            SelectUserInfoRspBO selectUserInfoRspBO = this.selectUserDetailService.selectUserDetailByUserId(userIdBO);
            if (selectUserInfoRspBO != null) {
                if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)selectUserInfoRspBO.getProvinceCode())) {
                    filterRoleLevelReqBO.setmProvince(selectUserInfoRspBO.getProvinceCode());
                }
                if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)selectUserInfoRspBO.getCityCode())) {
                    filterRoleLevelReqBO.setmCity(selectUserInfoRspBO.getCityCode());
                }
                if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)selectUserInfoRspBO.getDistrictCode())) {
                    filterRoleLevelReqBO.setmDistrict(selectUserInfoRspBO.getDistrictCode());
                }
                if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)selectUserInfoRspBO.getField2())) {
                    filterRoleLevelReqBO.setmShopId(selectUserInfoRspBO.getField2());
                }
                if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)selectUserInfoRspBO.getOrgPath())) {
                    filterRoleLevelReqBO.setOrgPath(selectUserInfoRspBO.getOrgPath());
                }
                if (null != selectUserInfoRspBO.getTenantId()) {
                    filterRoleLevelReqBO.setmTenantId(selectUserInfoRspBO.getTenantId());
                }
            }
        }
        catch (Exception e) {
            logger.error("controller--------", (Throwable)e);
            throw new ZTBusinessException("selectRoleIdAndRoleName\u5931\u8d25\uff01");
        }
        return this.filterRoleLevelService.selectRoleByLongUser(filterRoleLevelReqBO);
    }

    @RequestMapping(value={"/selectConfigs"})
    @BusiResponseBody
    public RspPage<ConfigInfoBO> selectConfigs(SelectConfigInfoReqBO configInfoReqBO) {
        if (SecurityHelper.hasAuthority((String)"auth:system:manage") || SecurityHelper.hasAuthority((String)"auth:overall:manage") || SecurityHelper.hasAuthority((String)"auth:tenant:manage")) {
            return this.selectConfigInfoService.selectConfigInfo(configInfoReqBO);
        }
        return null;
    }

    @RequestMapping(value={"/selectConfigById"})
    @BusiResponseBody
    public SelectConfigInfoRspBO selectConfigById(SelectConfigInfoReqBO configInfoReqBO) {
        if (SecurityHelper.hasAuthority((String)"auth:system:manage") || SecurityHelper.hasAuthority((String)"auth:overall:manage") || SecurityHelper.hasAuthority((String)"auth:tenant:manage")) {
            return this.selectConfigInfoService.selectConfigInfoById(configInfoReqBO);
        }
        return null;
    }

    @RequestMapping(value={"/selectConfigByName"})
    @BusiResponseBody
    public RspPage<ConfigInfoBO> selectConfigInfoByName(SelectConfigInfoReqBO configInfoReqBO) {
        if (SecurityHelper.hasAuthority((String)"auth:system:manage") || SecurityHelper.hasAuthority((String)"auth:overall:manage") || SecurityHelper.hasAuthority((String)"auth:tenant:manage")) {
            return this.selectConfigInfoService.selectConfigInfoByName(configInfoReqBO);
        }
        return null;
    }

    @RequestMapping(value={"/selectConfigInfo"})
    @BusiResponseBody
    public SelectInfoByConfigRspBO selectConfigsByShopId(SelectInfoByConfigReqBO selectInfoByConfigReqBO) {
        if (SecurityHelper.hasAuthority((String)"auth:system:manage") || SecurityHelper.hasAuthority((String)"auth:overall:manage") || SecurityHelper.hasAuthority((String)"auth:tenant:manage")) {
            return this.selectConfigInfoService.selectConfigInfoByShopId(selectInfoByConfigReqBO);
        }
        return null;
    }

    @RequestMapping(value={"/updateConfigInfoByShopId"})
    @BusiResponseBody
    public Object updateConfigsByShopId(UpdateInfoByConfigReqBO updateInfoByConfigReqBO) {
        if (SecurityHelper.hasAuthority((String)"auth:system:manage") || SecurityHelper.hasAuthority((String)"auth:overall:manage") || SecurityHelper.hasAuthority((String)"auth:tenant:manage")) {
            this.updateConfigInfoService.updateConfigInfoByShopId(updateInfoByConfigReqBO);
        }
        return null;
    }

    @RequestMapping(value={"/addConfigInfo"})
    @BusiResponseBody
    public Object addConfigInfo(AddConfigInfoReqBo addConfigInfoReqBo) {
        if (SecurityHelper.hasAuthority((String)"auth:system:manage") || SecurityHelper.hasAuthority((String)"auth:overall:manage") || SecurityHelper.hasAuthority((String)"auth:tenant:manage")) {
            if (addConfigInfoReqBo == null || addConfigInfoReqBo.getConfigName() == null || "".equals(addConfigInfoReqBo.getConfigName()) || addConfigInfoReqBo.getConfigCode() == null || "".equals(addConfigInfoReqBo.getConfigCode())) {
                throw new ZTBusinessException("\u8bf7\u91cd\u65b0\u8f93\u5165");
            }
            this.addConfigInfoService.AddConfigInfo(addConfigInfoReqBo);
        }
        return null;
    }

    @RequestMapping(value={"/updateConfigInfo"})
    @BusiResponseBody
    public Object updateConfigInfo(AddConfigInfoReqBo updateConfigInfoReqBo) {
        if (SecurityHelper.hasAuthority((String)"auth:system:manage") || SecurityHelper.hasAuthority((String)"auth:overall:manage") || SecurityHelper.hasAuthority((String)"auth:tenant:manage")) {
            this.addConfigInfoService.updateConfigInfo(updateConfigInfoReqBo);
        }
        return null;
    }

    @RequestMapping(value={"/deleteConfigInfo"})
    @BusiResponseBody
    public Object deleteConfigInfo(DeleteConfigInfoReqBO deleteConfigInfoReqBO) {
        if (SecurityHelper.hasAuthority((String)"auth:system:manage") || SecurityHelper.hasAuthority((String)"auth:overall:manage") || SecurityHelper.hasAuthority((String)"auth:tenant:manage")) {
            this.deleteConfigInfoService.deleteConfigInfo(deleteConfigInfoReqBO);
        }
        return null;
    }

    @RequestMapping(value={"/authUserCommit"})
    @BusiResponseBody
    public Object authUserCommit(SaveUserAuthReqBO saveUserAuthReqBO) {
        if (StringUtils.isEmpty((Object)saveUserAuthReqBO.getJson())) {
            throw new ZTBusinessException("\u8bf7\u91cd\u65b0\u9009\u62e9");
        }
        this.saveRoleAuthService.saveRoleAuthService(saveUserAuthReqBO);
        return null;
    }

    @RequestMapping(value={"/configMenus"})
    @BusiResponseBody
    public Object configMenus(SaveRoleConfigMenusReqBO saveRoleConfigMenusReqBO) {
        this.saveRoleConfigMenusBusiService.saveRoleConfigMenus(saveRoleConfigMenusReqBO);
        return null;
    }

    @RequestMapping(value={"/delete"})
    @BusiResponseBody
    public Object delete(DeleteRoleReqBO deleteRoleReqBO) {
        this.deleteRoleBusiService.deleteRole(deleteRoleReqBO);
        return null;
    }

    @PostMapping(value={"/batchStop"})
    @BusiResponseBody
    public Object batchStopRoles(String roles) {
        List longList = JSON.parseArray((String)roles, Long.class);
        for (Long role : longList) {
            RoleStatusReqBO roleStatusReqBO = new RoleStatusReqBO();
            roleStatusReqBO.setRoleId(role);
            this.stopRoleByIdBusiService.stopRoleById(roleStatusReqBO);
        }
        return null;
    }

    @PostMapping(value={"/batchRestart"})
    @BusiResponseBody
    public Object restartRole(String roles) {
        List longList = JSON.parseArray((String)roles, Long.class);
        for (Long role : longList) {
            RoleStatusReqBO roleStatusReqBO = new RoleStatusReqBO();
            roleStatusReqBO.setRoleId(role);
            this.restartRoleByIdBusiService.restartRoleById(roleStatusReqBO);
        }
        return null;
    }

    @RequestMapping(value={"/selectUniversalDownBox"})
    @BusiResponseBody
    public Object selectUniversalDownBox(CachedReqBO cachedReqBO) {
        return this.qryAuthorityEscapeBusiService.listByTypeCode(cachedReqBO);
    }

    @RequestMapping(value={"/filterRoleLevel"})
    @BusiResponseBody
    public Object filterRoleLevel(FilterRoleLevelReqBO filterRoleLevelReqBO) {
        UserInfo currentUser = SecurityHelper.getCurrentUser();
        UserIdBO userIdBO = new UserIdBO();
        userIdBO.setUserId(currentUser.getUserId());
        SelectUserInfoRspBO selectUserInfoRspBO = this.selectUserDetailService.selectUserDetailByUserId(userIdBO);
        if (selectUserInfoRspBO != null) {
            if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)selectUserInfoRspBO.getProvinceCode())) {
                filterRoleLevelReqBO.setmProvince(selectUserInfoRspBO.getProvinceCode());
            }
            if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)selectUserInfoRspBO.getCityCode())) {
                filterRoleLevelReqBO.setmCity(selectUserInfoRspBO.getCityCode());
            }
            if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)selectUserInfoRspBO.getDistrictCode())) {
                filterRoleLevelReqBO.setmDistrict(selectUserInfoRspBO.getDistrictCode());
            }
            if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)selectUserInfoRspBO.getField2())) {
                filterRoleLevelReqBO.setmShopId(selectUserInfoRspBO.getField2());
            }
        }
        return this.filterRoleLevelService.filterRoleLevel(filterRoleLevelReqBO);
    }
}

