/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.controller.station;

import com.alibaba.fastjson.JSON;
import com.ohaotian.authority.station.bo.ChangeStatusByStationIdReqBO;
import com.ohaotian.authority.station.bo.DeleteByStationIdReqBO;
import com.ohaotian.authority.station.bo.RestartByStationIdReqBO;
import com.ohaotian.authority.station.bo.SaveStationReqBO;
import com.ohaotian.authority.station.bo.SelectStationByIdReqBO;
import com.ohaotian.authority.station.bo.SelectStationPageReqBO;
import com.ohaotian.authority.station.bo.UpdateStationByIdReqBO;
import com.ohaotian.authority.station.service.ChangeStatusByStationIdBusiService;
import com.ohaotian.authority.station.service.DeleteByStationIdBusiService;
import com.ohaotian.authority.station.service.RestartByStationIdBusiService;
import com.ohaotian.authority.station.service.SaveStationBusiService;
import com.ohaotian.authority.station.service.SelectStationByIdBusiService;
import com.ohaotian.authority.station.service.SelectStationsPageBusiByTowAdminService;
import com.ohaotian.authority.station.service.SelectStationsPageBusiService;
import com.ohaotian.authority.station.service.UpdateStationByIdBusiService;
import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.security.utils.SecurityHelper;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/station"}, method={RequestMethod.GET, RequestMethod.POST})
public class StationController {
    private Logger logger = LoggerFactory.getLogger(StationController.class);
    @Autowired
    private SelectStationsPageBusiService selectStationsPageBusiService;
    @Autowired
    private SelectStationByIdBusiService selectStationByIdBusiService;
    @Autowired
    private SaveStationBusiService saveStationBusiService;
    @Autowired
    private UpdateStationByIdBusiService updateStationByIdBusiService;
    @Autowired
    private ChangeStatusByStationIdBusiService changeStatusByStationIdBusiService;
    @Autowired
    private DeleteByStationIdBusiService deleteByStationIdBusiService;
    @Autowired
    private RestartByStationIdBusiService restartByStationIdBusiService;
    @Autowired
    private SelectStationsPageBusiByTowAdminService selectStationsPageBusiByTowAdminService;

    @RequestMapping(value={"/selectStationPage"})
    @BusiResponseBody
    public Object selectStationPage(SelectStationPageReqBO reqPageBO) {
        if (SecurityHelper.hasAuthority((String)"auth:system:manage") || SecurityHelper.hasAuthority((String)"auth:overall:manage")) {
            return this.selectStationsPageBusiService.selectstationPage(reqPageBO);
        }
        if (SecurityHelper.hasAuthority((String)"auth:tenant:manage")) {
            return this.selectStationsPageBusiByTowAdminService.selectStationPageByTwoAdmin(reqPageBO);
        }
        return null;
    }

    @RequestMapping(value={"/selectById"})
    @BusiResponseBody
    public Object selectById(SelectStationByIdReqBO selectStationByIdReqBO) {
        return this.selectStationByIdBusiService.selectStationById(selectStationByIdReqBO);
    }

    @RequestMapping(value={"/save"})
    @BusiResponseBody
    public Object save(SaveStationReqBO saveStationReqBO) {
        this.saveStationBusiService.saveStation(saveStationReqBO);
        return null;
    }

    @RequestMapping(value={"/update"})
    @BusiResponseBody
    public Object update(UpdateStationByIdReqBO updateStationByIdReqBO) {
        this.updateStationByIdBusiService.updateStationById(updateStationByIdReqBO);
        return null;
    }

    @RequestMapping(value={"/deleteByStationId"})
    @BusiResponseBody
    public Object deleteByStationId(String stationIds) {
        List longList = JSON.parseArray((String)stationIds, Long.class);
        ChangeStatusByStationIdReqBO changeStatusByStationIdReqBO = new ChangeStatusByStationIdReqBO();
        changeStatusByStationIdReqBO.setStationIds(longList);
        changeStatusByStationIdReqBO.setStatus(Integer.valueOf(1));
        this.changeStatusByStationIdBusiService.changeStatusByStationId(changeStatusByStationIdReqBO);
        return null;
    }

    @RequestMapping(value={"/phydeleteByStationId"})
    @BusiResponseBody
    public Object phydeleteByStationId(String stationIds) {
        List longList = JSON.parseArray((String)stationIds, Long.class);
        DeleteByStationIdReqBO deleteByStationIdReqBO = new DeleteByStationIdReqBO();
        deleteByStationIdReqBO.setStationIds(longList);
        this.deleteByStationIdBusiService.deleteByStationId(deleteByStationIdReqBO);
        return null;
    }

    @PostMapping(value={"/restartStation"})
    @BusiResponseBody
    public Object restartRole(RestartByStationIdReqBO restartByStationIdReqBO) {
        this.restartByStationIdBusiService.restartByStationId(restartByStationIdReqBO);
        return null;
    }

    @RequestMapping(value={"/listReOpenByStationId"})
    @BusiResponseBody
    public Object listReOpenByStationId(String stationIds) {
        List longList = JSON.parseArray((String)stationIds, Long.class);
        ChangeStatusByStationIdReqBO changeStatusByStationIdReqBO = new ChangeStatusByStationIdReqBO();
        changeStatusByStationIdReqBO.setStationIds(longList);
        changeStatusByStationIdReqBO.setStatus(Integer.valueOf(0));
        this.changeStatusByStationIdBusiService.changeStatusByStationId(changeStatusByStationIdReqBO);
        return null;
    }
}

