/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.controller.supplier;

import com.ohaotian.authority.log.BussinessLog;
import com.ohaotian.authority.supplier.bo.AddSupplierReqBO;
import com.ohaotian.authority.supplier.bo.SelectSearchBySupplierInfoReqBO;
import com.ohaotian.authority.supplier.bo.SelectSupplierReqBO;
import com.ohaotian.authority.supplier.bo.SupplierIdBO;
import com.ohaotian.authority.supplier.bo.UpdateSupplierReqBO;
import com.ohaotian.authority.supplier.service.AddSupplierService;
import com.ohaotian.authority.supplier.service.DeleteSupplierService;
import com.ohaotian.authority.supplier.service.ReopenSupplierService;
import com.ohaotian.authority.supplier.service.SelectSearchBySupplierInfoService;
import com.ohaotian.authority.supplier.service.SelectSupplierByAreaService;
import com.ohaotian.authority.supplier.service.SelectSupplierDetailService;
import com.ohaotian.authority.supplier.service.StopSupplierService;
import com.ohaotian.authority.supplier.service.UpdateSupplierService;
import com.ohaotian.authority.user.bo.SelectUserInfoRspBO;
import com.ohaotian.authority.user.bo.UserIdBO;
import com.ohaotian.authority.user.service.SelectUserDetailService;
import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.security.entity.UserInfo;
import com.ohaotian.plugin.security.utils.SecurityHelper;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/supplier"}, method={RequestMethod.GET, RequestMethod.POST})
public class SupplierController {
    private static final Logger logger = LoggerFactory.getLogger(SupplierController.class);
    @Autowired
    private SelectSupplierByAreaService selectSupplierByAreaService;
    @Autowired
    private AddSupplierService addSupplierService;
    @Autowired
    private UpdateSupplierService updateSupplierService;
    @Autowired
    private StopSupplierService stopSupplierService;
    @Autowired
    private ReopenSupplierService reopenSupplierService;
    @Autowired
    private SelectSearchBySupplierInfoService selectSearchBySupplierInfoService;
    @Autowired
    private SelectSupplierDetailService selectSupplierDetailService;
    @Autowired
    private SelectUserDetailService selectUserDetailService;
    @Autowired
    private DeleteSupplierService deleteSupplierService;

    @RequestMapping(value={"/selectByArea"})
    @BusiResponseBody
    public Object selectSupplierByAreaService(SelectSupplierReqBO selectSupplierReqBO) {
        return this.selectSupplierByAreaService.selectSupplierByArea(selectSupplierReqBO);
    }

    @RequestMapping(value={"/addSupplier"})
    @BusiResponseBody
    @BussinessLog(module="\u4f9b\u5e94\u5546\u7ba1\u7406", operat="\u65b0\u589e")
    public Object addSupplierService(AddSupplierReqBO addSupplierReqBO) {
        UserInfo currentUser = SecurityHelper.getCurrentUser();
        UserIdBO userIdBO = new UserIdBO();
        userIdBO.setUserId(currentUser.getUserId());
        SelectUserInfoRspBO selectUserInfoRspBO = this.selectUserDetailService.selectUserDetailByUserId(userIdBO);
        addSupplierReqBO.setmOrgId(selectUserInfoRspBO.getmOrgId().toString());
        addSupplierReqBO.setmTitle(selectUserInfoRspBO.getTitle());
        addSupplierReqBO.setmUserLevel(selectUserInfoRspBO.getUserLevel());
        addSupplierReqBO.setmUserId(selectUserInfoRspBO.getUserId());
        if (!StringUtils.isBlank((CharSequence)selectUserInfoRspBO.getProvinceCode())) {
            addSupplierReqBO.setmProvince(selectUserInfoRspBO.getProvinceCode());
        }
        if (!StringUtils.isBlank((CharSequence)selectUserInfoRspBO.getCityCode())) {
            addSupplierReqBO.setmCity(selectUserInfoRspBO.getCityCode());
        }
        if (!StringUtils.isBlank((CharSequence)selectUserInfoRspBO.getDistrictCode())) {
            addSupplierReqBO.setmDistrict(selectUserInfoRspBO.getDistrictCode());
        }
        return this.addSupplierService.addSupplier(addSupplierReqBO);
    }

    @RequestMapping(value={"/commit"})
    @BusiResponseBody
    @BussinessLog(module="\u4f9b\u5e94\u5546\u7ba1\u7406", operat="\u7f16\u8f91")
    public Object updateSupplierService(UpdateSupplierReqBO updateSupplierBOReq) {
        this.updateSupplierService.updateUserByUserId(updateSupplierBOReq);
        return null;
    }

    @RequestMapping(value={"/stop"})
    @BusiResponseBody
    @BussinessLog(module="\u4f9b\u5e94\u5546\u7ba1\u7406", operat="\u505c\u7528")
    public Object stop(SupplierIdBO supplierIdBO) {
        this.stopSupplierService.stopSupplier(supplierIdBO);
        return null;
    }

    @RequestMapping(value={"/reopen"})
    @BusiResponseBody
    @BussinessLog(module="\u4f9b\u5e94\u5546\u7ba1\u7406", operat="\u542f\u7528")
    public Object reopen(SupplierIdBO supplierIdBO) {
        this.reopenSupplierService.reopenSupplier(supplierIdBO);
        return null;
    }

    @RequestMapping(value={"/search"})
    @BusiResponseBody
    public Object selectSearchBySupplierInfoService(SelectSearchBySupplierInfoReqBO selectSearchBySupplierInfoReqBO) {
        UserInfo currentUser = SecurityHelper.getCurrentUser();
        selectSearchBySupplierInfoReqBO.setOrgIdReq(currentUser.getUserId());
        UserIdBO userIdBO = new UserIdBO();
        userIdBO.setUserId(currentUser.getUserId());
        SelectUserInfoRspBO selectUserInfoRspBO = this.selectUserDetailService.selectUserDetailByUserId(userIdBO);
        if (selectUserInfoRspBO != null) {
            if (!StringUtils.isBlank((CharSequence)selectUserInfoRspBO.getProvinceCode())) {
                selectSearchBySupplierInfoReqBO.setmProvince(selectUserInfoRspBO.getProvinceCode());
            }
            if (!StringUtils.isBlank((CharSequence)selectUserInfoRspBO.getCityCode())) {
                selectSearchBySupplierInfoReqBO.setmCity(selectUserInfoRspBO.getCityCode());
            }
            if (!StringUtils.isBlank((CharSequence)selectUserInfoRspBO.getDistrictCode())) {
                selectSearchBySupplierInfoReqBO.setmDistrict(selectUserInfoRspBO.getDistrictCode());
            }
            if (!StringUtils.isBlank((CharSequence)selectUserInfoRspBO.getField2())) {
                selectSearchBySupplierInfoReqBO.setmShopId(selectUserInfoRspBO.getField2());
            }
            selectSearchBySupplierInfoReqBO.setmOrgId(selectUserInfoRspBO.getmOrgId().toString());
            selectSearchBySupplierInfoReqBO.setmUserLevel(selectUserInfoRspBO.getUserLevel());
            return this.selectSearchBySupplierInfoService.selectSearchBySupplierInfo(selectSearchBySupplierInfoReqBO);
        }
        throw new ZTBusinessException("\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a\uff01");
    }

    @RequestMapping(value={"/select"})
    @BusiResponseBody
    public Object select(SupplierIdBO supplierIdBO) {
        return this.selectSupplierDetailService.selectSupplierDetailBySupplierId(supplierIdBO);
    }

    @RequestMapping(value={"/delete"})
    @BusiResponseBody
    @BussinessLog(module="\u4f9b\u5e94\u5546\u7ba1\u7406", operat="\u5220\u9664")
    public Object delete(SupplierIdBO supplierIdBO) {
        this.deleteSupplierService.deleteSupplier(supplierIdBO);
        return null;
    }
}

