/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.common.rsp;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class DictPage<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int pageNo;
    private int pageSize;
    private long total;
    private List<T> rows;

    private DictPage() {
    }

    public static <T> DictPage<T> newInstance(int pageNo, int pageSize) {
        DictPage<T> dictPage = new DictPage<T>();
        dictPage.pageNo = pageNo;
        dictPage.pageSize = pageSize;
        dictPage.total = 0L;
        dictPage.rows = new ArrayList<T>();
        return dictPage;
    }

    public static <T> DictPage<T> newInstance(int pageNo, int pageSize, List<T> rows, long total) {
        DictPage<T> dictPage = new DictPage<T>();
        dictPage.pageNo = pageNo;
        dictPage.pageSize = pageSize;
        dictPage.rows = rows;
        dictPage.total = total;
        return dictPage;
    }

    public int getPageNo() {
        return this.pageNo;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public long getTotal() {
        return this.total;
    }

    public List<T> getRows() {
        return this.rows;
    }

    public void setPageNo(int pageNo) {
        this.pageNo = pageNo;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public void setRows(List<T> rows) {
        this.rows = rows;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DictPage)) {
            return false;
        }
        DictPage other = (DictPage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPageNo() != other.getPageNo()) {
            return false;
        }
        if (this.getPageSize() != other.getPageSize()) {
            return false;
        }
        if (this.getTotal() != other.getTotal()) {
            return false;
        }
        List<T> this$rows = this.getRows();
        List<T> other$rows = other.getRows();
        return !(this$rows == null ? other$rows != null : !((Object)this$rows).equals(other$rows));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DictPage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPageNo();
        result = result * 59 + this.getPageSize();
        long $total = this.getTotal();
        result = result * 59 + (int)($total >>> 32 ^ $total);
        List<T> $rows = this.getRows();
        result = result * 59 + ($rows == null ? 43 : ((Object)$rows).hashCode());
        return result;
    }

    public String toString() {
        return "DictPage(pageNo=" + this.getPageNo() + ", pageSize=" + this.getPageSize() + ", total=" + this.getTotal() + ", rows=" + this.getRows() + ")";
    }
}

