/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.common.rsp;

import java.io.Serializable;

public class DictResult<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SUCCESS_CODE = "0";
    public static final String FAIL_CODE = "1";
    public static final String SUCCESS_MSG = "\u6210\u529f";
    public static final String FAIL_MSG = "\u5931\u8d25";
    private String code;
    private T data;
    private String message;

    private DictResult() {
    }

    public String getCode() {
        return this.code;
    }

    public T getData() {
        return this.data;
    }

    public String getMessage() {
        return this.message;
    }

    private static <T> DictResult<T> builder() {
        return new DictResult<T>();
    }

    public static <T> DictResult<T> success() {
        DictResult<T> builder = DictResult.builder();
        builder.code = SUCCESS_CODE;
        builder.data = null;
        builder.message = SUCCESS_MSG;
        return builder;
    }

    public static <T> DictResult<T> success(T data) {
        DictResult<T> builder = DictResult.builder();
        builder.code = SUCCESS_CODE;
        builder.data = data;
        builder.message = SUCCESS_MSG;
        return builder;
    }

    public static <T> DictResult<T> success(T data, String message) {
        DictResult<T> builder = DictResult.builder();
        builder.code = SUCCESS_CODE;
        builder.data = data;
        builder.message = message;
        return builder;
    }

    public static <T> DictResult<T> error(T data, String message) {
        DictResult<T> builder = DictResult.builder();
        builder.code = FAIL_CODE;
        builder.data = data;
        builder.message = message;
        return builder;
    }

    public static <T> DictResult<T> data(T data, String code, String message) {
        DictResult<T> builder = DictResult.builder();
        builder.code = code;
        builder.data = data;
        builder.message = message;
        return builder;
    }
}

