/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.role.bo;

import com.alibaba.excel.annotation.ExcelProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.poi.ss.util.CellRangeAddress;

@ApiModel(value="\u89d2\u8272\u83dc\u5355\u6743\u9650\u5bfc\u51fa\u5b9e\u4f53")
public class DictRoleMenuExportRspBO
implements Serializable {
    @ApiModelProperty(value="\u884c\u53f7")
    @ExcelProperty(value={"\u5e8f\u53f7"})
    private Integer rowNumber;
    @ApiModelProperty(value="\u89d2\u8272\u540d\u79f0")
    @ExcelProperty(value={"\u89d2\u8272\u540d\u79f0"})
    private String roleName;
    @ApiModelProperty(value="\u4e00\u7ea7\u83dc\u5355")
    @ExcelProperty(value={"\u4e00\u7ea7\u83dc\u5355"})
    private String menuName1;
    @ApiModelProperty(value="\u4e8c\u7ea7\u83dc\u5355")
    @ExcelProperty(value={"\u4e8c\u7ea7\u83dc\u5355"})
    private String menuName2;
    @ApiModelProperty(value="\u4e09\u7ea7\u83dc\u5355")
    @ExcelProperty(value={"\u4e09\u7ea7\u83dc\u5355"})
    private String menuName3;

    public static List<CellRangeAddress> createCellRangeAddressListRoleMenu(List<DictRoleMenuExportRspBO> dataList) {
        ArrayList<CellRangeAddress> cellRangeAddressList = new ArrayList<CellRangeAddress>();
        if (CollectionUtils.isEmpty(dataList)) {
            return cellRangeAddressList;
        }
        List<Integer> mergeCellIndexList = Arrays.asList(1, 2, 3);
        Map<String, Long> roleNameCountMap = dataList.stream().collect(Collectors.groupingBy(DictRoleMenuExportRspBO::getRoleName, Collectors.counting()));
        int lineCount = 1;
        for (Map.Entry<String, Long> roleNameCountEntry : roleNameCountMap.entrySet()) {
            int count = roleNameCountEntry.getValue().intValue();
            if (count > 1) {
                int startRowIndex = lineCount;
                int endRowIndex = lineCount + count - 1;
                for (Integer cellIndex : mergeCellIndexList) {
                    cellRangeAddressList.add(new CellRangeAddress(startRowIndex, endRowIndex, cellIndex.intValue(), cellIndex.intValue()));
                }
            }
            lineCount += count;
        }
        return cellRangeAddressList;
    }

    public Integer getRowNumber() {
        return this.rowNumber;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public String getMenuName1() {
        return this.menuName1;
    }

    public String getMenuName2() {
        return this.menuName2;
    }

    public String getMenuName3() {
        return this.menuName3;
    }

    public void setRowNumber(Integer rowNumber) {
        this.rowNumber = rowNumber;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public void setMenuName1(String menuName1) {
        this.menuName1 = menuName1;
    }

    public void setMenuName2(String menuName2) {
        this.menuName2 = menuName2;
    }

    public void setMenuName3(String menuName3) {
        this.menuName3 = menuName3;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DictRoleMenuExportRspBO)) {
            return false;
        }
        DictRoleMenuExportRspBO other = (DictRoleMenuExportRspBO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$rowNumber = this.getRowNumber();
        Integer other$rowNumber = other.getRowNumber();
        if (this$rowNumber == null ? other$rowNumber != null : !((Object)this$rowNumber).equals(other$rowNumber)) {
            return false;
        }
        String this$roleName = this.getRoleName();
        String other$roleName = other.getRoleName();
        if (this$roleName == null ? other$roleName != null : !this$roleName.equals(other$roleName)) {
            return false;
        }
        String this$menuName1 = this.getMenuName1();
        String other$menuName1 = other.getMenuName1();
        if (this$menuName1 == null ? other$menuName1 != null : !this$menuName1.equals(other$menuName1)) {
            return false;
        }
        String this$menuName2 = this.getMenuName2();
        String other$menuName2 = other.getMenuName2();
        if (this$menuName2 == null ? other$menuName2 != null : !this$menuName2.equals(other$menuName2)) {
            return false;
        }
        String this$menuName3 = this.getMenuName3();
        String other$menuName3 = other.getMenuName3();
        return !(this$menuName3 == null ? other$menuName3 != null : !this$menuName3.equals(other$menuName3));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DictRoleMenuExportRspBO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $rowNumber = this.getRowNumber();
        result = result * 59 + ($rowNumber == null ? 43 : ((Object)$rowNumber).hashCode());
        String $roleName = this.getRoleName();
        result = result * 59 + ($roleName == null ? 43 : $roleName.hashCode());
        String $menuName1 = this.getMenuName1();
        result = result * 59 + ($menuName1 == null ? 43 : $menuName1.hashCode());
        String $menuName2 = this.getMenuName2();
        result = result * 59 + ($menuName2 == null ? 43 : $menuName2.hashCode());
        String $menuName3 = this.getMenuName3();
        result = result * 59 + ($menuName3 == null ? 43 : $menuName3.hashCode());
        return result;
    }

    public String toString() {
        return "DictRoleMenuExportRspBO(rowNumber=" + this.getRowNumber() + ", roleName=" + this.getRoleName() + ", menuName1=" + this.getMenuName1() + ", menuName2=" + this.getMenuName2() + ", menuName3=" + this.getMenuName3() + ")";
    }
}

