/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.util;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.SheetWriteHandler;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteWorkbookHolder;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import com.alibaba.excel.write.style.column.AbstractColumnWidthStyleStrategy;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;

public class ExcelUtils {
    public static void export(HttpServletResponse response, List<ExportBO> exportBOList) throws Exception {
        if (CollectionUtils.isNotEmpty(exportBOList)) {
            ExcelWriter writer = EasyExcel.write((OutputStream)response.getOutputStream()).build();
            exportBOList.stream().map(exportBO -> {
                ExcelWriterSheetBuilder writerSheetBuilder = EasyExcel.writerSheet();
                writerSheetBuilder.registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy());
                writerSheetBuilder.registerWriteHandler((WriteHandler)new AutoCenterStyleStrategy());
                if (StringUtils.isNotBlank((CharSequence)exportBO.getSheetName())) {
                    writerSheetBuilder = EasyExcel.writerSheet((String)exportBO.getSheetName());
                }
                writerSheetBuilder = (ExcelWriterSheetBuilder)writerSheetBuilder.head(exportBO.getExportClazz());
                if (Objects.nonNull(exportBO.getSheetWriteHandler())) {
                    writerSheetBuilder = (ExcelWriterSheetBuilder)writerSheetBuilder.registerWriteHandler((WriteHandler)exportBO.getSheetWriteHandler());
                }
                return Pair.of(exportBO.getDataList(), (Object)writerSheetBuilder.build());
            }).collect(Collectors.toList()).forEach(pair -> writer.write((Collection)pair.getLeft(), (WriteSheet)pair.getRight()));
            writer.finish();
        }
    }

    private static class AutoCenterStyleStrategy
    extends AbstractColumnWidthStyleStrategy {
        private AutoCenterStyleStrategy() {
        }

        protected void setColumnWidth(WriteSheetHolder writeSheetHolder, List<WriteCellData<?>> cellDataList, Cell cell, Head head, Integer relativeRowIndex, Boolean isHead) {
            WriteCellData objectWriteCellData = new WriteCellData();
            WriteCellStyle writeCellStyle = new WriteCellStyle();
            writeCellStyle.setHorizontalAlignment(HorizontalAlignment.CENTER);
            writeCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            objectWriteCellData.setWriteCellStyle(writeCellStyle);
            cellDataList.add(objectWriteCellData);
        }
    }

    public static class AddCellRangeWriteHandler
    implements SheetWriteHandler {
        private final List<CellRangeAddress> cellRangeAddressList;

        public AddCellRangeWriteHandler(List<CellRangeAddress> cellRangeAddressList) {
            this.cellRangeAddressList = cellRangeAddressList;
        }

        public void afterSheetCreate(WriteWorkbookHolder writeWorkbookHolder, WriteSheetHolder writeSheetHolder) {
            if (CollectionUtils.isNotEmpty(this.cellRangeAddressList)) {
                Sheet sheet = writeSheetHolder.getSheet();
                for (CellRangeAddress cellAddresses : this.cellRangeAddressList) {
                    sheet.addMergedRegionUnsafe(cellAddresses);
                }
            }
        }
    }

    public static class ExportBO {
        private List<?> dataList = new ArrayList();
        private SheetWriteHandler sheetWriteHandler;
        private String sheetName;
        private Class<?> exportClazz;

        public List<?> getDataList() {
            return this.dataList;
        }

        public void setDataList(List<?> dataList) {
            this.dataList = dataList;
        }

        public SheetWriteHandler getSheetWriteHandler() {
            return this.sheetWriteHandler;
        }

        public void setSheetWriteHandler(SheetWriteHandler sheetWriteHandler) {
            this.sheetWriteHandler = sheetWriteHandler;
        }

        public String getSheetName() {
            return this.sheetName;
        }

        public void setSheetName(String sheetName) {
            this.sheetName = sheetName;
        }

        public Class<?> getExportClazz() {
            return this.exportClazz;
        }

        public void setExportClazz(Class<?> exportClazz) {
            this.exportClazz = exportClazz;
        }
    }
}

