/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.user;

import com.ohaotian.authority.dao.UserMapper;
import com.ohaotian.authority.po.UserPO;
import com.ohaotian.authority.user.bo.ChangePwdReqBO;
import com.ohaotian.authority.user.service.ChangePwdByUserIdService;
import com.ohaotian.authority.util.SaltUtils;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.DigestUtils;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTH_GROUP_DEV/1.0.0/com.ohaotian.authority.user.service.ChangePwdByUserIdService"})
public class ChangePwdByUserIdServiceImpl
implements ChangePwdByUserIdService {
    private static final Logger log = LoggerFactory.getLogger(ChangePwdByUserIdServiceImpl.class);
    @Autowired
    UserMapper userMapper;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Transactional
    @PostMapping(value={"changePasswordByUserId"})
    public void changePasswordByUserId(@RequestBody ChangePwdReqBO changePwdReqBO) {
        UserPO user = this.userMapper.selectUserInfo(changePwdReqBO.getUserId());
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{user.getInitialPassword()})) {
            if (!changePwdReqBO.getOldPassword().equals(user.getInitialPassword())) throw new ZTBusinessException("\u539f\u5bc6\u7801\u586b\u5199\u9519\u8bef\uff01");
            if (changePwdReqBO.getNewPassword().equals(user.getInitialPassword())) {
                throw new ZTBusinessException("\u65b0\u5bc6\u7801\u4e0e\u539f\u5bc6\u7801\u4e0d\u53ef\u76f8\u540c\uff01");
            }
        } else {
            String oldencrypt = DigestUtils.Encrypt((String)changePwdReqBO.getOldPassword(), (String)"");
            String pwd = DigestUtils.Encrypt((String)(oldencrypt + user.getSalt()), (String)"");
            if (!pwd.equals(user.getPassword())) {
                throw new ZTBusinessException("\u539f\u5bc6\u7801\u586b\u5199\u9519\u8bef\uff01");
            }
            String encrypt = DigestUtils.Encrypt((String)changePwdReqBO.getNewPassword(), (String)"");
            String newpwd = DigestUtils.Encrypt((String)(encrypt + user.getSalt()), (String)"");
            if (newpwd.equals(user.getPassword())) {
                throw new ZTBusinessException("\u65b0\u5bc6\u7801\u4e0e\u539f\u5bc6\u7801\u4e0d\u53ef\u76f8\u540c\uff01");
            }
        }
        String newEncrypt = DigestUtils.Encrypt((String)changePwdReqBO.getNewPassword(), (String)"");
        String newSalt = SaltUtils.getSerialNo(8);
        String newPwd = DigestUtils.Encrypt((String)(newEncrypt + newSalt), (String)"");
        UserPO newUser = new UserPO();
        newUser.setUserId(changePwdReqBO.getUserId());
        newUser.setSalt(newSalt);
        newUser.setPassword(newPwd);
        Date now = new Date();
        newUser.setEffDate(now);
        this.userMapper.updateByPrimaryKeySelective(newUser);
    }
}

