/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.organisation;

import com.ohaotian.authority.constant.Constants;
import com.ohaotian.authority.dao.AuthDistributeMapper;
import com.ohaotian.authority.dao.ManagerOrgMapper;
import com.ohaotian.authority.dao.OrgMenuMapper;
import com.ohaotian.authority.dao.OrgRoleMapper;
import com.ohaotian.authority.dao.OrgRoleMenuMapper;
import com.ohaotian.authority.dao.OrganizationMapper;
import com.ohaotian.authority.dao.ResourceTenantMapper;
import com.ohaotian.authority.dao.RoleMapper;
import com.ohaotian.authority.dao.UserMapper;
import com.ohaotian.authority.organisation.bo.OrganisationIdReqBO;
import com.ohaotian.authority.organisation.service.DeleteOrganizationServer;
import com.ohaotian.authority.po.ManagerOrg;
import com.ohaotian.authority.po.OrgRoleMenuPO;
import com.ohaotian.authority.po.OrganisationPO;
import com.ohaotian.authority.po.ResourceTenantPO;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTH_GROUP_DEV/1.0.0/com.ohaotian.authority.organisation.service.DeleteOrganizationServer"})
public class DeleteOrganizationServerImpl
implements DeleteOrganizationServer {
    private static final Logger log = LoggerFactory.getLogger(DeleteOrganizationServerImpl.class);
    @Autowired
    private OrganizationMapper organizationMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private OrgMenuMapper orgMenuMapper;
    @Autowired
    private OrgRoleMapper orgRoleMapper;
    @Autowired
    private OrgRoleMenuMapper orgRoleMenuMapper;
    @Autowired
    private AuthDistributeMapper authDistributeMapper;
    @Autowired
    private ResourceTenantMapper resourceTenantMapper;
    @Autowired
    private ManagerOrgMapper managerOrgMapper;
    @Autowired
    private RoleMapper roleMapper;
    @Resource(name="dataSend")
    private ProxyMessageProducer dataSend;
    @Value(value="${mq.authority.datasend.topic}")
    private String dataSendTopic;

    @Transactional
    @PostMapping(value={"deleteOrganization"})
    public void deleteOrganization(@RequestBody OrganisationIdReqBO organisationBO) {
        Boolean result = this.organizationMapper.selectOrganisation(organisationBO.getOrganisationId());
        if (result.booleanValue()) {
            throw new ZTBusinessException("\u5f53\u524d\u673a\u6784\u4e0b\u9762\u6709\u5b50\u673a\u6784\u6216\u8005\u7528\u6237\uff0c\u7981\u6b62\u5220\u9664\u8be5\u673a\u6784");
        }
        OrganisationPO organisationPO = this.organizationMapper.selectOrganisationByOrgId(organisationBO.getOrganisationId());
        ManagerOrg managerOrgCondition = new ManagerOrg();
        List<ManagerOrg> orgManagerList = this.managerOrgMapper.getList(managerOrgCondition);
        if (!CollectionUtils.isEmpty(orgManagerList)) {
            for (ManagerOrg po : orgManagerList) {
                int i = this.managerOrgMapper.getCountByUserIdOrgId(po);
                if (i != 0) continue;
                this.userMapper.updateTypeByUserId(organisationPO.getmUserId(), "auth:default:manage");
                this.authDistributeMapper.deleteRoleByUserIdAndRole(organisationPO.getmUserId(), 5L);
            }
        }
        ManagerOrg managerOrg = new ManagerOrg();
        ArrayList<Long> orgIds = new ArrayList<Long>();
        orgIds.add(organisationBO.getOrganisationId());
        managerOrg.setOrgIds(orgIds);
        this.managerOrgMapper.deleteByUserIdOrgIds(managerOrg);
        this.orgMenuMapper.deleteByOrgTreePathAndMenu(organisationPO.getOrgTreePath(), null);
        this.orgRoleMapper.deleteByOrgTreePath(organisationPO.getOrgTreePath(), null);
        OrgRoleMenuPO orgRoleMenuPO = this.orgRoleMenuMapper.selectByOrgTreePathAndMenuId(organisationPO.getOrgTreePath(), null);
        this.orgRoleMenuMapper.deleteByOrgAndRole(organisationPO.getOrgTreePath(), null);
        if (orgRoleMenuPO != null) {
            this.roleMapper.deleteRoleAutoById(orgRoleMenuPO.getRoleAutoId());
        }
        this.authDistributeMapper.deleteByManaOrgTreePathAndRole(organisationPO.getOrgTreePath(), null);
        this.authDistributeMapper.deleteBySingleOrg(organisationPO.getOrgTreePath());
        List<Long> roleIds = this.roleMapper.selectByOrgTreePath(organisationPO.getOrgTreePath());
        if (roleIds != null && roleIds.size() > 0) {
            this.roleMapper.deleteRoleByOrg(roleIds);
        }
        if (!StringUtils.isBlank((CharSequence)organisationPO.getField1())) {
            ResourceTenantPO resourceTenantPO = new ResourceTenantPO();
            resourceTenantPO.setOrgIdWeb(organisationBO.getOrganisationId());
            List<ResourceTenantPO> resultList = this.resourceTenantMapper.selectList(resourceTenantPO);
            if (resultList != null && !resultList.isEmpty()) {
                for (ResourceTenantPO po : resultList) {
                    ResourceTenantPO resourceTenantPO2 = new ResourceTenantPO();
                    resourceTenantPO2.setResTenantId(po.getResTenantId());
                    resourceTenantPO2.setStatus(2);
                    int n = this.resourceTenantMapper.update(resourceTenantPO2);
                }
            }
        }
        this.organizationMapper.deleteOrganization(organisationBO.getOrganisationId());
        ProxyMessage proxyMessage = new ProxyMessage(this.dataSendTopic, "delete_" + Constants.MQ_DATA_SEND_TAG_ORGANISATION + "_" + organisationPO.getTenantId(), organisationBO.getOrganisationId() + "");
        this.dataSend.send(proxyMessage);
    }
}

