/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.station;

import com.ohaotian.authority.dao.StationConfigMapper;
import com.ohaotian.authority.po.StationConfig;
import com.ohaotian.authority.station.bo.AddStationConfigReqBO;
import com.ohaotian.authority.station.service.AddStationConfigService;
import com.ohaotian.plugin.common.util.BeanMapper;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTH_GROUP/1.0.0/com.ohaotian.authority.station.service.AddStationConfigService"})
public class AddStationConfigServiceImpl
implements AddStationConfigService {
    private static final Logger log = LoggerFactory.getLogger(AddStationConfigServiceImpl.class);
    @Autowired
    private StationConfigMapper stationConfigMapper;

    @Transactional
    @PostMapping(value={"addStationConfig"})
    public void addStationConfig(@RequestBody AddStationConfigReqBO stationConfigBO) {
        HashMap<String, Object> record = new HashMap<String, Object>();
        record.put("stationCode", stationConfigBO.getStationCode());
        record.put("busiCode", stationConfigBO.getBusiCode());
        record.put("sourceTypeCode", stationConfigBO.getSourceTypeCode());
        record.put("dataId", stationConfigBO.getDataId());
        List<StationConfig> stationConfigs = this.stationConfigMapper.selectConfigsByRecord(record);
        if (stationConfigs != null && stationConfigs.size() > 0) {
            StationConfig stationConfig = new StationConfig();
            stationConfig.setAuthId(stationConfigs.get(0).getAuthId());
            stationConfig.setDataName(stationConfigBO.getDataName());
            stationConfig.setStatus(0);
            stationConfig.setOperateTime(new Date());
            stationConfig.setOperateUserId(stationConfigBO.getUserId());
            this.stationConfigMapper.updateByPrimaryKey(stationConfig);
        } else {
            StationConfig stationConfig = (StationConfig)BeanMapper.map((Object)stationConfigBO, StationConfig.class);
            stationConfig.setStatus(0);
            stationConfig.setOperateUserId(stationConfigBO.getUserId());
            stationConfig.setOperateTime(new Date());
            this.stationConfigMapper.insert(stationConfig);
        }
    }
}

