/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.role;

import com.ohaotian.authority.constant.Constants;
import com.ohaotian.authority.dao.AuthDistributeMapper;
import com.ohaotian.authority.po.AuthDistribute;
import com.ohaotian.authority.role.bo.HasAndNotGrantRoleBO;
import com.ohaotian.authority.role.bo.SaveOrgGrantUsersReqBO;
import com.ohaotian.authority.role.service.SaveOrgGrantUsersBusiService;
import com.ohaotian.plugin.db.Sequence;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTH_GROUP_DEV/1.0.0/com.ohaotian.authority.role.service.SaveOrgGrantUsersBusiService"})
public class SaveOrgGrantUsersBusiServiceImpl
implements SaveOrgGrantUsersBusiService {
    private static final Logger log = LoggerFactory.getLogger(SaveOrgGrantUsersBusiServiceImpl.class);
    @Autowired
    private AuthDistributeMapper authDistributeMapper;

    @Transactional
    @PostMapping(value={"saveOrgGrantUsers"})
    public void saveOrgGrantUsers(@RequestBody SaveOrgGrantUsersReqBO saveOrgGrantUsersReqBO) {
        List userBOList = saveOrgGrantUsersReqBO.getUserBOList();
        List<HasAndNotGrantRoleBO> hasAndNotGrantRoleBOS = this.authDistributeMapper.selectOrgExtendRoles(saveOrgGrantUsersReqBO.getOrgTreePath());
        userBOList.removeAll(hasAndNotGrantRoleBOS);
        this.authDistributeMapper.deleteBySingleOrg(saveOrgGrantUsersReqBO.getOrgTreePath());
        userBOList.forEach(userBO -> {
            AuthDistribute authDistribute = new AuthDistribute();
            Sequence sequence = Sequence.getInstance();
            long l = sequence.nextId();
            authDistribute.setAuthId(l);
            authDistribute.setDisFlag(Constants.DISTRIBUTE_TYPE_ORG);
            authDistribute.setOrgTreePath(saveOrgGrantUsersReqBO.getOrgTreePath());
            authDistribute.setUserId(userBO.getUserId());
            authDistribute.setRoleId(saveOrgGrantUsersReqBO.getRoleId());
            this.authDistributeMapper.insert(authDistribute);
        });
    }
}

