/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.web.impl.user;

import com.ohaotian.authority.dao.UserMapper;
import com.ohaotian.authority.user.bo.CheckUserLoginReqBO;
import com.ohaotian.authority.user.bo.CheckUserLoginRspBO;
import com.ohaotian.authority.user.bo.SelectUserByLoginNameRspBO;
import com.ohaotian.authority.user.bo.SelectUserInfoWebBO;
import com.ohaotian.authority.user.service.CheckUserLoginWebService;
import com.ohaotian.authority.util.EncryptUtils;
import com.ohaotian.plugin.common.util.BeanMapper;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTH_GROUP_DEV/1.0.0/com.ohaotian.authority.user.service.CheckUserLoginWebService"})
public class CheckUserLoginWebServiceImpl
implements CheckUserLoginWebService {
    private static final Logger log = LoggerFactory.getLogger(CheckUserLoginWebServiceImpl.class);
    Logger logger = LoggerFactory.getLogger(CheckUserLoginWebServiceImpl.class);
    @Autowired
    private UserMapper userMapper;
    @Value(value="${password.encryptType:SHA-256}")
    private String encryptType;
    @Autowired
    private EncryptUtils encryptUtils;

    @PostMapping(value={"checkUserLogin"})
    public CheckUserLoginRspBO checkUserLogin(@RequestBody CheckUserLoginReqBO checkUserLoginReqBO) {
        this.logger.info("CheckUserLoginWebService \u6821\u9a8c\u7528\u6237\u540d\u5bc6\u7801\u5165\u53c2\uff1a" + checkUserLoginReqBO.toString());
        String loginName = checkUserLoginReqBO.getLoginName();
        String password = checkUserLoginReqBO.getPassword();
        String registerType = checkUserLoginReqBO.getRegisterType();
        CheckUserLoginRspBO checkUserLoginRspBO = new CheckUserLoginRspBO();
        checkUserLoginRspBO.setCode("0");
        checkUserLoginRspBO.setMessage("\u6210\u529f");
        try {
            if (StringUtils.isEmpty((CharSequence)loginName) || StringUtils.isEmpty((CharSequence)password) || StringUtils.isEmpty((CharSequence)registerType)) {
                return checkUserLoginRspBO;
            }
            SelectUserByLoginNameRspBO userInfo = this.userMapper.selectUserByLoginName(checkUserLoginReqBO.getLoginName());
            if (userInfo != null) {
                SelectUserInfoWebBO userInfoWebBO = (SelectUserInfoWebBO)BeanMapper.map((Object)userInfo, SelectUserInfoWebBO.class);
                if (!registerType.equals(userInfo.getRegisterType())) {
                    return checkUserLoginRspBO;
                }
                if (StringUtils.isNotEmpty((CharSequence)userInfo.getInitialPassword())) {
                    if (password.equals(userInfo.getInitialPassword())) {
                        checkUserLoginRspBO.setData(userInfoWebBO);
                        return checkUserLoginRspBO;
                    }
                    return checkUserLoginRspBO;
                }
                String encrypt = this.encryptUtils.encryptByType(password, this.encryptType);
                String pwd = this.encryptUtils.encryptByType(encrypt + userInfo.getSalt(), this.encryptType);
                if (pwd.equals(userInfo.getPassword())) {
                    checkUserLoginRspBO.setData(userInfoWebBO);
                    return checkUserLoginRspBO;
                }
                return checkUserLoginRspBO;
            }
            return checkUserLoginRspBO;
        }
        catch (Exception e) {
            checkUserLoginRspBO.setCode("1");
            checkUserLoginRspBO.setMessage("\u5339\u914d\u7528\u6237\u540d\u5bc6\u7801\u670d\u52a1\u9519\u8bef");
            return checkUserLoginRspBO;
        }
    }
}

