/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.busi.impl.manager;

import com.ohaotian.authority.constant.Constants;
import com.ohaotian.authority.dao.ManagerRoleMapper;
import com.ohaotian.authority.dao.MenuMapper;
import com.ohaotian.authority.manager.bo.SelectManagerMenuTreeReqBO;
import com.ohaotian.authority.manager.service.SelectManagerMenuTreeService;
import com.ohaotian.authority.menu.bo.MenuTreeRspBO;
import com.ohaotian.authority.menu.bo.SelectMenuTreeRspBO;
import com.ohaotian.authority.po.Menu;
import com.ohaotian.plugin.common.util.BeanMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTH_GROUP_DEV/1.0.0/com.ohaotian.authority.manager.service.SelectManagerMenuTreeService"})
public class SelectManagerMenuTreeServiceImpl
implements SelectManagerMenuTreeService {
    private static final Logger log = LoggerFactory.getLogger(SelectManagerMenuTreeServiceImpl.class);
    @Autowired
    private MenuMapper menuMapper;
    @Autowired
    private ManagerRoleMapper managerRoleMapper;

    @PostMapping(value={"selectManagerMenuTree"})
    public SelectMenuTreeRspBO selectManagerMenuTree(@RequestBody SelectManagerMenuTreeReqBO selectManagerMenuTreeReqBO) {
        SelectMenuTreeRspBO selectMenuTreeRspBO = new SelectMenuTreeRspBO();
        List<Menu> menus = this.menuMapper.selectMenusByAppCode(selectManagerMenuTreeReqBO.getApplicationCode());
        List<Long> longs = this.managerRoleMapper.selectMenusByRoleIdentity(selectManagerMenuTreeReqBO.getRoleIdentity());
        if (menus != null && menus.size() > 0) {
            LinkedList<MenuTreeRspBO> menuTree = new LinkedList<MenuTreeRspBO>();
            for (Menu menu : menus) {
                MenuTreeRspBO map = (MenuTreeRspBO)BeanMapper.map((Object)menu, MenuTreeRspBO.class);
                if (longs.contains(menu.getMenuId())) {
                    map.setHasSel(Boolean.valueOf(true));
                    map.setFlag(Boolean.valueOf(true));
                }
                menuTree.add(map);
            }
            List<MenuTreeRspBO> menuTreeRspBOS = this.buildByRecursive(menuTree);
            selectMenuTreeRspBO.setMenuTreeRspBOS(menuTreeRspBOS);
        }
        return selectMenuTreeRspBO;
    }

    private List<MenuTreeRspBO> buildByRecursive(List<MenuTreeRspBO> treeNodes) {
        Collections.sort(treeNodes);
        ArrayList<MenuTreeRspBO> trees = new ArrayList<MenuTreeRspBO>();
        for (MenuTreeRspBO treeNode : treeNodes) {
            if (treeNode.getParentId() != null) continue;
            trees.add(this.findChildren(treeNode, treeNodes));
        }
        Collections.sort(trees);
        return trees;
    }

    private MenuTreeRspBO findChildren(MenuTreeRspBO root, List<MenuTreeRspBO> allMenus) {
        for (MenuTreeRspBO it : allMenus) {
            if (!root.getMenuId().equals(it.getParentId())) continue;
            if (root.getChildren() == null) {
                root.setChildren(new ArrayList());
            }
            if (root.getAuthButtons() == null) {
                root.setAuthButtons(new ArrayList());
            }
            if (Constants.MENU_TYPE_F.equals(it.getType())) {
                root.getAuthButtons().add(it);
                continue;
            }
            root.getChildren().add(this.findChildren(it, allMenus));
        }
        return root;
    }
}

